/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.reactive.client.internal;

import java.util.List;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.io.RetainableByteBuffer;
import org.eclipse.jetty.reactive.client.ReactiveResponse;
import org.eclipse.jetty.reactive.client.internal.AbstractBufferingProcessor;

public class ByteArrayBufferingProcessor
extends AbstractBufferingProcessor<byte[]> {
    public ByteArrayBufferingProcessor(ReactiveResponse response, int maxCapacity) {
        super(response, maxCapacity);
    }

    @Override
    protected byte[] process(List<Content.Chunk> chunks) {
        int length = Math.toIntExact(chunks.stream().mapToLong(RetainableByteBuffer::remaining).sum());
        int offset = 0;
        byte[] bytes = new byte[length];
        for (Content.Chunk chunk : chunks) {
            int size = chunk.remaining();
            chunk.getByteBuffer().get(bytes, offset, size);
            offset += size;
            chunk.release();
        }
        return bytes;
    }
}

