/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.reactive.client.internal;

import java.nio.ByteBuffer;
import java.util.List;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.reactive.client.ReactiveResponse;
import org.eclipse.jetty.reactive.client.internal.AbstractBufferingProcessor;

public class ByteBufferBufferingProcessor
extends AbstractBufferingProcessor<ByteBuffer> {
    public ByteBufferBufferingProcessor(ReactiveResponse response, int maxCapacity) {
        super(response, maxCapacity);
    }

    @Override
    protected ByteBuffer process(List<Content.Chunk> chunks) {
        int length = chunks.stream().mapToInt(Content.Chunk::remaining).sum();
        ByteBuffer result = ByteBuffer.allocateDirect(length);
        for (Content.Chunk chunk : chunks) {
            result.put(chunk.getByteBuffer());
            chunk.release();
        }
        return result.flip();
    }
}

