/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.reactive.client.internal;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.reactive.client.ReactiveResponse;
import org.eclipse.jetty.reactive.client.internal.AbstractBufferingProcessor;
import org.eclipse.jetty.reactive.client.internal.ByteArrayBufferingProcessor;

public class StringBufferingProcessor
extends AbstractBufferingProcessor<String> {
    private final ByteArrayBufferingProcessor bytesProcessor;

    public StringBufferingProcessor(ReactiveResponse response, int maxCapacity) {
        super(response, maxCapacity);
        this.bytesProcessor = new ByteArrayBufferingProcessor(response, maxCapacity);
    }

    @Override
    protected String process(List<Content.Chunk> chunks) {
        byte[] bytes = this.bytesProcessor.process(chunks);
        String encoding = Objects.requireNonNullElse(this.getResponse().getEncoding(), StandardCharsets.UTF_8.name());
        return new String(bytes, Charset.forName(encoding));
    }
}

