/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.reactive.client.internal;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.reactive.client.ReactiveResponse;
import org.eclipse.jetty.reactive.client.internal.AbstractSingleProcessor;

public class BufferingProcessor
extends AbstractSingleProcessor<Content.Chunk, String> {
    private final List<Content.Chunk> chunks = new ArrayList<Content.Chunk>();
    private final ReactiveResponse response;

    public BufferingProcessor(ReactiveResponse response) {
        this.response = response;
    }

    public void onNext(Content.Chunk chunk) {
        this.chunks.add(chunk);
        this.upStreamRequest(1L);
    }

    @Override
    public void onComplete() {
        int length = this.chunks.stream().mapToInt(Content.Chunk::remaining).sum();
        byte[] bytes = new byte[length];
        int offset = 0;
        for (Content.Chunk chunk : this.chunks) {
            int l = chunk.remaining();
            chunk.getByteBuffer().get(bytes, offset, l);
            offset += l;
            chunk.release();
        }
        String encoding = this.response.getEncoding();
        if (encoding == null) {
            encoding = StandardCharsets.UTF_8.name();
        }
        this.downStreamOnNext(new String(bytes, Charset.forName(encoding)));
        super.onComplete();
    }
}

