/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.reactive.client.internal;

import org.eclipse.jetty.reactive.client.internal.AbstractSinglePublisher;
import org.reactivestreams.Processor;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public abstract class AbstractSingleProcessor<I, O>
extends AbstractSinglePublisher<O>
implements Processor<I, O> {
    private Subscription upStream;

    protected Subscriber<? super O> downStream() {
        return this.subscriber();
    }

    @Override
    protected void onFailure(Throwable failure) {
        this.cancelUpStream();
        super.onFailure(failure);
    }

    @Override
    public void cancel() {
        this.cancelUpStream();
        super.cancel();
    }

    private void cancelUpStream() {
        Subscription upStream = this.upStream();
        if (upStream != null) {
            upStream.cancel();
        }
    }

    @Override
    protected void onRequest(long n) {
        this.upStream().request(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSubscribe(Subscription subscription) {
        AbstractSingleProcessor abstractSingleProcessor = this;
        synchronized (abstractSingleProcessor) {
            if (this.upStream != null) {
                throw new IllegalStateException("multiple subscriptions not supported");
            }
            if (this.isCancelled()) {
                subscription.cancel();
            } else {
                this.upStream = subscription;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Subscription upStream() {
        AbstractSingleProcessor abstractSingleProcessor = this;
        synchronized (abstractSingleProcessor) {
            return this.upStream;
        }
    }

    public void onError(Throwable throwable) {
        this.downStream().onError(throwable);
    }

    public void onComplete() {
        this.downStream().onComplete();
    }

    @Override
    public String toString() {
        return String.format("%s@%x", this.getClass().getSimpleName(), this.hashCode());
    }
}

