/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.reactive.client.internal;

import java.nio.ByteBuffer;
import java.util.Iterator;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.util.DeferredContentProvider;
import org.eclipse.jetty.reactive.client.ContentChunk;
import org.eclipse.jetty.reactive.client.ReactiveRequest;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class PublisherContentProvider
implements ContentProvider.Typed,
Subscriber<ContentChunk> {
    private final DeferredContentProvider provider = new DeferredContentProvider(new ByteBuffer[0]);
    private final ReactiveRequest.Content content;
    private Subscription subscription;

    public PublisherContentProvider(ReactiveRequest.Content content) {
        this.content = content;
    }

    public long getLength() {
        return this.content.getLength();
    }

    public String getContentType() {
        return this.content.getContentType();
    }

    public Iterator<ByteBuffer> iterator() {
        this.content.subscribe(this);
        return this.provider.iterator();
    }

    public void onSubscribe(Subscription subscription) {
        this.subscription = subscription;
        subscription.request(1L);
    }

    public void onNext(ContentChunk chunk) {
        this.provider.offer(chunk.buffer, chunk.callback);
        this.subscription.request(1L);
    }

    public void onError(Throwable failure) {
    }

    public void onComplete() {
        this.provider.close();
    }
}

