/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.quickstart;

import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.webapp.Descriptor;
import org.eclipse.jetty.webapp.IterativeDescriptorProcessor;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.xml.XmlParser;

public class ExtraXmlDescriptorProcessor
extends IterativeDescriptorProcessor {
    private static final Logger LOG = Log.getLogger(ExtraXmlDescriptorProcessor.class);
    private final StringBuilder _buffer = new StringBuilder();
    private final boolean _showOrigin = LOG.isDebugEnabled();
    private String _origin;

    public ExtraXmlDescriptorProcessor() {
        try {
            this.registerVisitor("env-entry", ((Object)((Object)this)).getClass().getMethod("saveSnippet", __signature));
            this.registerVisitor("resource-ref", ((Object)((Object)this)).getClass().getMethod("saveSnippet", __signature));
            this.registerVisitor("resource-env-ref", ((Object)((Object)this)).getClass().getMethod("saveSnippet", __signature));
            this.registerVisitor("message-destination-ref", ((Object)((Object)this)).getClass().getMethod("saveSnippet", __signature));
            this.registerVisitor("data-source", ((Object)((Object)this)).getClass().getMethod("saveSnippet", __signature));
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public void start(WebAppContext context, Descriptor descriptor) {
        LOG.debug("process {}", new Object[]{descriptor});
        this._origin = "  <!-- " + descriptor + " -->\n";
    }

    public void end(WebAppContext context, Descriptor descriptor) {
    }

    public void saveSnippet(WebAppContext context, Descriptor descriptor, XmlParser.Node node) throws Exception {
        LOG.debug("save {}", new Object[]{node.getTag()});
        if (this._showOrigin) {
            this._buffer.append(this._origin);
        }
        this._buffer.append("  ").append(node.toString()).append("\n");
    }

    public String getXML() {
        return this._buffer.toString();
    }
}

