/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.plus.webapp;

import java.util.Random;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import org.eclipse.jetty.plus.jndi.Transaction;
import org.eclipse.jetty.plus.webapp.EnvConfiguration;
import org.eclipse.jetty.plus.webapp.PlusDecorator;
import org.eclipse.jetty.plus.webapp.PlusDescriptorProcessor;
import org.eclipse.jetty.util.Decorator;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.webapp.AbstractConfiguration;
import org.eclipse.jetty.webapp.DescriptorProcessor;
import org.eclipse.jetty.webapp.FragmentConfiguration;
import org.eclipse.jetty.webapp.JettyWebXmlConfiguration;
import org.eclipse.jetty.webapp.MetaInfConfiguration;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.webapp.WebXmlConfiguration;

public class PlusConfiguration
extends AbstractConfiguration {
    private static final Logger LOG = Log.getLogger(PlusConfiguration.class);
    private Integer _key;

    public PlusConfiguration() {
        this.addDependencies(new Class[]{EnvConfiguration.class, WebXmlConfiguration.class, MetaInfConfiguration.class, FragmentConfiguration.class});
        this.addDependents(new Class[]{JettyWebXmlConfiguration.class});
    }

    public void preConfigure(WebAppContext context) throws Exception {
        context.getObjectFactory().addDecorator((Decorator)new PlusDecorator(context));
    }

    public void cloneConfigure(WebAppContext template, WebAppContext context) throws Exception {
        context.getObjectFactory().addDecorator((Decorator)new PlusDecorator(context));
    }

    public void configure(WebAppContext context) throws Exception {
        this.bindUserTransaction(context);
        context.getMetaData().addDescriptorProcessor((DescriptorProcessor)new PlusDescriptorProcessor());
    }

    public void postConfigure(WebAppContext context) throws Exception {
        this.lockCompEnv(context);
    }

    public void deconfigure(WebAppContext context) throws Exception {
        this.unlockCompEnv(context);
        this._key = null;
        context.setAttribute("org.eclipse.jetty.injectionCollection", null);
        context.setAttribute("org.eclipse.jetty.lifecyleCallbackCollection", null);
    }

    public void bindUserTransaction(WebAppContext context) throws Exception {
        try {
            Transaction.bindToENC();
        }
        catch (NameNotFoundException e) {
            LOG.debug("No Transaction manager found - if your webapp requires one, please configure one.", new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void lockCompEnv(WebAppContext wac) throws Exception {
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(wac.getClassLoader());
        try {
            Random random = new Random();
            this._key = random.nextInt();
            InitialContext context = new InitialContext();
            Context compCtx = (Context)context.lookup("java:comp");
            compCtx.addToEnvironment("org.eclipse.jetty.jndi.lock", this._key);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unlockCompEnv(WebAppContext wac) throws Exception {
        if (this._key != null) {
            ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(wac.getClassLoader());
            try {
                InitialContext context = new InitialContext();
                Context compCtx = (Context)context.lookup("java:comp");
                compCtx.addToEnvironment("org.eclipse.jetty.jndi.unlock", this._key);
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldLoader);
            }
        }
    }
}

