/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.plugins;

import java.util.Map;
import java.util.Set;
import org.eclipse.jetty.plugins.DefaultPluginManager;
import org.eclipse.jetty.plugins.HttpMavenService;
import org.eclipse.jetty.plugins.MavenService;
import org.eclipse.jetty.plugins.PluginManager;

public class Main {
    private static final String JETTY_HOME = "JETTY_HOME";
    private MavenService _mavenService = new HttpMavenService();
    private PluginManager _pluginManager;
    private String _jettyHome;
    private String _installPlugin;
    private boolean _listPlugins;
    private String _repositoryUrl;
    private String _groupId;
    private String _version;
    private boolean _searchRemoteRepository = true;
    private boolean _searchLocalRepository = false;

    public static void main(String[] args) {
        Main main = new Main();
        main.execute(args);
    }

    private void execute(String[] args) {
        this.parseEnvironmentVariables();
        this.parseCommandline(args);
        this.configureMavenService();
        this._pluginManager = new DefaultPluginManager(this._mavenService, this._jettyHome);
        if (this._listPlugins) {
            this.listPlugins();
        } else if (this._installPlugin != null) {
            this.installPlugin();
        }
    }

    private void configureMavenService() {
        if (this._repositoryUrl != null) {
            this._mavenService.setRepositoryUrl(this._repositoryUrl);
        }
        if (this._groupId != null) {
            this._mavenService.setGroupId(this._groupId);
        }
        if (this._version != null) {
            this._mavenService.setVersion(this._version);
        }
        this._mavenService.setSearchLocalRepository(this._searchLocalRepository);
        this._mavenService.setSearchRemoteRepository(this._searchRemoteRepository);
    }

    private void listPlugins() {
        Set<String> availablePlugins = this._pluginManager.listAvailablePlugins();
        for (String pluginName : availablePlugins) {
            System.out.println(pluginName);
        }
    }

    private void installPlugin() {
        this._pluginManager.installPlugin(this._installPlugin);
        System.out.println("Successfully installed plugin: " + this._installPlugin + " to " + this._jettyHome);
    }

    private void parseEnvironmentVariables() {
        Map<String, String> env = System.getenv();
        if (env.containsKey(JETTY_HOME)) {
            this._jettyHome = env.get(JETTY_HOME);
        }
    }

    private void parseCommandline(String[] args) {
        int i = 0;
        for (String arg : args) {
            ++i;
            if (arg.startsWith("--jettyHome=")) {
                this._jettyHome = arg.substring(12);
            }
            if (arg.startsWith("--repositoryUrl=")) {
                this._repositoryUrl = arg.substring(16);
            }
            if (arg.startsWith("--groupId=")) {
                this._groupId = arg.substring(10);
            }
            if (arg.startsWith("--version=")) {
                this._version = arg.substring(10);
            }
            if (arg.startsWith("--useLocalRepo=")) {
                this._searchLocalRepository = Boolean.valueOf(arg.substring(15));
            }
            if (arg.startsWith("--useRemoteRepo=")) {
                this._searchRemoteRepository = Boolean.valueOf(arg.substring(15));
            }
            if (arg.startsWith("install")) {
                this._installPlugin = args[i];
            }
            if (!"list".equals(arg)) continue;
            this._listPlugins = true;
        }
        if (this._jettyHome == null && this._installPlugin != null) {
            this.printUsage("No --jettyHome commandline option specified and no \"JETTY_HOME\" environment variable found!");
        }
        if (this._installPlugin == null && !this._listPlugins) {
            this.printUsage("Neither install <pluginname> nor list commandline option specified. Nothing to do for me!");
        }
        if (this._installPlugin != null && this._listPlugins) {
            this.printUsage("Please specify either install <pluginname> or list commandline options, but not both at the same time!");
        }
    }

    private void printUsage(String errorMessage) {
        System.out.println(errorMessage);
        System.exit(1);
    }
}

