/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.overlays;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import org.eclipse.jetty.deploy.App;
import org.eclipse.jetty.deploy.AppProvider;
import org.eclipse.jetty.deploy.ConfigurationManager;
import org.eclipse.jetty.deploy.DeploymentManager;
import org.eclipse.jetty.jndi.java.javaRootURLContext;
import org.eclipse.jetty.jndi.local.localContextRoot;
import org.eclipse.jetty.overlays.TemplateContext;
import org.eclipse.jetty.server.ResourceCache;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.Scanner;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.JarResource;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceCollection;
import org.eclipse.jetty.util.resource.ResourceFactory;
import org.eclipse.jetty.webapp.WebAppClassLoader;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.xml.XmlConfiguration;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OverlayedAppProvider
extends AbstractLifeCycle
implements AppProvider {
    private static final Logger __log = Log.getLogger((String)"OverlayedAppProvider");
    public static final String CLOUDTIDE_DIR = "cloudtide.dir";
    public static final String CLOUDTIDE_WEBAPP = "cloudtide.webapp";
    public static final String CLOUDTIDE_TEMPLATE = "cloudtide.template";
    public static final String CLOUDTIDE_NODE = "cloudtide.node";
    public static final String CLOUDTIDE_INSTANCE = "cloudtide.instance";
    public static final String WEBAPPS = "webapps";
    public static final String TEMPLATES = "templates";
    public static final String NODES = "nodes";
    public static final String INSTANCES = "instances";
    public static final List<Pattern> __scanPatterns = new ArrayList<Pattern>();
    private String _nodeName;
    private File _scanDir;
    private File _tmpDir;
    private String _scanDirURI;
    private long _loading;
    private Node _node;
    private final Map<String, Webapp> _webapps = new HashMap<String, Webapp>();
    private final Map<String, Template> _templates = new HashMap<String, Template>();
    private final Map<String, Instance> _instances = new HashMap<String, Instance>();
    private final Map<String, OverlayedApp> _deployed = new HashMap<String, OverlayedApp>();
    private final Map<String, TemplateContext> _shared = new HashMap<String, TemplateContext>();
    private boolean _copydir = false;
    private DeploymentManager _deploymentManager;
    private ConfigurationManager _configurationManager;
    private String _serverID = "Server";
    private final Set<Layer> _removedLayers = new HashSet<Layer>();
    private Timer _sessionScavenger = new Timer();
    private final Scanner _scanner = new Scanner();
    private final Scanner.BulkListener _listener = new Scanner.BulkListener(){

        public void filesChanged(List<String> filenames) throws Exception {
            __log.debug("Changed {}", new Object[]{filenames});
            HashSet<String> changes = new HashSet<String>();
            for (String filename : filenames) {
                File file = new File(filename);
                if (file.getName().startsWith(".") || file.getName().endsWith(".swp")) continue;
                String relname = file.toURI().getPath().substring(OverlayedAppProvider.this._scanDirURI.length());
                File rel = new File(relname);
                String dir = null;
                String name = null;
                String parent = rel.getParent();
                while (parent != null) {
                    name = rel.getName();
                    dir = parent;
                    rel = rel.getParentFile();
                    parent = rel.getParent();
                }
                String uri = dir + "/" + name;
                for (Pattern p : __scanPatterns) {
                    if (p.matcher(relname).matches()) {
                        __log.debug("{} == {}", new Object[]{relname, p.pattern()});
                        changes.add(uri);
                        continue;
                    }
                    __log.debug("{} != {}", new Object[]{relname, p.pattern()});
                }
            }
            if (changes.size() > 0) {
                OverlayedAppProvider.this.updateLayers(changes);
            }
        }
    };

    public OverlayedAppProvider() {
        try {
            this._nodeName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            __log.debug((Throwable)e);
            this._nodeName = "unknown";
        }
    }

    public void setDeploymentManager(DeploymentManager deploymentManager) {
        this._deploymentManager = deploymentManager;
    }

    public DeploymentManager getDeploymentManager() {
        return this._deploymentManager;
    }

    public ConfigurationManager getConfigurationManager() {
        return this._configurationManager;
    }

    public void setConfigurationManager(ConfigurationManager configurationManager) {
        this._configurationManager = configurationManager;
    }

    public String getServerID() {
        return this._serverID;
    }

    public void setServerID(String serverID) {
        this._serverID = serverID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ContextHandler createContextHandler(App app) throws Exception {
        OverlayedApp overlayed = (OverlayedApp)app;
        String origin = overlayed.getOriginId();
        Instance instance = overlayed.getInstance();
        Template template = instance.getTemplate();
        Webapp webapp = template.getWebapp();
        Node node = this._node;
        ClassLoader orig_loader = Thread.currentThread().getContextClassLoader();
        try {
            WebAppClassLoader shared_loader;
            String key = (node == null ? "" : node.getLoadedKey()) + template.getLoadedKey() + (webapp == null ? "" : webapp.getLoadedKey());
            instance.setSharedKey(key);
            TemplateContext shared = this._shared.get(key);
            if (shared == null) {
                shared = this.createTemplateContext(key, webapp, template, node, orig_loader);
            }
            Object loader = shared_loader = shared.getWebappLoader() != null ? shared.getWebappLoader() : (shared.getLibLoader() != null ? shared.getLibLoader() : orig_loader);
            Resource instance_lib = instance.getResource("lib");
            if (instance_lib.exists()) {
                ArrayList<URL> libs = new ArrayList<URL>();
                for (String jar : instance_lib.list()) {
                    if (!jar.toLowerCase().endsWith(".jar")) continue;
                    libs.add(instance_lib.addPath(jar).getURL());
                }
                __log.debug("{}: libs={}", new Object[]{origin, libs});
                loader = URLClassLoader.newInstance(libs.toArray(new URL[0]), (ClassLoader)loader);
            }
            Thread.currentThread().setContextClassLoader((ClassLoader)loader);
            Map<String, Object> idMap = new HashMap<String, Object>();
            idMap.putAll(shared.getIdMap());
            idMap.put(this._serverID, this.getDeploymentManager().getServer());
            Object context = null;
            Resource template_context_xml = template.getResource("context.xml");
            if (template_context_xml.exists()) {
                __log.debug("{}: context.xml={}", new Object[]{origin, template_context_xml});
                XmlConfiguration xmlc = this.newXmlConfiguration(template_context_xml.getURL(), idMap, template, instance);
                context = (ContextHandler)xmlc.configure();
                idMap = xmlc.getIdMap();
            } else {
                context = webapp == null ? new ContextHandler() : new WebAppContext();
            }
            Resource instance_webapp = instance.getResource("webapp");
            if (instance_webapp.exists()) {
                context.setBaseResource((Resource)new ResourceCollection(new Resource[]{instance_webapp, shared.getBaseResource()}));
                ResourceCache cache = new ResourceCache(shared.getResourceCache(), (ResourceFactory)instance_webapp, context.getMimeTypes());
                context.setAttribute(ResourceCache.class.getCanonicalName(), (Object)cache);
            } else {
                context.setBaseResource(shared.getBaseResource());
                context.setAttribute(ResourceCache.class.getCanonicalName(), (Object)shared.getResourceCache());
            }
            __log.debug("{}: baseResource={}", new Object[]{origin, context.getResourceBase()});
            context.setAttribute("org.eclipse.jetty.server.session.timer", (Object)this._sessionScavenger);
            for (Resource context_xml : OverlayedAppProvider.getLayeredResources("context.xml", node, instance)) {
                __log.debug("{}: context.xml={}", new Object[]{origin, context_xml});
                XmlConfiguration xmlc = this.newXmlConfiguration(context_xml.getURL(), idMap, template, instance);
                xmlc.getIdMap().put("Cache", context.getAttribute(ResourceCache.class.getCanonicalName()));
                xmlc.configure(context);
                idMap = xmlc.getIdMap();
            }
            if (context instanceof WebAppContext) {
                List<Resource> webdefaults;
                WebAppContext webappcontext = (WebAppContext)context;
                if (Arrays.asList(((WebAppContext)context).getServerClasses()).toString().equals(Arrays.asList(WebAppContext.__dftServerClasses).toString())) {
                    __log.debug("clear server classes", new Object[0]);
                    webappcontext.setServerClasses(null);
                }
                webappcontext.setCopyWebDir(false);
                webappcontext.setCopyWebInf(false);
                webappcontext.setExtractWAR(false);
                if (instance_webapp.exists()) {
                    Resource classes = instance_webapp.addPath("WEB-INF/classes");
                    Resource lib = instance_webapp.addPath("WEB-INF/lib");
                    if (classes.exists() || lib.exists()) {
                        final AtomicBoolean locked = new AtomicBoolean(false);
                        WebAppClassLoader webapp_loader = new WebAppClassLoader((ClassLoader)loader, (WebAppClassLoader.Context)webappcontext){

                            public void addClassPath(Resource resource) throws IOException {
                                if (!locked.get()) {
                                    super.addClassPath(resource);
                                }
                            }

                            public void addClassPath(String classPath) throws IOException {
                                if (!locked.get()) {
                                    super.addClassPath(classPath);
                                }
                            }

                            public void addJars(Resource lib) {
                                if (!locked.get()) {
                                    super.addJars(lib);
                                }
                            }
                        };
                        if (classes.exists()) {
                            webapp_loader.addClassPath(classes);
                        }
                        if (lib.exists()) {
                            webapp_loader.addJars(lib);
                        }
                        locked.set(true);
                        loader = webapp_loader;
                    }
                }
                if (loader == shared_loader) {
                    loader = new URLClassLoader(new URL[0], (ClassLoader)shared_loader);
                }
                if ((webdefaults = OverlayedAppProvider.getLayeredResources("webdefault.xml", instance, node, template)).size() > 0) {
                    Resource webdefault = webdefaults.get(0);
                    __log.debug("{}: defaultweb={}", new Object[]{origin, webdefault});
                    webappcontext.setDefaultsDescriptor(webdefault.toString());
                }
                for (Resource override : OverlayedAppProvider.getLayeredResources("web.xml", template, node, instance)) {
                    __log.debug("{}: web override={}", new Object[]{origin, override});
                    webappcontext.addOverrideDescriptor(override.toString());
                }
            }
            context.setClassLoader((ClassLoader)loader);
            __log.debug("{}: baseResource={}", new Object[]{origin, context.getBaseResource()});
            System.err.println("created:\n" + context.dump());
            ContextHandler contextHandler = context;
            return contextHandler;
        }
        finally {
            Thread.currentThread().setContextClassLoader(orig_loader);
        }
    }

    private XmlConfiguration newXmlConfiguration(URL url, Map<String, Object> idMap, Template template, Instance instance) throws SAXException, IOException {
        XmlConfiguration xmlc = new XmlConfiguration(url);
        xmlc.getProperties().put(CLOUDTIDE_DIR, this._scanDir.getCanonicalPath());
        if (template != null) {
            xmlc.getProperties().put(CLOUDTIDE_TEMPLATE, template.getTemplateName());
            xmlc.getProperties().put(CLOUDTIDE_WEBAPP, template.getWebapp() == null ? null : template.getWebapp().getName());
        }
        if (this._node != null) {
            xmlc.getProperties().put(CLOUDTIDE_NODE, this._node.getName());
        }
        if (instance != null) {
            xmlc.getProperties().put(CLOUDTIDE_INSTANCE, instance.getName());
        }
        if (this.getConfigurationManager() != null) {
            xmlc.getProperties().putAll(this.getConfigurationManager().getProperties());
        }
        xmlc.getIdMap().putAll(idMap);
        return xmlc;
    }

    private TemplateContext createTemplateContext(final String key, Webapp webapp, Template template, Node node, ClassLoader parent) throws Exception {
        ClassLoader libLoader;
        __log.info("created {}", new Object[]{key});
        ArrayList<URL> libs = new ArrayList<URL>();
        for (Resource lib : OverlayedAppProvider.getLayeredResources("lib", node, template)) {
            for (String jar : lib.list()) {
                if (!jar.toLowerCase().endsWith(".jar")) continue;
                libs.add(lib.addPath(jar).getURL());
            }
        }
        if (libs.size() > 0) {
            __log.debug("{}: libs={}", new Object[]{key, libs});
            libLoader = new URLClassLoader(libs.toArray(new URL[0]), parent){

                public String toString() {
                    return "libLoader@" + Long.toHexString(this.hashCode()) + "-lib-" + key;
                }
            };
        } else {
            libLoader = parent;
        }
        Thread.currentThread().setContextClassLoader(libLoader);
        ArrayList<Resource> bases = new ArrayList<Resource>();
        for (Resource wa : OverlayedAppProvider.getLayeredResources("webapp", node, template)) {
            bases.add(wa);
        }
        if (webapp != null) {
            bases.add(webapp.getBaseResource());
        }
        ResourceCollection baseResource = bases.size() == 1 ? (Resource)bases.get(0) : new ResourceCollection(bases.toArray(new Resource[bases.size()]));
        __log.debug("{}: baseResource={}", new Object[]{key, baseResource});
        TemplateContext shared = new TemplateContext(key, this.getDeploymentManager().getServer(), (Resource)baseResource, libLoader);
        this._shared.put(key, shared);
        Map<String, Object> idMap = new HashMap<String, Object>();
        idMap.put(this._serverID, this.getDeploymentManager().getServer());
        for (Resource template_xml : OverlayedAppProvider.getLayeredResources("template.xml", template, node)) {
            __log.debug("{}: template.xml={}", new Object[]{key, template_xml});
            XmlConfiguration xmlc = this.newXmlConfiguration(template_xml.getURL(), idMap, template, null);
            xmlc.getIdMap().putAll(idMap);
            xmlc.configure((Object)shared);
            idMap = xmlc.getIdMap();
        }
        shared.setIdMap(idMap);
        shared.start();
        return shared;
    }

    public String getNodeName() {
        return this._nodeName;
    }

    public void setNodeName(String nodeName) {
        this._nodeName = nodeName;
    }

    public File getScanDir() {
        return this._scanDir;
    }

    public void setScanDir(File scanDir) {
        this._scanDir = scanDir;
    }

    public void setTmpDir(File tmpDir) {
        this._tmpDir = tmpDir;
    }

    public File getTmpDir() {
        return this._tmpDir;
    }

    public int getScanInterval() {
        return this._scanner.getScanInterval();
    }

    public void setScanInterval(int scanInterval) {
        this._scanner.setScanInterval(scanInterval);
    }

    public void scan() {
        this._scanner.scan();
    }

    protected void doStart() throws Exception {
        __log.info("Node={} Scan=", new Object[]{this._nodeName, this._scanDir});
        if (this._scanDir == null || !this._scanDir.exists()) {
            throw new IllegalStateException("!scandir");
        }
        this._scanDirURI = this._scanDir.toURI().getPath();
        this._scanner.setScanDepth(6);
        List<File> dirs = Arrays.asList(new File(this._scanDir, WEBAPPS), new File(this._scanDir, TEMPLATES), new File(this._scanDir, NODES), new File(this._scanDir, INSTANCES));
        for (File file : dirs) {
            if (file.exists() || file.isDirectory()) continue;
            __log.warn("No directory: " + file.getAbsolutePath(), new Object[0]);
        }
        this._scanner.setScanDirs(dirs);
        this._scanner.addListener((Scanner.Listener)this._listener);
        this._scanner.start();
        super.doStart();
    }

    protected void doStop() throws Exception {
        this._scanner.removeListener((Scanner.Listener)this._listener);
        this._scanner.stop();
        if (this._deploymentManager.isRunning()) {
            for (OverlayedApp overlayedApp : this._deployed.values()) {
                this._deploymentManager.removeApp((App)overlayedApp);
            }
        }
        this._deployed.clear();
        for (Webapp webapp : this._webapps.values()) {
            webapp.release();
        }
        this._webapps.clear();
        for (Template template : this._templates.values()) {
            template.release();
        }
        this._templates.clear();
        if (this._node != null) {
            this._node.release();
        }
        for (Instance instance : this._instances.values()) {
            instance.release();
        }
        this._instances.clear();
        super.doStop();
    }

    protected synchronized void updateLayers(Set<String> layerURIs) {
        this._loading = System.currentTimeMillis();
        for (String ruri : layerURIs) {
            try {
                File archive;
                File directory;
                String ext;
                File origin = new File(new URI(this._scanDir.toURI() + ruri));
                String name = origin.getName();
                Monitor monitor = Monitor.valueOf(origin.getParentFile().getName().toUpperCase());
                String string = ext = monitor == Monitor.WEBAPPS ? ".war" : ".jar";
                if (origin.isDirectory() || !origin.exists() && !ruri.toLowerCase().endsWith(ext)) {
                    directory = origin;
                    archive = new File(directory.toString() + ext);
                } else {
                    if (!ruri.toLowerCase().endsWith(ext)) continue;
                    name = name.substring(0, name.length() - 4);
                    archive = origin;
                    directory = new File(new URI(this._scanDir.toURI() + ruri.substring(0, ruri.length() - 4)));
                    if (directory.exists()) {
                        __log.info("Directory exists, ignoring change to {}", new Object[]{ruri});
                        continue;
                    }
                }
                Layer layer = null;
                switch (monitor) {
                    case WEBAPPS: {
                        if (origin.exists()) {
                            layer = this.loadWebapp(name, origin);
                            break;
                        }
                        this.removeWebapp(name);
                        if (origin != directory || !archive.exists()) break;
                        layer = this.loadWebapp(name, archive);
                        break;
                    }
                    case TEMPLATES: {
                        if (origin.exists()) {
                            layer = this.loadTemplate(name, origin);
                            break;
                        }
                        this.removeTemplate(name);
                        if (origin != directory || !archive.exists()) break;
                        layer = this.loadTemplate(name, archive);
                        break;
                    }
                    case NODES: {
                        if (!name.equalsIgnoreCase(this._nodeName)) break;
                        if (origin.exists()) {
                            layer = this.loadNode(origin);
                            break;
                        }
                        this.removeNode();
                        if (origin != directory || !archive.exists()) break;
                        layer = this.loadNode(archive);
                        break;
                    }
                    case INSTANCES: {
                        if (origin.exists()) {
                            layer = this.loadInstance(name, origin);
                            break;
                        }
                        this.removeInstance(name);
                        if (origin != directory || !archive.exists()) break;
                        layer = this.loadInstance(name, archive);
                    }
                }
                if (layer == null) continue;
                __log.info("loaded {}", new Object[]{layer.getLoadedKey()});
            }
            catch (Exception e) {
                __log.warn((Throwable)e);
            }
        }
        this.redeploy();
        for (Layer layer : this._removedLayers) {
            if (layer == null) continue;
            __log.info("unload {}", new Object[]{layer.getLoadedKey()});
            layer.release();
        }
        this._removedLayers.clear();
        if (__log.isDebugEnabled()) {
            System.err.println("updated:");
            System.err.println("java:" + javaRootURLContext.getRoot().dump());
            System.err.println("local:" + localContextRoot.getRoot().dump());
            if (this.getDeploymentManager() != null && this.getDeploymentManager().getServer() != null) {
                System.err.println(this.getDeploymentManager().getServer().dump());
            }
        }
    }

    protected File tmpdir(String name, String suffix) throws IOException {
        File dir = this._tmpDir;
        if (!(dir != null && dir.isDirectory() && dir.canWrite() || (dir = new File(this._scanDir, "tmp")).isDirectory() && dir.canWrite())) {
            dir = null;
        }
        File tmp = File.createTempFile(name + "_", "." + suffix, dir);
        if ((tmp = tmp.getCanonicalFile()).exists()) {
            IO.delete((File)tmp);
        }
        tmp.mkdir();
        tmp.deleteOnExit();
        return tmp;
    }

    protected void redeploy() {
        App app;
        ConcurrentHashMap<String, Template> templates = new ConcurrentHashMap<String, Template>();
        for (Template template : this._templates.values()) {
            Template other = (Template)templates.get(template.getTemplateName());
            if (other != null) {
                __log.warn("Multiple Templates: {} & {}", new Object[]{template.getName(), other.getName()});
                if (other.getName().compareToIgnoreCase(template.getName()) <= 0) continue;
            }
            templates.put(template.getTemplateName(), template);
        }
        for (Template template : templates.values()) {
            String webappname = template.getClassifier();
            if (webappname == null) continue;
            Webapp webapp = this._webapps.get(webappname);
            if (webapp == null) {
                __log.warn("No webapp found for template: {}", new Object[]{template.getName()});
                templates.remove(template.getTemplateName());
                continue;
            }
            template.setWebapp(webapp);
        }
        HashSet<String> deployed = new HashSet<String>();
        ArrayList<Instance> deploy = new ArrayList<Instance>();
        for (Instance instance : this._instances.values()) {
            Template template = (Template)templates.get(instance.getTemplateName());
            instance.setTemplate(template);
            if (template == null) continue;
            String string = instance.getInstanceKey();
            app = this._deployed.get(string);
            if (app == null) {
                deploy.add(instance);
                continue;
            }
            deployed.add(string);
        }
        ArrayList<String> undeploy = new ArrayList<String>();
        for (String key2 : this._deployed.keySet()) {
            if (deployed.contains(key2)) continue;
            undeploy.add(key2);
        }
        for (String key : undeploy) {
            App app2 = this._deployed.remove(key);
            if (app2 == null) continue;
            __log.info("Undeploy {}", new Object[]{key});
            this._deploymentManager.removeApp(app2);
        }
        for (Instance instance : deploy) {
            String string = instance.getInstanceKey();
            app = new OverlayedApp(this._deploymentManager, this, string, instance);
            this._deployed.put(string, (OverlayedApp)app);
        }
        HashSet<String> sharedKeys = new HashSet<String>(this._shared.keySet());
        for (OverlayedApp overlayedApp : this._deployed.values()) {
            Instance instance = overlayedApp.getInstance();
            sharedKeys.remove(instance.getSharedKey());
        }
        for (String string : sharedKeys) {
            __log.debug("Remove " + string, new Object[0]);
            TemplateContext shared = this._shared.remove(string);
            if (shared == null) continue;
            try {
                shared.stop();
            }
            catch (Exception e) {
                __log.warn((Throwable)e);
            }
            shared.destroy();
        }
        for (Instance instance : deploy) {
            String key3 = instance.getInstanceKey();
            OverlayedApp app3 = this._deployed.get(key3);
            __log.info("Deploy {}", new Object[]{key3});
            this._deploymentManager.addApp((App)app3);
        }
    }

    protected void removeInstance(String name) {
        this._removedLayers.add(this._instances.remove(name));
    }

    protected Instance loadInstance(String name, File origin) throws IOException {
        Instance instance = new Instance(name, origin);
        this._removedLayers.add(this._instances.put(name, instance));
        return instance;
    }

    protected void removeNode() {
        if (this._node != null) {
            this._removedLayers.add(this._node);
        }
        this._node = null;
    }

    protected Node loadNode(File origin) throws IOException {
        if (this._node != null) {
            this._removedLayers.add(this._node);
        }
        this._node = new Node(this._nodeName, origin);
        return this._node;
    }

    protected void removeTemplate(String name) {
        this._removedLayers.add(this._templates.remove(name));
    }

    protected Template loadTemplate(String name, File origin) throws IOException {
        Template template = new Template(name, origin);
        this._removedLayers.add(this._templates.put(name, template));
        return template;
    }

    protected void removeWebapp(String name) {
        this._removedLayers.add(this._webapps.remove(name));
    }

    protected Webapp loadWebapp(String name, File origin) throws IOException {
        Webapp webapp = new Webapp(name, origin);
        this._removedLayers.add(this._webapps.put(name, webapp));
        return webapp;
    }

    private static List<Resource> getLayeredResources(String path, Layer ... layers) {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        for (Layer layer : layers) {
            Resource resource;
            if (layer == null || !(resource = layer.getResource(path)).exists()) continue;
            resources.add(resource);
        }
        return resources;
    }

    static {
        ArrayList<String> regexes = new ArrayList<String>();
        regexes.add("webapps/[^/]*/");
        regexes.add("templates/[^/]*/");
        regexes.add("nodes/[^/]*/");
        regexes.add("instances/[^/]*/");
        regexes.add("webapps/[^/]*");
        regexes.add("templates/[^/]*");
        regexes.add("nodes/[^/]*");
        regexes.add("instances/[^/]*");
        regexes.add("templates/[^/]*/[^/]+");
        regexes.add("nodes/[^/]*/[^/]+");
        regexes.add("instances/[^/]*/[^/]+");
        regexes.add("templates/[^/]*/lib/[^/]+");
        regexes.add("nodes/[^/]*/lib/[^/]+");
        regexes.add("instances/[^/]*/lib/[^/]+");
        for (String s : new String[]{"/WEB-INF/lib/[^/]*", "/WEB-INF/classes/[^/]*", "/WEB-INF/[^/]*\\.xml"}) {
            regexes.add("webapps/[^/]*" + s);
            regexes.add("templates/[^/]*/webapp" + s);
            regexes.add("nodes/[^/]*/webapp" + s);
            regexes.add("instances/[^/]*/webapp" + s);
        }
        for (String s : regexes) {
            __scanPatterns.add(Pattern.compile(s, 2));
        }
    }

    static class OverlayedApp
    extends App {
        final Instance _instance;

        public OverlayedApp(DeploymentManager manager, AppProvider provider, String originId, Instance instance) {
            super(manager, provider, originId);
            this._instance = instance;
        }

        public Instance getInstance() {
            return this._instance;
        }
    }

    class Instance
    extends ClassifiedOverlay {
        Template _template;
        String _sharedKey;

        public Instance(String name, File origin) throws IOException {
            super(name, origin);
            if (this.getClassifier() == null) {
                throw new IllegalArgumentException("Instance without '=':" + name);
            }
        }

        public void setSharedKey(String key) {
            this._sharedKey = key;
        }

        public String getSharedKey() {
            return this._sharedKey;
        }

        public void setTemplate(Template template) {
            this._template = template;
        }

        public Template getTemplate() {
            return this._template;
        }

        public String getInstanceKey() {
            return (this._template.getWebapp() == null ? "" : this._template.getWebapp().getLoadedKey()) + "|" + this._template.getLoadedKey() + "|" + (OverlayedAppProvider.this._node == null ? "" : OverlayedAppProvider.this._node.getLoadedKey()) + "|" + this.getLoadedKey();
        }
    }

    class Template
    extends ClassifiedOverlay {
        private Webapp _webapp;

        public Webapp getWebapp() {
            return this._webapp;
        }

        public void setWebapp(Webapp webapp) {
            this._webapp = webapp;
        }

        public Template(String name, File origin) throws IOException {
            super(name, origin);
        }
    }

    class ClassifiedOverlay
    extends Overlay {
        private final String _templateName;
        private final String _classifier;

        public ClassifiedOverlay(String name, File origin) throws IOException {
            super(name, origin);
            int e = name.indexOf(61);
            this._templateName = e >= 0 ? name.substring(0, e) : name;
            this._classifier = e >= 0 ? name.substring(e + 1) : null;
        }

        public String getTemplateName() {
            return this._templateName;
        }

        public String getClassifier() {
            return this._classifier;
        }
    }

    class Node
    extends Overlay {
        public Node(String name, File origin) throws IOException {
            super(name, origin);
        }
    }

    class Overlay
    extends Layer {
        public Overlay(String name, File origin) throws IOException {
            super(name, origin);
        }

        public Resource getContext() {
            return this.getResource("context.xml");
        }
    }

    class Webapp
    extends Layer {
        public Webapp(String name, File origin) throws IOException {
            super(name, origin);
        }
    }

    class Layer {
        private final String _name;
        private final File _origin;
        private final long _loaded;
        private final Resource _resourceBase;
        private final boolean _resourceBaseIsCopy;

        public Layer(String name, File origin) throws IOException {
            this._loaded = OverlayedAppProvider.this._loading;
            this._name = name;
            this._origin = origin;
            Resource resource = Resource.newResource((URI)origin.toURI());
            if (resource.isDirectory()) {
                if (OverlayedAppProvider.this._copydir) {
                    File tmp = OverlayedAppProvider.this.tmpdir(name, "extract");
                    __log.info("Extract {} to {}", new Object[]{origin, tmp});
                    IO.copyDir((File)origin, (File)tmp);
                    this._resourceBase = Resource.newResource((URI)tmp.toURI());
                    this._resourceBaseIsCopy = true;
                } else {
                    this._resourceBase = resource;
                    this._resourceBaseIsCopy = false;
                }
            } else {
                Resource jar = JarResource.newJarResource((Resource)resource);
                File tmp = OverlayedAppProvider.this.tmpdir(name, "extract");
                __log.info("Extract {} to {}", new Object[]{jar, tmp});
                jar.copyTo(tmp);
                this._resourceBase = Resource.newResource((URI)tmp.toURI());
                this._resourceBaseIsCopy = true;
            }
        }

        public String getName() {
            return this._name;
        }

        public File getOrigin() {
            return this._origin;
        }

        public long getLoaded() {
            return this._loaded;
        }

        public Resource getBaseResource() {
            return this._resourceBase;
        }

        public Resource getResource(String path) {
            try {
                return this.getBaseResource().addPath(path);
            }
            catch (Exception e) {
                __log.warn((Throwable)e);
                return null;
            }
        }

        public String getLoadedKey() {
            return this._name + "@" + this._loaded;
        }

        public void release() {
            if (this._resourceBaseIsCopy) {
                try {
                    File file = this._resourceBase.getFile();
                    if (file != null) {
                        IO.delete((File)file);
                    }
                }
                catch (Exception e) {
                    __log.warn((Throwable)e);
                }
            }
        }

        public String toString() {
            return this.getLoadedKey();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Monitor {
        WEBAPPS,
        TEMPLATES,
        NODES,
        INSTANCES;

    }
}

