/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.osgi;

import java.util.Objects;
import org.eclipse.jetty.deploy.Deployer;
import org.eclipse.jetty.osgi.BundleMetadata;
import org.eclipse.jetty.osgi.ContextFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.Attributes;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;

public abstract class AbstractContextProvider
extends AbstractLifeCycle {
    private final Server _server;
    private final Deployer _deployer;
    private ContextFactory _contextFactory;
    private String _environment;
    private final Attributes _attributes = new Attributes.Mapped();

    public AbstractContextProvider(Server server, Deployer deployer, String environment, ContextFactory contextFactory) {
        this._server = server;
        this._deployer = deployer;
        this._environment = Objects.requireNonNull(environment);
        this._contextFactory = Objects.requireNonNull(contextFactory);
    }

    public Server getServer() {
        return this._server;
    }

    public Attributes getAttributes() {
        return this._attributes;
    }

    public ContextHandler createContextHandler(BundleMetadata metadata) throws Exception {
        if (metadata == null) {
            return null;
        }
        return this._contextFactory.createContextHandler(this, metadata);
    }

    public String getEnvironmentName() {
        return this._environment;
    }

    public Deployer getContextHandlerManagement() {
        return this._deployer;
    }

    public void setTldBundles(String tldBundles) {
        this._attributes.setAttribute("Require-TldBundle", (Object)tldBundles);
    }

    public String getTldBundles() {
        return (String)this._attributes.getAttribute("Require-TldBundle");
    }

    public boolean isDeployable(Bundle bundle) {
        if (bundle == null) {
            return false;
        }
        return this.getEnvironmentName().equalsIgnoreCase((String)bundle.getHeaders().get("Jetty-Environment"));
    }

    public boolean isDeployable(ServiceReference<?> service) {
        if (service == null) {
            return false;
        }
        if (!StringUtil.isBlank((String)((String)service.getProperty("o.e.j.o.b.watermark")))) {
            return false;
        }
        return this.getEnvironmentName().equalsIgnoreCase((String)service.getProperty("Jetty-Environment"));
    }
}

