/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.monitor.triggers;

import java.util.Arrays;
import java.util.List;
import org.eclipse.jetty.monitor.jmx.EventState;
import org.eclipse.jetty.monitor.jmx.EventTrigger;

public class OrEventTrigger
extends EventTrigger {
    private final List<EventTrigger> _triggers;

    public OrEventTrigger(List<EventTrigger> triggers) {
        this._triggers = triggers;
    }

    public OrEventTrigger(EventTrigger ... triggers) {
        this._triggers = Arrays.asList(triggers);
    }

    @Override
    public boolean match(long timestamp) throws Exception {
        for (EventTrigger trigger : this._triggers) {
            if (!trigger.match(timestamp)) continue;
            return true;
        }
        return false;
    }

    public EventState getState(long timestamp) {
        EventState state = new EventState();
        for (EventTrigger trigger : this._triggers) {
            EventState<?> subState = trigger.getState(timestamp);
            if (subState == null) continue;
            state.addAll(subState.values());
        }
        return state;
    }

    public String toString() {
        int cnt = 0;
        StringBuilder result = new StringBuilder();
        result.append("OR(");
        for (EventTrigger trigger : this._triggers) {
            result.append(cnt++ > 0 ? "," : "");
            result.append(trigger);
        }
        result.append(')');
        return result.toString();
    }
}

