/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.monitor.thread;

public class ThreadMonitorInfo {
    private Thread _thread;
    private StackTraceElement[] _stackTrace;
    private boolean _threadSpinning = false;
    private int _traceCount = -1;
    private long _prevCpuTime;
    private long _prevSampleTime;
    private long _currCpuTime;
    private long _currSampleTime;

    public ThreadMonitorInfo(Thread thread) {
        this._thread = thread;
    }

    public long getThreadId() {
        return this._thread.getId();
    }

    public String getThreadName() {
        return this._thread.getName();
    }

    public String getThreadState() {
        return this._thread.getState().toString();
    }

    public StackTraceElement[] getStackTrace() {
        return this._stackTrace;
    }

    public void setStackTrace(StackTraceElement[] stackTrace) {
        this._stackTrace = stackTrace;
    }

    public boolean isSpinning() {
        return this._threadSpinning;
    }

    public void setSpinning(boolean value) {
        this._threadSpinning = value;
    }

    public void setTraceCount(int traceCount) {
        this._traceCount = traceCount;
    }

    public int getTraceCount() {
        return this._traceCount;
    }

    public long getCpuTime() {
        return this._currCpuTime;
    }

    public void setCpuTime(long ns) {
        this._prevCpuTime = this._currCpuTime;
        this._currCpuTime = ns;
    }

    public long getSampleTime() {
        return this._currSampleTime;
    }

    public void setSampleTime(long ns) {
        this._prevSampleTime = this._currSampleTime;
        this._currSampleTime = ns;
    }

    public float getCpuUtilization() {
        long elapsedCpuTime = this._currCpuTime - this._prevCpuTime;
        long elapsedNanoTime = this._currSampleTime - this._prevSampleTime;
        return elapsedNanoTime > 0L ? Math.min((float)elapsedCpuTime * 100.0f / (float)elapsedNanoTime, 100.0f) : 0.0f;
    }
}

