/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.monitor.integration;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.net.URL;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.eclipse.jetty.client.ContentExchange;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.ByteArrayBuffer;
import org.eclipse.jetty.monitor.JMXMonitor;
import org.eclipse.jetty.monitor.integration.JavaMonitorTrigger;
import org.eclipse.jetty.monitor.jmx.EventNotifier;
import org.eclipse.jetty.monitor.jmx.EventState;
import org.eclipse.jetty.monitor.jmx.EventTrigger;
import org.eclipse.jetty.monitor.jmx.MonitorAction;
import org.eclipse.jetty.monitor.triggers.AggregateEventTrigger;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class JavaMonitorAction
extends MonitorAction {
    private static final Logger LOG = Log.getLogger(JavaMonitorAction.class);
    private final HttpClient _client;
    private final String _url;
    private final String _uuid;
    private final String _appid;
    private String _srvip;
    private String _session;

    public JavaMonitorAction(EventNotifier notifier, String url, String uuid, String appid, long pollInterval) throws Exception {
        super(new AggregateEventTrigger(), notifier, pollInterval);
        this._url = url;
        this._uuid = uuid;
        this._appid = appid;
        this._client = new HttpClient();
        this._client.setTimeout(60000L);
        this._client.setConnectorType(2);
        try {
            this._client.start();
            this._srvip = this.getServerIP();
        }
        catch (Exception ex) {
            LOG.debug((Throwable)ex);
        }
        this.sendData(new Properties());
    }

    @Override
    public void execute(EventTrigger trigger, EventState<?> state, long timestamp) {
        this.exec(trigger, state, timestamp);
    }

    private <T> void exec(EventTrigger trigger, EventState<T> state, long timestamp) {
        Collection<EventState.TriggerState<T>> trs = state.values();
        Properties data = new Properties();
        for (EventState.TriggerState<T> ts : trs) {
            T value = ts.getValue();
            StringBuffer buffer = new StringBuffer();
            buffer.append(value == null ? "" : value.toString());
            buffer.append("|");
            buffer.append(this.getClassID(value));
            buffer.append("||");
            buffer.append(ts.getDescription());
            data.setProperty(ts.getID(), buffer.toString());
            try {
                this.sendData(data);
            }
            catch (Exception ex) {
                LOG.debug((Throwable)ex);
            }
        }
    }

    private void sendData(Properties data) throws Exception {
        data.put("account", this._uuid);
        data.put("appserver", "Jetty");
        data.put("localIp", this._srvip);
        if (this._appid == null) {
            data.put("lowestPort", this.getHttpPort());
        } else {
            data.put("lowestPort", this._appid);
        }
        if (this._session != null) {
            data.put("session", this._session);
        }
        Properties response = this.sendRequest(data);
        this.parseResponse(response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties sendRequest(Properties request) throws Exception {
        ByteArrayOutputStream reqStream = null;
        ByteArrayInputStream resStream = null;
        Properties response = null;
        try {
            ContentExchange reqEx = new ContentExchange();
            reqEx.setURL(this._url);
            reqEx.setMethod("POST");
            reqEx.addRequestHeader("Connection", "close");
            reqStream = new ByteArrayOutputStream();
            request.storeToXML(reqStream, null);
            ByteArrayBuffer reqBuff = new ByteArrayBuffer(reqStream.toByteArray());
            reqEx.setRequestContent((Buffer)reqBuff);
            this._client.send((HttpExchange)reqEx);
            reqEx.waitForDone();
            if (reqEx.getResponseStatus() == 200) {
                response = new Properties();
                resStream = new ByteArrayInputStream(reqEx.getResponseContentBytes());
                response.loadFromXML(resStream);
            }
        }
        finally {
            try {
                if (reqStream != null) {
                    reqStream.close();
                }
            }
            catch (IOException ex) {
                LOG.ignore((Throwable)ex);
            }
            try {
                if (resStream != null) {
                    resStream.close();
                }
            }
            catch (IOException ex) {
                LOG.ignore((Throwable)ex);
            }
        }
        return response;
    }

    private void parseResponse(Properties response) {
        if (response.get("onhold") != null) {
            throw new Error("Suspended");
        }
        if (response.get("session") != null) {
            this._session = (String)response.remove("session");
            AggregateEventTrigger trigger = (AggregateEventTrigger)this.getTrigger();
            for (Map.Entry<Object, Object> entry : response.entrySet()) {
                String[] values = ((String)entry.getValue()).split("\\|");
                String queryString = values[0];
                if (queryString.startsWith("com.javamonitor.openfire")) continue;
                if (queryString.startsWith("com.javamonitor")) {
                    queryString = "org.eclipse.jetty.monitor.integration:type=javamonitortools,id=0";
                }
                ObjectName[] queryResults = null;
                try {
                    queryResults = this.queryNames(queryString);
                }
                catch (IOException e) {
                    LOG.debug((Throwable)e);
                }
                catch (MalformedObjectNameException e) {
                    LOG.debug((Throwable)e);
                }
                if (queryResults == null) continue;
                int idx = 0;
                for (ObjectName objName : queryResults) {
                    String id = entry.getKey().toString() + (idx == 0 ? "" : ":" + idx);
                    String name = queryString.equals(objName.toString()) ? "" : objName.toString();
                    boolean repeat = Boolean.parseBoolean(values[2]);
                    trigger.add(new JavaMonitorTrigger(objName, values[1], id, name, repeat));
                }
            }
        }
    }

    private int getClassID(Object value) {
        if (value == null) {
            return 0;
        }
        if (value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long) {
            return 1;
        }
        if (value instanceof Float || value instanceof Double) {
            return 2;
        }
        if (value instanceof Boolean) {
            return 3;
        }
        return 4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getServerIP() throws Exception {
        Socket s = null;
        try {
            if (System.getProperty("http.proxyHost") != null) {
                s = new Socket(System.getProperty("http.proxyHost"), Integer.parseInt(System.getProperty("http.proxyPort", "80")));
            } else {
                int port = 80;
                URL url = new URL(this._url);
                if (url.getPort() != -1) {
                    port = url.getPort();
                }
                s = new Socket(url.getHost(), port);
            }
            String string = s.getLocalAddress().getHostAddress();
            return string;
        }
        finally {
            try {
                if (s != null) {
                    s.close();
                }
            }
            catch (IOException ex) {
                LOG.ignore((Throwable)ex);
            }
        }
    }

    public Integer getHttpPort() {
        Set<ObjectName> connectors = null;
        try {
            MBeanServerConnection service = JMXMonitor.getServiceConnection();
            connectors = service.queryNames(new ObjectName("org.eclipse.jetty.nio:type=selectchannelconnector,*"), null);
            if (connectors != null && connectors.size() > 0) {
                Integer lowest = Integer.MAX_VALUE;
                for (ObjectName connector : connectors) {
                    lowest = (Integer)service.getAttribute(connector, "port");
                }
                if (lowest < Integer.MAX_VALUE) {
                    return lowest;
                }
            }
        }
        catch (Exception ex) {
            LOG.debug((Throwable)ex);
        }
        return 0;
    }

    private ObjectName[] queryNames(ObjectName param) throws IOException, MalformedObjectNameException {
        ObjectName[] result = null;
        MBeanServerConnection connection = JMXMonitor.getServiceConnection();
        Set<ObjectName> names = connection.queryNames(param, null);
        if (names != null && names.size() > 0) {
            result = new ObjectName[names.size()];
            int idx = 0;
            for (ObjectName name : names) {
                if (name instanceof ObjectName) {
                    result[idx++] = name;
                    continue;
                }
                result[idx++] = new ObjectName(((Object)name).toString());
            }
        }
        return result;
    }

    private ObjectName[] queryNames(String param) throws IOException, MalformedObjectNameException {
        return this.queryNames(new ObjectName(param));
    }
}

