/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.monitor;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jetty.monitor.ThreadMonitorException;
import org.eclipse.jetty.monitor.ThreadMonitorInfo;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class ThreadMonitor
extends AbstractLifeCycle
implements Runnable {
    private int _scanInterval;
    private int _logInterval;
    private int _busyThreshold;
    private int _logThreshold;
    private int _stackDepth;
    private int _trailLength;
    private ThreadMXBean _threadBean;
    private Thread _runner;
    private Logger _logger;
    private volatile boolean _done = true;
    private Dumpable _dumpable;
    private Map<Long, ThreadMonitorInfo> _monitorInfo;

    public ThreadMonitor() throws Exception {
        this(5000);
    }

    public ThreadMonitor(int intervalMs) throws Exception {
        this(intervalMs, 95);
    }

    public ThreadMonitor(int intervalMs, int threshold) throws Exception {
        this(intervalMs, threshold, 3);
    }

    public ThreadMonitor(int intervalMs, int threshold, int depth) throws Exception {
        this(intervalMs, threshold, depth, 3);
    }

    public ThreadMonitor(int intervalMs, int threshold, int depth, int trail) throws Exception {
        this._scanInterval = intervalMs;
        this._busyThreshold = threshold;
        this._stackDepth = depth;
        this._trailLength = trail;
        this._logger = Log.getLogger((String)ThreadMonitor.class.getName());
        this._monitorInfo = new HashMap<Long, ThreadMonitorInfo>();
        this.init();
    }

    public int getScanInterval() {
        return this._scanInterval;
    }

    public void setScanInterval(int ms) {
        this._scanInterval = ms;
    }

    public int getLogInterval() {
        return this._logInterval;
    }

    public void setLogInterval(int ms) {
        this._logInterval = ms;
    }

    public int getBusyThreshold() {
        return this._busyThreshold;
    }

    public void setBusyThreshold(int percent) {
        this._busyThreshold = percent;
    }

    public int getLogThreshold() {
        return this._logThreshold;
    }

    public void setLogThreshold(int percent) {
        this._logThreshold = percent;
    }

    public int getStackDepth() {
        return this._stackDepth;
    }

    public void setStackDepth(int stackDepth) {
        this._stackDepth = stackDepth;
    }

    public void setTrailLength(int trailLength) {
        this._trailLength = trailLength;
    }

    public int getTrailLength() {
        return this._trailLength;
    }

    public void logCpuUsage(int frequencyMs, int thresholdPercent) {
        this.setLogInterval(frequencyMs);
        this.setLogThreshold(thresholdPercent);
    }

    public Dumpable getDumpable() {
        return this._dumpable;
    }

    public void setDumpable(Dumpable dumpable) {
        this._dumpable = dumpable;
    }

    public void doStart() {
        this._done = false;
        this._runner = new Thread(this);
        this._runner.setDaemon(true);
        this._runner.start();
        Log.info((String)"Thread Monitor started successfully");
    }

    public void doStop() {
        if (this._runner != null) {
            this._done = true;
            try {
                this._runner.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    protected long[] getAllThreadIds() {
        return this._threadBean.getAllThreadIds();
    }

    protected long getThreadCpuTime(long id) {
        return this._threadBean.getThreadCpuTime(id);
    }

    protected void init() {
        this._threadBean = ManagementFactory.getThreadMXBean();
        if (this._threadBean.isThreadCpuTimeSupported()) {
            this._threadBean.setThreadCpuTimeEnabled(true);
        }
    }

    public void run() {
        boolean repeat = false;
        long nextScanTime = System.currentTimeMillis();
        long nextLogTime = nextScanTime + (long)this._logInterval;
        while (!this._done) {
            boolean logNow;
            long currTime = System.currentTimeMillis();
            boolean scanNow = currTime > nextScanTime;
            boolean bl = logNow = this._logInterval > 0 && currTime > nextLogTime;
            if (repeat || scanNow || logNow) {
                repeat = this.collectThreadInfo();
                this.logThreadInfo(logNow);
                if (scanNow) {
                    nextScanTime = System.currentTimeMillis() + (long)this._scanInterval;
                }
                if (logNow) {
                    nextLogTime = System.currentTimeMillis() + (long)this._logInterval;
                }
            }
            if (repeat) continue;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ex) {
                Log.ignore((Throwable)ex);
            }
        }
    }

    private boolean collectThreadInfo() {
        boolean repeat = false;
        try {
            Map<Thread, StackTraceElement[]> all = Thread.getAllStackTraces();
            for (Map.Entry<Thread, StackTraceElement[]> entry : all.entrySet()) {
                StackTraceElement[] lastStackTrace;
                Thread thread = entry.getKey();
                long threadId = thread.getId();
                if (threadId == this._runner.getId()) continue;
                ThreadMonitorInfo currMonitorInfo = this._monitorInfo.get(threadId);
                if (currMonitorInfo == null) {
                    currMonitorInfo = new ThreadMonitorInfo(thread);
                    currMonitorInfo.setStackTrace(entry.getValue());
                    currMonitorInfo.setCpuTime(this.getThreadCpuTime(threadId));
                    currMonitorInfo.setSampleTime(System.nanoTime());
                    this._monitorInfo.put(threadId, currMonitorInfo);
                    continue;
                }
                currMonitorInfo.setStackTrace(entry.getValue());
                currMonitorInfo.setCpuTime(this.getThreadCpuTime(threadId));
                currMonitorInfo.setSampleTime(System.nanoTime());
                int count = currMonitorInfo.getTraceCount();
                if (count >= 0 && currMonitorInfo.isSpinning()) {
                    if (count < this._trailLength) {
                        currMonitorInfo.setTraceCount(count + 1);
                        repeat = true;
                        continue;
                    }
                    currMonitorInfo.setSpinning(false);
                    currMonitorInfo.setTraceCount(-1);
                }
                if (!(currMonitorInfo.getCpuUtilization() > (float)this._busyThreshold) || (lastStackTrace = currMonitorInfo.getStackTrace()) == null || !this.matchStackTraces(lastStackTrace, entry.getValue())) continue;
                currMonitorInfo.setSpinning(true);
                if (count >= 0) continue;
                currMonitorInfo.setTraceCount(0);
                repeat = this._trailLength > 0;
            }
        }
        catch (Exception ex) {
            Log.debug((Throwable)ex);
        }
        return repeat;
    }

    protected void logThreadInfo(boolean logAll) {
        if (this._monitorInfo.size() > 0) {
            String message;
            long[] running = this.getAllThreadIds();
            ArrayList<ThreadMonitorInfo> all = new ArrayList<ThreadMonitorInfo>();
            for (int idx = 0; idx < running.length; ++idx) {
                ThreadMonitorInfo info = this._monitorInfo.get(running[idx]);
                if (info == null) continue;
                all.add(info);
            }
            Collections.sort(all, new Comparator<ThreadMonitorInfo>(){

                @Override
                public int compare(ThreadMonitorInfo info1, ThreadMonitorInfo info2) {
                    return (int)Math.signum(info2.getCpuUtilization() - info1.getCpuUtilization());
                }
            });
            String format = "Thread '%2$s'[%3$s,id:%1$d,cpu:%4$.2f%%]%5$s";
            boolean spinning = false;
            for (ThreadMonitorInfo info : all) {
                if (!(logAll && info.getCpuUtilization() > (float)this._logThreshold) && (!info.isSpinning() || info.getTraceCount() != 0)) continue;
                message = String.format(format, info.getThreadId(), info.getThreadName(), info.getThreadState(), Float.valueOf(info.getCpuUtilization()), info.isSpinning() ? " SPINNING" : "");
                this._logger.info(message, new Object[0]);
                spinning = true;
            }
            if (spinning && this._dumpable != null) {
                System.err.println(this._dumpable.dump());
            }
            for (ThreadMonitorInfo info : all) {
                if (!info.isSpinning() || info.getTraceCount() < 0) continue;
                message = String.format(format, info.getThreadId(), info.getThreadName(), info.getThreadState(), Float.valueOf(info.getCpuUtilization()), " STACK TRACE");
                this._logger.warn((Throwable)new ThreadMonitorException(message, info.getStackTrace()));
            }
        }
    }

    private boolean matchStackTraces(StackTraceElement[] lastStackTrace, StackTraceElement[] stackTrace) {
        boolean match = true;
        int count = Math.min(this._stackDepth, Math.min(lastStackTrace.length, stackTrace.length));
        for (int idx = 0; idx < count; ++idx) {
            if (stackTrace[idx].equals(lastStackTrace[idx])) continue;
            match = false;
            break;
        }
        return match;
    }
}

