/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.maven.plugin;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.eclipse.jetty.maven.plugin.AbstractJettyMojo;
import org.eclipse.jetty.maven.plugin.Overlay;
import org.eclipse.jetty.maven.plugin.OverlayConfig;
import org.eclipse.jetty.maven.plugin.ScanPattern;
import org.eclipse.jetty.maven.plugin.ScanTargetPattern;
import org.eclipse.jetty.maven.plugin.SelectiveJarResource;
import org.eclipse.jetty.maven.plugin.WarPluginInfo;
import org.eclipse.jetty.maven.plugin.utils.MavenProjectHelper;
import org.eclipse.jetty.util.IncludeExcludeSet;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceCollection;

@Mojo(name="run", requiresDependencyResolution=ResolutionScope.TEST)
@Execute(phase=LifecyclePhase.TEST_COMPILE)
public class JettyRunMojo
extends AbstractJettyMojo {
    public static final String DEFAULT_WEBAPP_SRC = "src" + File.separator + "main" + File.separator + "webapp";
    public static final String FAKE_WEBAPP = "webapp-tmp";
    @Parameter(alias="useTestClasspath", defaultValue="false")
    protected boolean useTestScope;
    @Parameter(defaultValue="${maven.war.webxml}", readonly=true)
    protected String webXml;
    @Parameter(defaultValue="${project.build.outputDirectory}", required=true)
    protected File classesDirectory;
    @Parameter
    protected ScanPattern scanClassesPattern;
    @Parameter(defaultValue="${project.build.testOutputDirectory}", required=true)
    protected File testClassesDirectory;
    @Parameter
    protected ScanPattern scanTestClassesPattern;
    @Parameter(defaultValue="${maven.war.src}")
    protected File webAppSourceDirectory;
    @Parameter
    protected File[] scanTargets;
    @Parameter
    protected ScanTargetPattern[] scanTargetPatterns;
    protected WarPluginInfo warPluginInfo;
    protected List<Artifact> warArtifacts;
    protected Resource originalBaseResource;

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        this.warPluginInfo = new WarPluginInfo(this.project);
        super.execute();
    }

    @Override
    public boolean checkPomConfiguration() throws MojoExecutionException {
        try {
            if (this.webAppSourceDirectory == null || !this.webAppSourceDirectory.exists()) {
                this.getLog().info((CharSequence)("webAppSourceDirectory" + (this.webAppSourceDirectory == null ? " not set." : this.webAppSourceDirectory.getAbsolutePath() + " does not exist.") + " Trying " + DEFAULT_WEBAPP_SRC));
                this.webAppSourceDirectory = new File(this.project.getBasedir(), DEFAULT_WEBAPP_SRC);
                if (!this.webAppSourceDirectory.exists()) {
                    this.getLog().info((CharSequence)("webAppSourceDirectory " + this.webAppSourceDirectory.getAbsolutePath() + " does not exist. Trying " + this.project.getBuild().getDirectory() + File.separator + FAKE_WEBAPP));
                    File target = new File(this.project.getBuild().getDirectory());
                    this.webAppSourceDirectory = new File(target, FAKE_WEBAPP);
                    if (!this.webAppSourceDirectory.exists()) {
                        this.webAppSourceDirectory.mkdirs();
                    }
                }
            } else {
                this.getLog().info((CharSequence)("Webapp source directory = " + this.webAppSourceDirectory.getCanonicalPath()));
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Webapp source directory does not exist", (Exception)e);
        }
        if (!"automatic".equalsIgnoreCase(this.reload) && !"manual".equalsIgnoreCase(this.reload)) {
            throw new MojoExecutionException("invalid reload mechanic specified, must be 'automatic' or 'manual'");
        }
        this.getLog().info((CharSequence)("Reload Mechanic: " + this.reload));
        this.getLog().info((CharSequence)("nonBlocking:" + this.nonBlocking));
        try {
            if (this.classesDirectory != null) {
                if (!this.classesDirectory.exists()) {
                    this.getLog().info((CharSequence)("Classes directory " + this.classesDirectory.getCanonicalPath() + " does not exist"));
                } else {
                    this.getLog().info((CharSequence)("Classes = " + this.classesDirectory.getCanonicalPath()));
                }
            } else {
                this.getLog().info((CharSequence)"Classes directory not set");
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Location of classesDirectory does not exist");
        }
        return true;
    }

    @Override
    public void finishConfigurationBeforeStart() throws Exception {
        this.server.setStopAtShutdown(true);
        super.finishConfigurationBeforeStart();
    }

    @Override
    public void configureWebApplication() throws Exception {
        super.configureWebApplication();
        Resource webAppSourceDirectoryResource = Resource.newResource((String)this.webAppSourceDirectory.getCanonicalPath());
        if (this.webApp.getWar() == null) {
            this.webApp.setWar(webAppSourceDirectoryResource.toString());
        }
        if (this.originalBaseResource == null) {
            this.originalBaseResource = this.webApp.getBaseResource() == null ? webAppSourceDirectoryResource : this.webApp.getBaseResource();
        }
        this.webApp.setBaseResource(this.originalBaseResource);
        if (this.classesDirectory != null) {
            this.webApp.setClasses(this.classesDirectory);
        }
        if (this.useTestScope && this.testClassesDirectory != null) {
            this.webApp.setTestClasses(this.testClassesDirectory);
        }
        MavenProjectHelper mavenProjectHelper = new MavenProjectHelper(this.project);
        List<File> webInfLibs = this.getWebInfLibArtifacts(this.project).stream().map(a -> {
            Path p = mavenProjectHelper.getArtifactPath((Artifact)a);
            this.getLog().debug((CharSequence)("Artifact " + a.getId() + " loaded from " + p + " added to WEB-INF/lib"));
            return p.toFile();
        }).collect(Collectors.toList());
        this.getLog().debug((CharSequence)"WEB-INF/lib initialized (at root)");
        this.webApp.setWebInfLib(webInfLibs);
        if (this.webApp.getDescriptor() == null) {
            File f;
            Resource r;
            if (this.webXml != null && (r = Resource.newResource((String)this.webXml)).exists() && !r.isDirectory()) {
                this.webApp.setDescriptor(r.toString());
            }
            if (this.webApp.getDescriptor() == null && this.webApp.getBaseResource() != null && (r = this.webApp.getBaseResource().addPath("WEB-INF/web.xml")).exists() && !r.isDirectory()) {
                this.webApp.setDescriptor(r.toString());
            }
            if (this.webApp.getDescriptor() == null && this.webAppSourceDirectory != null && (f = new File(new File(this.webAppSourceDirectory, "WEB-INF"), "web.xml")).exists() && f.isFile()) {
                this.webApp.setDescriptor(f.getCanonicalPath());
            }
        }
        List<Overlay> overlays = this.getOverlays();
        this.unpackOverlays(overlays);
        this.getLog().info((CharSequence)("web.xml file = " + this.webApp.getDescriptor()));
        this.getLog().info((CharSequence)("Webapp directory = " + this.webAppSourceDirectory.getCanonicalPath()));
    }

    @Override
    public void configureScanner() throws MojoExecutionException {
        try {
            this.gatherScannables();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error forming scan list", e);
        }
    }

    public void gatherScannables() throws Exception {
        Path p;
        File jettyWebXmlFile;
        if (this.webApp.getDescriptor() != null) {
            Resource r = Resource.newResource((String)this.webApp.getDescriptor());
            this.scanner.addFile(r.getFile().toPath());
        }
        if (this.webApp.getJettyEnvXml() != null) {
            this.scanner.addFile(new File(this.webApp.getJettyEnvXml()).toPath());
        }
        if (this.webApp.getDefaultsDescriptor() != null && !"org/eclipse/jetty/webapp/webdefault.xml".equals(this.webApp.getDefaultsDescriptor())) {
            this.scanner.addFile(new File(this.webApp.getDefaultsDescriptor()).toPath());
        }
        if (this.webApp.getOverrideDescriptor() != null) {
            this.scanner.addFile(new File(this.webApp.getOverrideDescriptor()).toPath());
        }
        if ((jettyWebXmlFile = this.findJettyWebXmlFile(new File(this.webAppSourceDirectory, "WEB-INF"))) != null) {
            this.scanner.addFile(jettyWebXmlFile.toPath());
        }
        for (Artifact a : this.getWarArtifacts()) {
            File f = a.getFile();
            if (a.getFile().isDirectory()) {
                this.scanner.addDirectory(f.toPath());
                continue;
            }
            this.scanner.addFile(f.toPath());
        }
        if (this.scanTargets != null) {
            for (File f : this.scanTargets) {
                if (f.isDirectory()) {
                    this.scanner.addDirectory(f.toPath());
                    continue;
                }
                this.scanner.addFile(f.toPath());
            }
        }
        this.scanner.addFile(this.project.getFile().toPath());
        if (this.scanTargetPatterns != null) {
            for (ScanTargetPattern p2 : this.scanTargetPatterns) {
                IncludeExcludeSet includesExcludes = this.scanner.addDirectory(p2.getDirectory().toPath());
                p2.configureIncludesExcludeSet((IncludeExcludeSet<PathMatcher, Path>)includesExcludes);
            }
        }
        if (this.webApp.getTestClasses() != null && this.webApp.getTestClasses().exists()) {
            p = this.webApp.getTestClasses().toPath();
            IncludeExcludeSet includeExcludeSet = this.scanner.addDirectory(p);
            if (this.scanTestClassesPattern != null) {
                for (String s : this.scanTestClassesPattern.getExcludes()) {
                    if (!s.startsWith("glob:")) {
                        s = "glob:" + s;
                    }
                    includeExcludeSet.exclude((Object)p.getFileSystem().getPathMatcher(s));
                }
                for (String s : this.scanTestClassesPattern.getIncludes()) {
                    if (!s.startsWith("glob:")) {
                        s = "glob:" + s;
                    }
                    includeExcludeSet.include((Object)p.getFileSystem().getPathMatcher(s));
                }
            }
        }
        if (this.webApp.getClasses() != null && this.webApp.getClasses().exists()) {
            p = this.webApp.getClasses().toPath();
            IncludeExcludeSet includeExcludes = this.scanner.addDirectory(p);
            if (this.scanClassesPattern != null) {
                for (String s : this.scanClassesPattern.getExcludes()) {
                    if (!s.startsWith("glob:")) {
                        s = "glob:" + s;
                    }
                    includeExcludes.exclude((Object)p.getFileSystem().getPathMatcher(s));
                }
                for (String s : this.scanClassesPattern.getIncludes()) {
                    if (!s.startsWith("glob:")) {
                        s = "glob:" + s;
                    }
                    includeExcludes.include((Object)p.getFileSystem().getPathMatcher(s));
                }
            }
        }
        if (this.webApp.getWebInfLib() != null) {
            for (File f : this.webApp.getWebInfLib()) {
                if (f.isDirectory()) {
                    this.scanner.addDirectory(f.toPath());
                    continue;
                }
                this.scanner.addFile(f.toPath());
            }
        }
    }

    @Override
    public void restartWebApp(boolean reconfigureScanner) throws Exception {
        this.getLog().info((CharSequence)("restarting " + (Object)((Object)this.webApp)));
        this.getLog().debug((CharSequence)"Stopping webapp ...");
        this.stopScanner();
        this.webApp.stop();
        this.getLog().debug((CharSequence)"Reconfiguring webapp ...");
        this.checkPomConfiguration();
        this.configureWebApplication();
        if (reconfigureScanner) {
            this.getLog().info((CharSequence)"Reconfiguring scanner after change to pom.xml ...");
            this.scanner.reset();
            this.warArtifacts = null;
            this.configureScanner();
        }
        this.getLog().debug((CharSequence)"Restarting webapp ...");
        this.webApp.start();
        this.startScanner();
        this.getLog().info((CharSequence)("Restart completed at " + new Date().toString()));
    }

    private Collection<Artifact> getWebInfLibArtifacts(Set<Artifact> artifacts) {
        return artifacts.stream().filter(this::canPutArtifactInWebInfLib).collect(Collectors.toList());
    }

    private Collection<Artifact> getWebInfLibArtifacts(MavenProject mavenProject) {
        String type = mavenProject.getArtifact().getType();
        if (!"war".equalsIgnoreCase(type) && !"zip".equalsIgnoreCase(type)) {
            return Collections.emptyList();
        }
        return this.getWebInfLibArtifacts(mavenProject.getArtifacts());
    }

    private boolean canPutArtifactInWebInfLib(Artifact artifact) {
        if ("war".equalsIgnoreCase(artifact.getType())) {
            return false;
        }
        if ("provided".equals(artifact.getScope())) {
            return false;
        }
        return !"test".equals(artifact.getScope()) || this.useTestScope;
    }

    private List<Overlay> getOverlays() throws Exception {
        Overlay overlay;
        HashSet<Artifact> matchedWarArtifacts = new HashSet<Artifact>();
        ArrayList<Overlay> overlays = new ArrayList<Overlay>();
        for (OverlayConfig config : this.warPluginInfo.getMavenWarOverlayConfigs()) {
            if (config.isSkip()) continue;
            if (config.isCurrentProject()) {
                overlay = new Overlay(config, null);
                overlays.add(overlay);
                continue;
            }
            Artifact a = this.getArtifactForOverlay(config, this.getWarArtifacts());
            if (a == null) continue;
            matchedWarArtifacts.add(a);
            SelectiveJarResource r = new SelectiveJarResource(new URL("jar:" + Resource.toURL((File)a.getFile()).toString() + "!/"));
            r.setIncludes(config.getIncludes());
            r.setExcludes(config.getExcludes());
            Overlay overlay2 = new Overlay(config, (Resource)r);
            overlays.add(overlay2);
        }
        for (Artifact a : this.getWarArtifacts()) {
            if (matchedWarArtifacts.contains(a)) continue;
            overlay = new Overlay(null, Resource.newResource((URL)new URL("jar:" + Resource.toURL((File)a.getFile()).toString() + "!/")));
            overlays.add(overlay);
        }
        return overlays;
    }

    public void unpackOverlays(List<Overlay> overlays) throws Exception {
        if (overlays == null || overlays.isEmpty()) {
            return;
        }
        ArrayList<Resource> resourceBaseCollection = new ArrayList<Resource>();
        for (Overlay o : overlays) {
            if (o.getConfig() != null && o.getConfig().isCurrentProject() && this.webApp.getBaseResource().exists()) {
                resourceBaseCollection.add(this.webApp.getBaseResource());
                continue;
            }
            Resource unpacked = this.unpackOverlay(o);
            resourceBaseCollection.add(unpacked);
        }
        if (!resourceBaseCollection.contains(this.webApp.getBaseResource()) && this.webApp.getBaseResource().exists()) {
            if (this.webApp.getBaseAppFirst()) {
                resourceBaseCollection.add(0, this.webApp.getBaseResource());
            } else {
                resourceBaseCollection.add(this.webApp.getBaseResource());
            }
        }
        this.webApp.setBaseResource((Resource)new ResourceCollection(resourceBaseCollection.toArray(new Resource[resourceBaseCollection.size()])));
    }

    public Resource unpackOverlay(Overlay overlay) throws IOException {
        File dir;
        int i;
        if (overlay.getResource() == null) {
            return null;
        }
        String name = overlay.getResource().getName();
        if (name.endsWith("!/")) {
            name = name.substring(0, name.length() - 2);
        }
        if ((i = name.lastIndexOf(47)) > 0) {
            name = name.substring(i + 1);
        }
        name = StringUtil.replace((String)name, (char)'.', (char)'_');
        File overlaysDir = new File(this.project.getBuild().getDirectory(), "jetty_overlays");
        File unpackDir = dir = new File(overlaysDir, name);
        if (overlay.getConfig() != null && overlay.getConfig().getTargetPath() != null) {
            unpackDir = new File(dir, overlay.getConfig().getTargetPath());
        }
        if (!unpackDir.exists() || overlay.getResource().lastModified() > unpackDir.lastModified()) {
            boolean made = unpackDir.mkdirs();
            overlay.getResource().copyTo(unpackDir);
        }
        return Resource.newResource((String)dir.getCanonicalPath());
    }

    private List<Artifact> getWarArtifacts() {
        if (this.warArtifacts != null) {
            return this.warArtifacts;
        }
        this.warArtifacts = new ArrayList<Artifact>();
        for (Artifact artifact : this.projectArtifacts) {
            if (!artifact.getType().equals("war") && !artifact.getType().equals("zip")) continue;
            try {
                this.warArtifacts.add(artifact);
                this.getLog().info((CharSequence)("Dependent war artifact " + artifact.getId()));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this.warArtifacts;
    }

    protected Artifact getArtifactForOverlay(OverlayConfig o, List<Artifact> warArtifacts) {
        if (o == null || warArtifacts == null || warArtifacts.isEmpty()) {
            return null;
        }
        for (Artifact a : warArtifacts) {
            if (!o.matchesArtifact(a.getGroupId(), a.getArtifactId(), a.getClassifier())) continue;
            return a;
        }
        return null;
    }

    protected String getJavaBin() {
        String[] javaexes = new String[]{"java", "java.exe"};
        File javaHomeDir = new File(System.getProperty("java.home"));
        for (String javaexe : javaexes) {
            File javabin = new File(javaHomeDir, JettyRunMojo.fileSeparators("bin/" + javaexe));
            if (!javabin.exists() || !javabin.isFile()) continue;
            return javabin.getAbsolutePath();
        }
        return "java";
    }

    public static String fileSeparators(String path) {
        StringBuilder ret = new StringBuilder();
        for (char c : path.toCharArray()) {
            if (c == '/' || c == '\\') {
                ret.append(File.separatorChar);
                continue;
            }
            ret.append(c);
        }
        return ret.toString();
    }
}

