/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.maven.plugin;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.thread.Scheduler;

public class MavenServerConnector
extends ContainerLifeCycle
implements Connector {
    public static String PORT_SYSPROPERTY = "jetty.http.port";
    public static final int DEFAULT_PORT = 8080;
    public static final String DEFAULT_PORT_STR = String.valueOf(8080);
    public static final int DEFAULT_MAX_IDLE_TIME = 30000;
    private Server server;
    private ServerConnector delegate;
    private String host;
    private String name;
    private int port;
    private long idleTimeout;

    public void setServer(Server server) {
        this.server = server;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getHost() {
        return this.host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setIdleTimeout(long idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    @Deprecated
    public void setSoLingerTime(int lingerTime) {
    }

    protected void doStart() throws Exception {
        if (this.server == null) {
            throw new IllegalStateException("Server not set for MavenServerConnector");
        }
        this.delegate = new ServerConnector(this.server);
        this.delegate.setName(this.name);
        this.delegate.setPort(this.port);
        this.delegate.setHost(this.host);
        this.delegate.setIdleTimeout(this.idleTimeout);
        this.delegate.start();
        super.doStart();
    }

    protected void doStop() throws Exception {
        this.delegate.stop();
        super.doStop();
        this.delegate = null;
    }

    public Future<Void> shutdown() {
        this.checkDelegate();
        return this.delegate.shutdown();
    }

    public Server getServer() {
        return this.server;
    }

    public Executor getExecutor() {
        this.checkDelegate();
        return this.delegate.getExecutor();
    }

    public Scheduler getScheduler() {
        this.checkDelegate();
        return this.delegate.getScheduler();
    }

    public ByteBufferPool getByteBufferPool() {
        this.checkDelegate();
        return this.delegate.getByteBufferPool();
    }

    public ConnectionFactory getConnectionFactory(String nextProtocol) {
        this.checkDelegate();
        return this.delegate.getConnectionFactory(nextProtocol);
    }

    public <T> T getConnectionFactory(Class<T> factoryType) {
        this.checkDelegate();
        return (T)this.delegate.getConnectionFactory(factoryType);
    }

    public ConnectionFactory getDefaultConnectionFactory() {
        this.checkDelegate();
        return this.delegate.getDefaultConnectionFactory();
    }

    public Collection<ConnectionFactory> getConnectionFactories() {
        this.checkDelegate();
        return this.delegate.getConnectionFactories();
    }

    public List<String> getProtocols() {
        this.checkDelegate();
        return this.delegate.getProtocols();
    }

    @ManagedAttribute(value="maximum time a connection can be idle before being closed (in ms)")
    public long getIdleTimeout() {
        this.checkDelegate();
        return this.delegate.getIdleTimeout();
    }

    public Object getTransport() {
        this.checkDelegate();
        return this.delegate.getTransport();
    }

    public Collection<EndPoint> getConnectedEndPoints() {
        this.checkDelegate();
        return this.delegate.getConnectedEndPoints();
    }

    public String getName() {
        return this.name;
    }

    public int getLocalPort() {
        return this.delegate.getLocalPort();
    }

    private void checkDelegate() throws IllegalStateException {
        if (this.delegate == null) {
            throw new IllegalStateException("MavenServerConnector delegate not ready");
        }
    }
}

