/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.maven.plugin;

import java.io.File;
import java.nio.file.Path;
import java.util.Date;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.eclipse.jetty.maven.plugin.AbstractUnassembledWebAppMojo;
import org.eclipse.jetty.maven.plugin.ConsoleReader;
import org.eclipse.jetty.maven.plugin.JettyEmbedder;
import org.eclipse.jetty.maven.plugin.JettyForker;
import org.eclipse.jetty.maven.plugin.JettyHomeForker;
import org.eclipse.jetty.util.IncludeExcludeSet;
import org.eclipse.jetty.util.Scanner;
import org.eclipse.jetty.util.resource.Resource;

@Mojo(name="run", requiresDependencyResolution=ResolutionScope.TEST)
@Execute(phase=LifecyclePhase.TEST_COMPILE)
public class JettyRunMojo
extends AbstractUnassembledWebAppMojo {
    @Parameter(defaultValue="0", property="jetty.scan", required=true)
    protected int scan;
    protected Scanner scanner;
    protected JettyEmbedder embedder;
    protected JettyForker forker;
    protected JettyHomeForker homeForker;

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        super.execute();
    }

    @Override
    public void startJettyEmbedded() throws MojoExecutionException {
        try {
            this.embedder = this.newJettyEmbedder();
            this.embedder.setExitVm(true);
            this.embedder.setStopAtShutdown(true);
            this.embedder.start();
            this.startScanner();
            this.embedder.join();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error starting jetty", e);
        }
    }

    @Override
    public void startJettyForked() throws MojoExecutionException {
        try {
            this.forker = this.newJettyForker();
            this.forker.setWaitForChild(true);
            this.forker.setScan(true);
            this.startScanner();
            this.forker.start();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error starting jetty", e);
        }
    }

    @Override
    public void startJettyHome() throws MojoExecutionException {
        try {
            this.homeForker = this.newJettyHomeForker();
            this.homeForker.setWaitForChild(true);
            this.startScanner();
            this.homeForker.start();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error starting jetty", e);
        }
    }

    private void startScanner() throws Exception {
        if (this.scan > 0) {
            this.scanner = new Scanner();
            this.scanner.setScanInterval(this.scan);
            this.scanner.setScanDepth(Integer.MAX_VALUE);
            this.scanner.setReportExistingFilesOnStartup(false);
            this.configureScanner();
            this.getLog().info((CharSequence)("Scan interval ms = " + this.scan));
            this.scanner.start();
        } else {
            ConsoleReader creader = new ConsoleReader();
            creader.addListener(new ConsoleReader.Listener(){

                @Override
                public void consoleEvent(String line) {
                    try {
                        JettyRunMojo.this.restartWebApp(false);
                    }
                    catch (Exception e) {
                        JettyRunMojo.this.getLog().debug((Throwable)e);
                    }
                }
            });
            Thread cthread = new Thread((Runnable)creader, "ConsoleReader");
            cthread.setDaemon(true);
            cthread.start();
        }
    }

    protected void configureScanner() throws MojoExecutionException {
        try {
            this.gatherScannables();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error forming scan list", e);
        }
        this.scanner.addListener((Scanner.Listener)new Scanner.BulkListener(){

            public void filesChanged(List<String> changes) {
                try {
                    boolean reconfigure = changes.contains(JettyRunMojo.this.project.getFile().getCanonicalPath());
                    JettyRunMojo.this.restartWebApp(reconfigure);
                }
                catch (Exception e) {
                    JettyRunMojo.this.getLog().error((CharSequence)"Error reconfiguring/restarting webapp after change in watched files", (Throwable)e);
                }
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public void gatherScannables() throws Exception {
        Path p;
        File jettyWebXmlFile;
        if (this.webApp.getDescriptor() != null) {
            Resource r = Resource.newResource((String)this.webApp.getDescriptor());
            this.scanner.addFile(r.getFile().toPath());
        }
        if (this.webApp.getJettyEnvXml() != null) {
            this.scanner.addFile(new File(this.webApp.getJettyEnvXml()).toPath());
        }
        if (this.webApp.getDefaultsDescriptor() != null && !"org/eclipse/jetty/webapp/webdefault.xml".equals(this.webApp.getDefaultsDescriptor())) {
            this.scanner.addFile(new File(this.webApp.getDefaultsDescriptor()).toPath());
        }
        if (this.webApp.getOverrideDescriptor() != null) {
            this.scanner.addFile(new File(this.webApp.getOverrideDescriptor()).toPath());
        }
        if ((jettyWebXmlFile = this.findJettyWebXmlFile(new File(this.webAppSourceDirectory, "WEB-INF"))) != null) {
            this.scanner.addFile(jettyWebXmlFile.toPath());
        }
        for (Artifact a : this.mavenProjectHelper.getWarPluginInfo().getWarArtifacts()) {
            File f = a.getFile();
            if (a.getFile().isDirectory()) {
                this.scanner.addDirectory(f.toPath());
                continue;
            }
            this.scanner.addFile(f.toPath());
        }
        this.configureScanTargetPatterns(this.scanner);
        this.scanner.addFile(this.project.getFile().toPath());
        if (this.webApp.getTestClasses() != null && this.webApp.getTestClasses().exists()) {
            p = this.webApp.getTestClasses().toPath();
            IncludeExcludeSet includeExcludeSet = this.scanner.addDirectory(p);
            if (this.scanTestClassesPattern != null) {
                for (String string : this.scanTestClassesPattern.getExcludes()) {
                    void var5_5;
                    if (!string.startsWith("glob:")) {
                        String string2 = "glob:" + string;
                    }
                    includeExcludeSet.exclude((Object)p.getFileSystem().getPathMatcher((String)var5_5));
                }
                for (String string : this.scanTestClassesPattern.getIncludes()) {
                    void var5_11;
                    if (!string.startsWith("glob:")) {
                        String string3 = "glob:" + string;
                    }
                    includeExcludeSet.include((Object)p.getFileSystem().getPathMatcher((String)var5_11));
                }
            }
        }
        if (this.webApp.getClasses() != null && this.webApp.getClasses().exists()) {
            p = this.webApp.getClasses().toPath();
            IncludeExcludeSet includeExcludes = this.scanner.addDirectory(p);
            if (this.scanClassesPattern != null) {
                for (String string : this.scanClassesPattern.getExcludes()) {
                    void var5_15;
                    if (!string.startsWith("glob:")) {
                        String string4 = "glob:" + string;
                    }
                    includeExcludes.exclude((Object)p.getFileSystem().getPathMatcher((String)var5_15));
                }
                for (String string : this.scanClassesPattern.getIncludes()) {
                    void var5_19;
                    if (!string.startsWith("glob:")) {
                        String string5 = "glob:" + string;
                    }
                    includeExcludes.include((Object)p.getFileSystem().getPathMatcher((String)var5_19));
                }
            }
        }
        if (this.webApp.getWebInfLib() != null) {
            for (File f : this.webApp.getWebInfLib()) {
                if (f.isDirectory()) {
                    this.scanner.addDirectory(f.toPath());
                    continue;
                }
                this.scanner.addFile(f.toPath());
            }
        }
    }

    public void restartWebApp(boolean reconfigure) throws Exception {
        this.getLog().info((CharSequence)("Restarting " + this.webApp));
        this.getLog().debug((CharSequence)"Stopping webapp ...");
        if (this.scanner != null) {
            this.scanner.stop();
        }
        switch (this.deployMode) {
            case EMBED: {
                this.getLog().debug((CharSequence)"Reconfiguring webapp ...");
                this.verifyPomConfiguration();
                if (reconfigure) {
                    this.getLog().info((CharSequence)"Reconfiguring scanner after change to pom.xml ...");
                    this.warArtifacts = null;
                    if (this.scanner != null) {
                        this.scanner.reset();
                        this.configureScanner();
                    }
                }
                this.embedder.getWebApp().stop();
                this.configureWebApp();
                this.embedder.redeployWebApp();
                if (this.scanner != null) {
                    this.scanner.start();
                }
                this.getLog().info((CharSequence)("Restart completed at " + new Date().toString()));
                break;
            }
            case FORK: {
                this.verifyPomConfiguration();
                if (reconfigure) {
                    this.getLog().info((CharSequence)"Reconfiguring scanner after change to pom.xml ...");
                    this.warArtifacts = null;
                    if (this.scanner != null) {
                        this.scanner.reset();
                        this.configureScanner();
                    }
                }
                this.configureWebApp();
                this.forker.redeployWebApp();
                if (this.scanner == null) break;
                this.scanner.start();
                break;
            }
            case HOME: {
                this.verifyPomConfiguration();
                if (reconfigure) {
                    this.getLog().info((CharSequence)"Reconfiguring scanner after change to pom.xml ...");
                    this.warArtifacts = null;
                    if (this.scanner != null) {
                        this.scanner.reset();
                        this.configureScanner();
                    }
                }
                this.configureWebApp();
                this.homeForker.redeployWebApp();
                if (this.scanner == null) break;
                this.scanner.start();
                break;
            }
            default: {
                throw new IllegalStateException("Unrecognized run type " + this.deployMode);
            }
        }
    }
}

