/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.maven.plugin;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.eclipse.jetty.maven.plugin.MavenWebAppContext;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.webapp.Configuration;
import org.eclipse.jetty.webapp.MetaInfConfiguration;
import org.eclipse.jetty.webapp.WebAppContext;

public class MavenMetaInfConfiguration
extends MetaInfConfiguration {
    private static final Logger LOG = Log.getLogger(MavenMetaInfConfiguration.class);
    protected static int COUNTER = 0;

    public Class<? extends Configuration> replaces() {
        return MetaInfConfiguration.class;
    }

    protected List<Resource> findJars(WebAppContext context) throws Exception {
        List superList;
        ArrayList<Resource> list = new ArrayList<Resource>();
        MavenWebAppContext jwac = (MavenWebAppContext)context;
        List<File> files = jwac.getWebInfLib();
        if (files != null) {
            files.forEach(file -> {
                if (file.getName().toLowerCase(Locale.ENGLISH).endsWith(".jar") || file.isDirectory()) {
                    try {
                        LOG.debug(" add  resource to resources to examine {}", new Object[]{file});
                        list.add(Resource.newResource((URI)file.toURI()));
                    }
                    catch (Exception e) {
                        LOG.warn("Bad url ", (Throwable)e);
                    }
                }
            });
        }
        if ((superList = super.findJars(context)) != null) {
            list.addAll(superList);
        }
        return list;
    }

    protected List<Resource> findClassDirs(WebAppContext context) throws Exception {
        List classesDirs;
        ArrayList<Resource> list = new ArrayList<Resource>();
        MavenWebAppContext jwac = (MavenWebAppContext)context;
        List<File> files = jwac.getWebInfClasses();
        if (files != null) {
            files.forEach(file -> {
                if (file.exists() && file.isDirectory()) {
                    try {
                        list.add(Resource.newResource((URI)file.toURI()));
                    }
                    catch (Exception e) {
                        LOG.warn("Bad url ", (Throwable)e);
                    }
                }
            });
        }
        if ((classesDirs = super.findClassDirs(context)) != null) {
            list.addAll(classesDirs);
        }
        return list;
    }
}

