/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.maven.plugin;

import java.io.File;
import java.nio.file.Path;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.eclipse.jetty.maven.plugin.AbstractWebAppMojo;
import org.eclipse.jetty.maven.plugin.JettyDistroForker;
import org.eclipse.jetty.maven.plugin.JettyEmbedder;
import org.eclipse.jetty.maven.plugin.JettyForker;
import org.eclipse.jetty.util.StringUtil;

@Mojo(name="start-war", requiresDependencyResolution=ResolutionScope.RUNTIME)
public class JettyStartWarMojo
extends AbstractWebAppMojo {
    @Parameter(defaultValue="${project.baseDir}/src/main/webapp")
    protected File webAppSourceDirectory;
    protected JettyEmbedder embedder;
    protected JettyForker forker;
    protected JettyDistroForker distroForker;

    @Override
    public void configureWebApp() throws Exception {
        super.configureWebApp();
        if (StringUtil.isBlank((String)this.webApp.getWar())) {
            Path war = this.target.toPath().resolve(this.project.getBuild().getFinalName() + ".war");
            this.webApp.setWar(war.toFile().getAbsolutePath());
        }
        this.getLog().info((CharSequence)("War = " + this.webApp.getWar()));
    }

    @Override
    public void startJettyEmbedded() throws MojoExecutionException {
        try {
            this.embedder = this.newJettyEmbedder();
            this.embedder.setExitVm(false);
            this.embedder.setStopAtShutdown(false);
            this.embedder.start();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error starting jetty", e);
        }
    }

    @Override
    public void startJettyForked() throws MojoExecutionException {
        try {
            this.forker = this.newJettyForker();
            this.forker.setWaitForChild(false);
            this.forker.setMaxChildStartChecks(this.maxChildStartChecks);
            this.forker.setMaxChildStartCheckMs(this.maxChildStartCheckMs);
            this.forker.setJettyOutputFile(this.getJettyOutputFile("jetty-start-war.out"));
            this.forker.start();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error starting jetty", e);
        }
    }

    @Override
    public void startJettyDistro() throws MojoExecutionException {
        try {
            this.distroForker = this.newJettyDistroForker();
            this.distroForker.setWaitForChild(false);
            this.distroForker.setMaxChildStartCheckMs(this.maxChildStartCheckMs);
            this.distroForker.setMaxChildStartChecks(this.maxChildStartChecks);
            this.distroForker.setJettyOutputFile(this.getJettyOutputFile("jetty-start-war.out"));
            this.distroForker.start();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error starting jetty", e);
        }
    }

    @Override
    protected void verifyPomConfiguration() throws MojoExecutionException {
    }
}

