/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.maven.plugin;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Date;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.eclipse.jetty.maven.plugin.AbstractWebAppMojo;
import org.eclipse.jetty.maven.plugin.ConsoleReader;
import org.eclipse.jetty.maven.plugin.JettyDistroForker;
import org.eclipse.jetty.maven.plugin.JettyEmbedder;
import org.eclipse.jetty.maven.plugin.JettyForker;
import org.eclipse.jetty.util.Scanner;
import org.eclipse.jetty.util.StringUtil;

@Mojo(name="run-war", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
@Execute(phase=LifecyclePhase.PACKAGE)
public class JettyRunWarMojo
extends AbstractWebAppMojo {
    @Parameter(defaultValue="0", property="jetty.scan", required=true)
    protected int scan;
    protected Scanner scanner;
    protected JettyEmbedder embedder;
    protected JettyForker forker;
    protected JettyDistroForker distroForker;
    protected Path war;

    @Override
    public void configureWebApp() throws Exception {
        super.configureWebApp();
        if (StringUtil.isBlank((String)this.webApp.getWar())) {
            this.war = this.target.toPath().resolve(this.project.getBuild().getFinalName() + ".war");
            this.webApp.setWar(this.war.toFile().getAbsolutePath());
        } else {
            this.war = Paths.get(this.webApp.getWar(), new String[0]);
        }
        this.getLog().info((CharSequence)("War = " + this.war));
    }

    @Override
    public void startJettyEmbedded() throws MojoExecutionException {
        try {
            this.embedder = this.newJettyEmbedder();
            this.embedder.setExitVm(true);
            this.embedder.setStopAtShutdown(true);
            this.embedder.start();
            this.startScanner();
            this.embedder.join();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error starting jetty", e);
        }
    }

    @Override
    public void startJettyForked() throws MojoExecutionException {
        try {
            this.forker = this.newJettyForker();
            this.forker.setWaitForChild(true);
            this.startScanner();
            this.forker.start();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error starting jetty", e);
        }
    }

    @Override
    public void startJettyDistro() throws MojoExecutionException {
        try {
            this.distroForker = this.newJettyDistroForker();
            this.distroForker.setWaitForChild(true);
            this.startScanner();
            this.distroForker.start();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error starting jetty", e);
        }
    }

    public void startScanner() throws Exception {
        if (this.scan > 0) {
            this.scanner = new Scanner();
            this.scanner.setScanInterval(this.scan);
            this.scanner.setScanDepth(Integer.MAX_VALUE);
            this.scanner.setReportExistingFilesOnStartup(false);
            this.configureScanner();
            this.getLog().info((CharSequence)("Scan interval ms = " + this.scan));
            this.scanner.start();
        } else {
            ConsoleReader creader = new ConsoleReader();
            creader.addListener(new ConsoleReader.Listener(){

                @Override
                public void consoleEvent(String line) {
                    try {
                        JettyRunWarMojo.this.restartWebApp(false);
                    }
                    catch (Exception e) {
                        JettyRunWarMojo.this.getLog().debug((Throwable)e);
                    }
                }
            });
            Thread cthread = new Thread((Runnable)creader, "ConsoleReader");
            cthread.setDaemon(true);
            cthread.start();
        }
    }

    public void configureScanner() throws MojoExecutionException {
        try {
            this.scanner.addFile(this.project.getFile().toPath());
            this.scanner.addFile(this.war);
            this.configureScanTargetPatterns(this.scanner);
            this.scanner.addListener((Scanner.Listener)new Scanner.BulkListener(){

                public void filesChanged(List<String> changes) {
                    try {
                        boolean reconfigure = changes.contains(JettyRunWarMojo.this.project.getFile().getCanonicalPath());
                        JettyRunWarMojo.this.restartWebApp(reconfigure);
                    }
                    catch (Exception e) {
                        JettyRunWarMojo.this.getLog().error((CharSequence)"Error reconfiguring/restarting webapp after change in watched files", (Throwable)e);
                    }
                }
            });
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error configuring scanner", (Exception)e);
        }
    }

    public void restartWebApp(boolean reconfigure) throws Exception {
        this.getLog().info((CharSequence)"Restarting webapp ...");
        this.getLog().debug((CharSequence)"Stopping scanner ...");
        if (this.scanner != null) {
            this.scanner.stop();
        }
        switch (this.deployMode) {
            case EMBED: {
                this.getLog().debug((CharSequence)"Reconfiguring webapp ...");
                this.verifyPomConfiguration();
                if (reconfigure) {
                    this.getLog().info((CharSequence)"Reconfiguring scanner after change to pom.xml ...");
                    this.scanner.reset();
                    this.warArtifacts = null;
                    this.configureScanner();
                }
                this.embedder.getWebApp().stop();
                this.configureWebApp();
                this.embedder.redeployWebApp();
                this.scanner.start();
                this.getLog().info((CharSequence)("Restart completed at " + new Date().toString()));
                break;
            }
            case FORK: {
                this.verifyPomConfiguration();
                if (reconfigure) {
                    this.getLog().info((CharSequence)"Reconfiguring scanner after change to pom.xml ...");
                    this.scanner.reset();
                    this.warArtifacts = null;
                    this.configureScanner();
                }
                this.configureWebApp();
                this.forker.redeployWebApp();
                this.scanner.start();
                break;
            }
            case DISTRO: {
                this.verifyPomConfiguration();
                if (reconfigure) {
                    this.getLog().info((CharSequence)"Reconfiguring scanner after change to pom.xml ...");
                    this.scanner.reset();
                    this.warArtifacts = null;
                    this.configureScanner();
                }
                this.configureWebApp();
                this.distroForker.redeployWebApp();
                this.scanner.start();
                break;
            }
            default: {
                throw new IllegalStateException("Unrecognized run type " + this.deployMode);
            }
        }
        this.getLog().info((CharSequence)"Restart completed.");
    }
}

