/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.jspc.plugin;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.jasper.JspC;
import org.apache.jasper.servlet.JspCServletContext;
import org.apache.jasper.servlet.TldScanner;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.tomcat.JarScanner;
import org.apache.tomcat.util.scan.StandardJarScanner;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.resource.Resource;

@Mojo(name="jspc", defaultPhase=LifecyclePhase.PROCESS_CLASSES, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class JspcMojo
extends AbstractMojo {
    public static final String END_OF_WEBAPP = "</web-app>";
    public static final String PRECOMPILED_FLAG = "org.eclipse.jetty.jsp.precompiled";
    @Parameter(defaultValue="false")
    private boolean useProvidedScope;
    @Parameter(defaultValue="${project.artifacts}", readonly=true)
    private Set projectArtifacts;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="${plugin.artifacts}", readonly=true)
    private List pluginArtifacts;
    @Parameter(defaultValue="${basedir}/target/webfrag.xml")
    private String webXmlFragment;
    @Parameter
    private String insertionMarker;
    @Parameter(defaultValue="true")
    private boolean mergeFragment;
    @Parameter(defaultValue="${project.build.outputDirectory}")
    private String generatedClasses;
    @Parameter(defaultValue="false")
    private boolean keepSources;
    @Parameter(defaultValue="${basedir}/src/main/webapp")
    private String webAppSourceDirectory;
    @Parameter(defaultValue="${basedir}/src/main/webapp/WEB-INF/web.xml")
    private String webXml;
    @Parameter(defaultValue="**\\/*.jsp, **\\/*.jspx")
    private String includes;
    @Parameter(defaultValue="**\\/.svn\\/**")
    private String excludes;
    @Parameter(defaultValue="${project.build.outputDirectory}")
    private File classesDirectory;
    @Parameter(defaultValue=".*taglibs[^/]*\\.jar|.*jstl[^/]*\\.jar$")
    private String tldJarNamePatterns;
    @Parameter
    private String sourceVersion;
    @Parameter
    private String targetVersion;
    @Parameter
    private JettyJspC jspc;
    @Parameter(defaultValue="true")
    private boolean scanAllDirectories;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.getLog().isDebugEnabled()) {
            this.getLog().info((CharSequence)("webAppSourceDirectory=" + this.webAppSourceDirectory));
            this.getLog().info((CharSequence)("generatedClasses=" + this.generatedClasses));
            this.getLog().info((CharSequence)("webXmlFragment=" + this.webXmlFragment));
            this.getLog().info((CharSequence)("webXml=" + this.webXml));
            this.getLog().info((CharSequence)("insertionMarker=" + (this.insertionMarker == null || this.insertionMarker.equals("") ? END_OF_WEBAPP : this.insertionMarker)));
            this.getLog().info((CharSequence)("keepSources=" + this.keepSources));
            this.getLog().info((CharSequence)("mergeFragment=" + this.mergeFragment));
            if (this.sourceVersion != null) {
                this.getLog().info((CharSequence)("sourceVersion=" + this.sourceVersion));
            }
            if (this.targetVersion != null) {
                this.getLog().info((CharSequence)("targetVersion=" + this.targetVersion));
            }
        }
        try {
            this.prepare();
            this.compile();
            this.cleanupSrcs();
            this.mergeWebXml();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failure processing jsps", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compile() throws Exception {
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        List<URL> webAppUrls = this.setUpWebAppClassPath();
        Set<URL> pluginJars = this.getPluginJars();
        Set<URL> providedJars = this.getProvidedScopeJars(pluginJars);
        ArrayList<URL> sysUrls = new ArrayList<URL>();
        sysUrls.addAll(providedJars);
        URLClassLoader sysClassLoader = new URLClassLoader(sysUrls.toArray(new URL[0]), currentClassLoader);
        URLClassLoader webAppClassLoader = new URLClassLoader(webAppUrls.toArray(new URL[0]), (ClassLoader)sysClassLoader);
        StringBuilder webAppClassPath = new StringBuilder();
        for (int i = 0; i < webAppUrls.size(); ++i) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("webappclassloader contains: " + webAppUrls.get(i)));
            }
            webAppClassPath.append(new File(webAppUrls.get(i).toURI()).getCanonicalPath());
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("added to classpath: " + webAppUrls.get(i).getFile()));
            }
            if (i + 1 >= webAppUrls.size()) continue;
            webAppClassPath.append(System.getProperty("path.separator"));
        }
        URLClassLoader fakeWebAppClassLoader = new URLClassLoader(new URL[0], (ClassLoader)webAppClassLoader);
        Thread.currentThread().setContextClassLoader(fakeWebAppClassLoader);
        if (this.jspc == null) {
            this.jspc = new JettyJspC();
        }
        this.jspc.setWebXmlFragment(this.webXmlFragment);
        this.jspc.setUriroot(this.webAppSourceDirectory);
        this.jspc.setOutputDir(this.generatedClasses);
        this.jspc.setClassLoader(fakeWebAppClassLoader);
        this.jspc.setScanAllDirectories(this.scanAllDirectories);
        this.jspc.setCompile(true);
        if (this.sourceVersion != null) {
            this.jspc.setCompilerSourceVM(this.sourceVersion);
        }
        if (this.targetVersion != null) {
            this.jspc.setCompilerTargetVM(this.targetVersion);
        }
        String jspFiles = this.getJspFiles(this.webAppSourceDirectory);
        try {
            if (jspFiles == null | jspFiles.equals("")) {
                this.getLog().info((CharSequence)"No files selected to precompile");
            } else {
                this.getLog().info((CharSequence)("Compiling " + jspFiles + " from includes=" + this.includes + " excludes=" + this.excludes));
                this.jspc.setJspFiles(jspFiles);
                this.jspc.execute();
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentClassLoader);
        }
    }

    private String getJspFiles(String webAppSourceDirectory) throws Exception {
        List fileNames = FileUtils.getFileNames((File)new File(webAppSourceDirectory), (String)this.includes, (String)this.excludes, (boolean)false);
        return StringUtils.join((Object[])fileNames.toArray(new String[0]), (String)",");
    }

    public void cleanupSrcs() throws Exception {
        File generatedClassesDir;
        if (!this.keepSources && (generatedClassesDir = new File(this.generatedClasses)).exists() && generatedClassesDir.isDirectory()) {
            JspcMojo.delete(generatedClassesDir, pathname -> pathname.isDirectory() || pathname.getName().endsWith(".java"));
        }
    }

    static void delete(File dir, FileFilter filter) {
        File[] files = dir.listFiles(filter);
        if (files != null) {
            for (File f : files) {
                if (f.isDirectory()) {
                    JspcMojo.delete(f, filter);
                    continue;
                }
                f.delete();
            }
        }
    }

    public void mergeWebXml() throws Exception {
        block23: {
            if (this.mergeFragment) {
                File webXml = this.getWebXmlFile();
                if (!webXml.exists()) {
                    this.getLog().info((CharSequence)(webXml.toString() + " does not exist, cannot merge with generated fragment"));
                    return;
                }
                File fragmentWebXml = new File(this.webXmlFragment);
                File mergedWebXml = new File(fragmentWebXml.getParentFile(), "web.xml");
                try (BufferedReader webXmlReader = new BufferedReader(new FileReader(webXml));
                     PrintWriter mergedWebXmlWriter = new PrintWriter(new FileWriter(mergedWebXml));){
                    String marker;
                    if (!fragmentWebXml.exists()) {
                        this.getLog().info((CharSequence)"No fragment web.xml file generated");
                        IO.copy((Reader)webXmlReader, (Writer)mergedWebXmlWriter);
                        break block23;
                    }
                    boolean atInsertPoint = false;
                    boolean atEOF = false;
                    String string = marker = this.insertionMarker == null || this.insertionMarker.equals("") ? END_OF_WEBAPP : this.insertionMarker;
                    while (!atInsertPoint && !atEOF) {
                        String line = webXmlReader.readLine();
                        if (line == null) {
                            atEOF = true;
                            continue;
                        }
                        if (line.indexOf(marker) >= 0) {
                            atInsertPoint = true;
                            continue;
                        }
                        mergedWebXmlWriter.println(line);
                    }
                    if (atEOF && !atInsertPoint) {
                        throw new IllegalStateException("web.xml does not contain insertionMarker " + this.insertionMarker);
                    }
                    mergedWebXmlWriter.println("<context-param><param-name>org.eclipse.jetty.jsp.precompiled</param-name><param-value>true</param-value></context-param>");
                    try (BufferedReader fragmentWebXmlReader = new BufferedReader(new FileReader(fragmentWebXml));){
                        IO.copy((Reader)fragmentWebXmlReader, (Writer)mergedWebXmlWriter);
                        if (marker.equals(END_OF_WEBAPP)) {
                            mergedWebXmlWriter.println(END_OF_WEBAPP);
                        }
                        IO.copy((Reader)webXmlReader, (Writer)mergedWebXmlWriter);
                    }
                }
            }
        }
    }

    private void prepare() throws Exception {
        File generatedSourceDirectoryFile = new File(this.generatedClasses);
        if (!generatedSourceDirectoryFile.exists()) {
            generatedSourceDirectoryFile.mkdirs();
        }
    }

    private List<URL> setUpWebAppClassPath() throws Exception {
        ArrayList<URL> urls = new ArrayList<URL>();
        String classesDir = this.classesDirectory.getCanonicalPath();
        classesDir = classesDir + (classesDir.endsWith(File.pathSeparator) ? "" : File.separator);
        urls.add(Resource.toURL((File)new File(classesDir)));
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Adding to classpath classes dir: " + classesDir));
        }
        for (Artifact artifact : this.project.getArtifacts()) {
            if ("test".equals(artifact.getScope()) || "provided".equals(artifact.getScope())) continue;
            String filePath = artifact.getFile().getCanonicalPath();
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Adding to classpath dependency file: " + filePath));
            }
            urls.add(Resource.toURL((File)artifact.getFile()));
        }
        return urls;
    }

    private Set<URL> getPluginJars() throws MalformedURLException {
        HashSet<URL> pluginJars = new HashSet<URL>();
        for (Artifact pluginArtifact : this.pluginArtifacts) {
            if (!"jar".equalsIgnoreCase(pluginArtifact.getType())) continue;
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Adding plugin artifact " + pluginArtifact));
            }
            pluginJars.add(pluginArtifact.getFile().toURI().toURL());
        }
        return pluginJars;
    }

    private Set<URL> getProvidedScopeJars(Set<URL> pluginJars) throws MalformedURLException {
        if (!this.useProvidedScope) {
            return Collections.emptySet();
        }
        HashSet<URL> providedJars = new HashSet<URL>();
        for (Artifact artifact : this.projectArtifacts) {
            if (!"provided".equals(artifact.getScope())) continue;
            URL jar = artifact.getFile().toURI().toURL();
            if (!pluginJars.contains(jar)) {
                providedJars.add(jar);
                if (!this.getLog().isDebugEnabled()) continue;
                this.getLog().debug((CharSequence)("Adding provided artifact: " + artifact));
                continue;
            }
            if (!this.getLog().isDebugEnabled()) continue;
            this.getLog().debug((CharSequence)("Skipping provided artifact: " + artifact));
        }
        return providedJars;
    }

    private File getWebXmlFile() throws IOException {
        File file = null;
        File baseDir = this.project.getBasedir().getCanonicalFile();
        File defaultWebAppSrcDir = new File(baseDir, "src/main/webapp").getCanonicalFile();
        File webAppSrcDir = new File(this.webAppSourceDirectory).getCanonicalFile();
        File defaultWebXml = new File(defaultWebAppSrcDir, "web.xml").getCanonicalFile();
        File webXmlFile = new File(this.webXml).getCanonicalFile();
        if (webXmlFile.compareTo(defaultWebXml) != 0) {
            file = new File(this.webXml);
            return file;
        }
        file = new File(webAppSrcDir, "web.xml");
        return file;
    }

    public static class JettyJspC
    extends JspC {
        private boolean scanAll;

        public void setClassLoader(ClassLoader loader) {
            this.loader = loader;
        }

        public void setScanAllDirectories(boolean scanAll) {
            this.scanAll = scanAll;
        }

        public boolean getScanAllDirectories() {
            return this.scanAll;
        }

        protected TldScanner newTldScanner(JspCServletContext context, boolean namespaceAware, boolean validate, boolean blockExternal) {
            if (context != null && context.getAttribute(JarScanner.class.getName()) == null) {
                StandardJarScanner jarScanner = new StandardJarScanner();
                jarScanner.setScanAllDirectories(this.getScanAllDirectories());
                context.setAttribute(JarScanner.class.getName(), (Object)jarScanner);
            }
            return super.newTldScanner(context, namespaceAware, validate, blockExternal);
        }
    }
}

