/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.session.infinispan;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jetty.session.SessionContext;
import org.eclipse.jetty.session.infinispan.InfinispanKeyBuilder;
import org.eclipse.jetty.session.infinispan.InfinispanSessionData;
import org.eclipse.jetty.session.infinispan.QueryManager;
import org.infinispan.Cache;
import org.infinispan.query.Search;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.query.dsl.QueryResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmbeddedQueryManager
implements QueryManager {
    private static final Logger LOG = LoggerFactory.getLogger(EmbeddedQueryManager.class);
    private Cache<String, InfinispanSessionData> _cache;
    private QueryFactory _factory;

    public EmbeddedQueryManager(Cache<String, InfinispanSessionData> cache) {
        this._cache = cache;
        this._factory = Search.getQueryFactory(this._cache);
    }

    public Set<String> queryExpiredSessions(SessionContext sessionContext, long time) {
        Objects.requireNonNull(sessionContext);
        Query expiredQuery = this._factory.create("select id from org.eclipse.jetty.session.infinispan.InfinispanSessionData where  contextPath = :contextPath and expiry <= :expiry and expiry > 0");
        expiredQuery.setParameter("contextPath", (Object)sessionContext.getCanonicalContextPath());
        expiredQuery.setParameter("expiry", (Object)time);
        QueryResult result = expiredQuery.execute();
        List list = result.list();
        Set<String> ids = list.stream().map(a -> (String)a[0]).collect(Collectors.toSet());
        return ids;
    }

    public void deleteOrphanSessions(long time) {
        Query deleteQuery = this._factory.create("select id, contextPath, vhost from org.eclipse.jetty.session.infinispan.InfinispanSessionData where  expiry <= :expiry and expiry > 0");
        deleteQuery.setParameter("expiry", (Object)time);
        QueryResult result = deleteQuery.execute();
        List list = result.list();
        list.stream().forEach(a -> {
            String key = InfinispanKeyBuilder.build((String)((String)a[1]), (String)((String)a[2]), (String)((String)a[0]));
            try {
                this._cache.remove((Object)key);
            }
            catch (Exception e) {
                LOG.warn("Error deleting {}", (Object)key, (Object)e);
            }
        });
    }

    public boolean exists(SessionContext sessionContext, String id) {
        Objects.requireNonNull(sessionContext);
        Query existQuery = this._factory.create("select id from org.eclipse.jetty.session.infinispan.InfinispanSessionData where id = :id and contextPath = :contextPath and expiry > :time or expiry <= 0");
        existQuery.setParameter("id", (Object)id);
        existQuery.setParameter("contextPath", (Object)sessionContext.getCanonicalContextPath());
        existQuery.setParameter("time", (Object)System.currentTimeMillis());
        QueryResult result = existQuery.execute();
        List list = result.list();
        return !list.isEmpty();
    }
}

