/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http.pathmap;

import org.eclipse.jetty.http.pathmap.ServletPathSpec;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ServletPathSpecTest {
    private void assertBadServletPathSpec(String pathSpec) {
        try {
            new ServletPathSpec(pathSpec);
            Assertions.fail((String)("Expected IllegalArgumentException for a bad servlet pathspec on: " + pathSpec));
        }
        catch (IllegalArgumentException e) {
            System.out.println(e);
        }
    }

    private void assertMatches(ServletPathSpec spec, String path) {
        String msg = String.format("Spec(\"%s\").matches(\"%s\")", spec.getDeclaration(), path);
        MatcherAssert.assertThat((String)msg, (Object)spec.matches(path), (Matcher)Matchers.is((Object)true));
    }

    private void assertNotMatches(ServletPathSpec spec, String path) {
        String msg = String.format("!Spec(\"%s\").matches(\"%s\")", spec.getDeclaration(), path);
        MatcherAssert.assertThat((String)msg, (Object)spec.matches(path), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testBadServletPathSpecA() {
        this.assertBadServletPathSpec("foo");
    }

    @Test
    public void testBadServletPathSpecB() {
        this.assertBadServletPathSpec("/foo/*.do");
    }

    @Test
    public void testBadServletPathSpecC() {
        this.assertBadServletPathSpec("foo/*.do");
    }

    @Test
    public void testBadServletPathSpecD() {
        this.assertBadServletPathSpec("foo/*.*do");
    }

    @Test
    public void testBadServletPathSpecE() {
        this.assertBadServletPathSpec("*do");
    }

    @Test
    public void testDefaultPathSpec() {
        ServletPathSpec spec = new ServletPathSpec("/");
        Assertions.assertEquals((Object)"/", (Object)spec.getDeclaration(), (String)"Spec.pathSpec");
        Assertions.assertEquals((int)-1, (int)spec.getPathDepth(), (String)"Spec.pathDepth");
    }

    @Test
    public void testExactPathSpec() {
        ServletPathSpec spec = new ServletPathSpec("/abs/path");
        Assertions.assertEquals((Object)"/abs/path", (Object)spec.getDeclaration(), (String)"Spec.pathSpec");
        Assertions.assertEquals((int)2, (int)spec.getPathDepth(), (String)"Spec.pathDepth");
        this.assertMatches(spec, "/abs/path");
        this.assertNotMatches(spec, "/abs/path/");
        this.assertNotMatches(spec, "/abs/path/more");
        this.assertNotMatches(spec, "/foo");
        this.assertNotMatches(spec, "/foo/abs/path");
        this.assertNotMatches(spec, "/foo/abs/path/");
    }

    @Test
    public void testGetPathInfo() {
        Assertions.assertEquals(null, (Object)new ServletPathSpec("/Foo/bar").getPathInfo("/Foo/bar"), (String)"pathInfo exact");
        Assertions.assertEquals((Object)"/bar", (Object)new ServletPathSpec("/Foo/*").getPathInfo("/Foo/bar"), (String)"pathInfo prefix");
        Assertions.assertEquals((Object)"/*", (Object)new ServletPathSpec("/Foo/*").getPathInfo("/Foo/*"), (String)"pathInfo prefix");
        Assertions.assertEquals((Object)"/", (Object)new ServletPathSpec("/Foo/*").getPathInfo("/Foo/"), (String)"pathInfo prefix");
        Assertions.assertEquals(null, (Object)new ServletPathSpec("/Foo/*").getPathInfo("/Foo"), (String)"pathInfo prefix");
        Assertions.assertEquals(null, (Object)new ServletPathSpec("*.ext").getPathInfo("/Foo/bar.ext"), (String)"pathInfo suffix");
        Assertions.assertEquals(null, (Object)new ServletPathSpec("/").getPathInfo("/Foo/bar.ext"), (String)"pathInfo default");
        Assertions.assertEquals((Object)"/xxx/zzz", (Object)new ServletPathSpec("/*").getPathInfo("/xxx/zzz"), (String)"pathInfo default");
    }

    @Test
    public void testNullPathSpec() {
        ServletPathSpec spec = new ServletPathSpec(null);
        Assertions.assertEquals((Object)"", (Object)spec.getDeclaration(), (String)"Spec.pathSpec");
        Assertions.assertEquals((int)-1, (int)spec.getPathDepth(), (String)"Spec.pathDepth");
    }

    @Test
    public void testRootPathSpec() {
        ServletPathSpec spec = new ServletPathSpec("");
        Assertions.assertEquals((Object)"", (Object)spec.getDeclaration(), (String)"Spec.pathSpec");
        Assertions.assertEquals((int)-1, (int)spec.getPathDepth(), (String)"Spec.pathDepth");
    }

    @Test
    public void testPathMatch() {
        Assertions.assertEquals((Object)"/Foo/bar", (Object)new ServletPathSpec("/Foo/bar").getPathMatch("/Foo/bar"), (String)"pathMatch exact");
        Assertions.assertEquals((Object)"/Foo", (Object)new ServletPathSpec("/Foo/*").getPathMatch("/Foo/bar"), (String)"pathMatch prefix");
        Assertions.assertEquals((Object)"/Foo", (Object)new ServletPathSpec("/Foo/*").getPathMatch("/Foo/"), (String)"pathMatch prefix");
        Assertions.assertEquals((Object)"/Foo", (Object)new ServletPathSpec("/Foo/*").getPathMatch("/Foo"), (String)"pathMatch prefix");
        Assertions.assertEquals((Object)"/Foo/bar.ext", (Object)new ServletPathSpec("*.ext").getPathMatch("/Foo/bar.ext"), (String)"pathMatch suffix");
        Assertions.assertEquals((Object)"/Foo/bar.ext", (Object)new ServletPathSpec("/").getPathMatch("/Foo/bar.ext"), (String)"pathMatch default");
        Assertions.assertEquals((Object)"", (Object)new ServletPathSpec("/*").getPathMatch("/xxx/zzz"), (String)"pathMatch default");
    }

    @Test
    public void testPrefixPathSpec() {
        ServletPathSpec spec = new ServletPathSpec("/downloads/*");
        Assertions.assertEquals((Object)"/downloads/*", (Object)spec.getDeclaration(), (String)"Spec.pathSpec");
        Assertions.assertEquals((int)2, (int)spec.getPathDepth(), (String)"Spec.pathDepth");
        this.assertMatches(spec, "/downloads/logo.jpg");
        this.assertMatches(spec, "/downloads/distribution.tar.gz");
        this.assertMatches(spec, "/downloads/distribution.tgz");
        this.assertMatches(spec, "/downloads/distribution.zip");
        this.assertMatches(spec, "/downloads");
        Assertions.assertEquals((Object)"/", (Object)spec.getPathInfo("/downloads/"), (String)"Spec.pathInfo");
        Assertions.assertEquals((Object)"/distribution.zip", (Object)spec.getPathInfo("/downloads/distribution.zip"), (String)"Spec.pathInfo");
        Assertions.assertEquals((Object)"/dist/9.0/distribution.tar.gz", (Object)spec.getPathInfo("/downloads/dist/9.0/distribution.tar.gz"), (String)"Spec.pathInfo");
    }

    @Test
    public void testSuffixPathSpec() {
        ServletPathSpec spec = new ServletPathSpec("*.gz");
        Assertions.assertEquals((Object)"*.gz", (Object)spec.getDeclaration(), (String)"Spec.pathSpec");
        Assertions.assertEquals((int)0, (int)spec.getPathDepth(), (String)"Spec.pathDepth");
        this.assertMatches(spec, "/downloads/distribution.tar.gz");
        this.assertMatches(spec, "/downloads/jetty.log.gz");
        this.assertNotMatches(spec, "/downloads/distribution.zip");
        this.assertNotMatches(spec, "/downloads/distribution.tgz");
        this.assertNotMatches(spec, "/abs/path");
        Assertions.assertEquals(null, (Object)spec.getPathInfo("/downloads/distribution.tar.gz"), (String)"Spec.pathInfo");
    }
}

