/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.nio.ByteBuffer;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpGenerator;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.util.BufferUtil;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class HttpGeneratorClientTest {
    public static final String[] connect = new String[]{null, "keep-alive", "close"};

    @Test
    public void testGETRequestNoContent() throws Exception {
        ByteBuffer header = BufferUtil.allocate((int)2048);
        HttpGenerator gen = new HttpGenerator();
        HttpGenerator.Result result = gen.generateRequest(null, null, null, null, true);
        Assertions.assertEquals((Object)HttpGenerator.Result.NEED_INFO, (Object)result);
        Assertions.assertEquals((Object)HttpGenerator.State.START, (Object)gen.getState());
        Info info = new Info("GET", "/index.html");
        info.getFields().add("Host", "something");
        info.getFields().add("User-Agent", "test");
        Assertions.assertTrue((!gen.isChunking() ? 1 : 0) != 0);
        result = gen.generateRequest((MetaData.Request)info, null, null, null, true);
        Assertions.assertEquals((Object)HttpGenerator.Result.NEED_HEADER, (Object)result);
        Assertions.assertEquals((Object)HttpGenerator.State.START, (Object)gen.getState());
        result = gen.generateRequest((MetaData.Request)info, header, null, null, true);
        Assertions.assertEquals((Object)HttpGenerator.Result.FLUSH, (Object)result);
        Assertions.assertEquals((Object)HttpGenerator.State.COMPLETING, (Object)gen.getState());
        Assertions.assertTrue((!gen.isChunking() ? 1 : 0) != 0);
        String out = BufferUtil.toString((ByteBuffer)header);
        BufferUtil.clear((ByteBuffer)header);
        result = gen.generateResponse(null, false, null, null, null, false);
        Assertions.assertEquals((Object)HttpGenerator.Result.DONE, (Object)result);
        Assertions.assertEquals((Object)HttpGenerator.State.END, (Object)gen.getState());
        Assertions.assertTrue((!gen.isChunking() ? 1 : 0) != 0);
        Assertions.assertEquals((long)0L, (long)gen.getContentPrepared());
        MatcherAssert.assertThat((Object)out, (Matcher)Matchers.containsString((String)"GET /index.html HTTP/1.1"));
        MatcherAssert.assertThat((Object)out, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Content-Length")));
    }

    @Test
    public void testEmptyHeaders() throws Exception {
        ByteBuffer header = BufferUtil.allocate((int)2048);
        HttpGenerator gen = new HttpGenerator();
        HttpGenerator.Result result = gen.generateRequest(null, null, null, null, true);
        Assertions.assertEquals((Object)HttpGenerator.Result.NEED_INFO, (Object)result);
        Assertions.assertEquals((Object)HttpGenerator.State.START, (Object)gen.getState());
        Info info = new Info("GET", "/index.html");
        info.getFields().add("Host", "something");
        info.getFields().add("Null", null);
        info.getFields().add("Empty", "");
        Assertions.assertTrue((!gen.isChunking() ? 1 : 0) != 0);
        result = gen.generateRequest((MetaData.Request)info, null, null, null, true);
        Assertions.assertEquals((Object)HttpGenerator.Result.NEED_HEADER, (Object)result);
        Assertions.assertEquals((Object)HttpGenerator.State.START, (Object)gen.getState());
        result = gen.generateRequest((MetaData.Request)info, header, null, null, true);
        Assertions.assertEquals((Object)HttpGenerator.Result.FLUSH, (Object)result);
        Assertions.assertEquals((Object)HttpGenerator.State.COMPLETING, (Object)gen.getState());
        Assertions.assertTrue((!gen.isChunking() ? 1 : 0) != 0);
        String out = BufferUtil.toString((ByteBuffer)header);
        BufferUtil.clear((ByteBuffer)header);
        result = gen.generateResponse(null, false, null, null, null, false);
        Assertions.assertEquals((Object)HttpGenerator.Result.DONE, (Object)result);
        Assertions.assertEquals((Object)HttpGenerator.State.END, (Object)gen.getState());
        Assertions.assertTrue((!gen.isChunking() ? 1 : 0) != 0);
        Assertions.assertEquals((long)0L, (long)gen.getContentPrepared());
        MatcherAssert.assertThat((Object)out, (Matcher)Matchers.containsString((String)"GET /index.html HTTP/1.1"));
        MatcherAssert.assertThat((Object)out, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Content-Length")));
        MatcherAssert.assertThat((Object)out, (Matcher)Matchers.containsString((String)"Empty:"));
        MatcherAssert.assertThat((Object)out, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Null:")));
    }

    @Test
    public void testPOSTRequestNoContent() throws Exception {
        ByteBuffer header = BufferUtil.allocate((int)2048);
        HttpGenerator gen = new HttpGenerator();
        HttpGenerator.Result result = gen.generateRequest(null, null, null, null, true);
        Assertions.assertEquals((Object)HttpGenerator.Result.NEED_INFO, (Object)result);
        Assertions.assertEquals((Object)HttpGenerator.State.START, (Object)gen.getState());
        Info info = new Info("POST", "/index.html");
        info.getFields().add("Host", "something");
        info.getFields().add("User-Agent", "test");
        Assertions.assertTrue((!gen.isChunking() ? 1 : 0) != 0);
        result = gen.generateRequest((MetaData.Request)info, null, null, null, true);
        Assertions.assertEquals((Object)HttpGenerator.Result.NEED_HEADER, (Object)result);
        Assertions.assertEquals((Object)HttpGenerator.State.START, (Object)gen.getState());
        result = gen.generateRequest((MetaData.Request)info, header, null, null, true);
        Assertions.assertEquals((Object)HttpGenerator.Result.FLUSH, (Object)result);
        Assertions.assertEquals((Object)HttpGenerator.State.COMPLETING, (Object)gen.getState());
        Assertions.assertTrue((!gen.isChunking() ? 1 : 0) != 0);
        String out = BufferUtil.toString((ByteBuffer)header);
        BufferUtil.clear((ByteBuffer)header);
        result = gen.generateResponse(null, false, null, null, null, false);
        Assertions.assertEquals((Object)HttpGenerator.Result.DONE, (Object)result);
        Assertions.assertEquals((Object)HttpGenerator.State.END, (Object)gen.getState());
        Assertions.assertTrue((!gen.isChunking() ? 1 : 0) != 0);
        Assertions.assertEquals((long)0L, (long)gen.getContentPrepared());
        MatcherAssert.assertThat((Object)out, (Matcher)Matchers.containsString((String)"POST /index.html HTTP/1.1"));
        MatcherAssert.assertThat((Object)out, (Matcher)Matchers.containsString((String)"Content-Length: 0"));
    }

    @Test
    public void testRequestWithContent() throws Exception {
        ByteBuffer header = BufferUtil.allocate((int)4096);
        ByteBuffer content0 = BufferUtil.toBuffer((String)"Hello World. The quick brown fox jumped over the lazy dog.");
        HttpGenerator gen = new HttpGenerator();
        HttpGenerator.Result result = gen.generateRequest(null, null, null, content0, true);
        Assertions.assertEquals((Object)HttpGenerator.Result.NEED_INFO, (Object)result);
        Assertions.assertEquals((Object)HttpGenerator.State.START, (Object)gen.getState());
        Info info = new Info("POST", "/index.html");
        info.getFields().add("Host", "something");
        info.getFields().add("User-Agent", "test");
        result = gen.generateRequest((MetaData.Request)info, null, null, content0, true);
        Assertions.assertEquals((Object)HttpGenerator.Result.NEED_HEADER, (Object)result);
        Assertions.assertEquals((Object)HttpGenerator.State.START, (Object)gen.getState());
        result = gen.generateRequest((MetaData.Request)info, header, null, content0, true);
        Assertions.assertEquals((Object)HttpGenerator.Result.FLUSH, (Object)result);
        Assertions.assertEquals((Object)HttpGenerator.State.COMPLETING, (Object)gen.getState());
        Assertions.assertTrue((!gen.isChunking() ? 1 : 0) != 0);
        String out = BufferUtil.toString((ByteBuffer)header);
        BufferUtil.clear((ByteBuffer)header);
        out = out + BufferUtil.toString((ByteBuffer)content0);
        BufferUtil.clear((ByteBuffer)content0);
        result = gen.generateResponse(null, false, null, null, null, false);
        Assertions.assertEquals((Object)HttpGenerator.Result.DONE, (Object)result);
        Assertions.assertEquals((Object)HttpGenerator.State.END, (Object)gen.getState());
        Assertions.assertTrue((!gen.isChunking() ? 1 : 0) != 0);
        MatcherAssert.assertThat((Object)out, (Matcher)Matchers.containsString((String)"POST /index.html HTTP/1.1"));
        MatcherAssert.assertThat((Object)out, (Matcher)Matchers.containsString((String)"Host: something"));
        MatcherAssert.assertThat((Object)out, (Matcher)Matchers.containsString((String)"Content-Length: 58"));
        MatcherAssert.assertThat((Object)out, (Matcher)Matchers.containsString((String)"Hello World. The quick brown fox jumped over the lazy dog."));
        Assertions.assertEquals((long)58L, (long)gen.getContentPrepared());
    }

    @Test
    public void testRequestWithChunkedContent() throws Exception {
        ByteBuffer header = BufferUtil.allocate((int)4096);
        ByteBuffer chunk = BufferUtil.allocate((int)12);
        ByteBuffer content0 = BufferUtil.toBuffer((String)"Hello World. ");
        ByteBuffer content1 = BufferUtil.toBuffer((String)"The quick brown fox jumped over the lazy dog.");
        HttpGenerator gen = new HttpGenerator();
        HttpGenerator.Result result = gen.generateRequest(null, null, null, content0, false);
        Assertions.assertEquals((Object)HttpGenerator.Result.NEED_INFO, (Object)result);
        Assertions.assertEquals((Object)HttpGenerator.State.START, (Object)gen.getState());
        Info info = new Info("POST", "/index.html");
        info.getFields().add("Host", "something");
        info.getFields().add("User-Agent", "test");
        result = gen.generateRequest((MetaData.Request)info, null, null, content0, false);
        Assertions.assertEquals((Object)HttpGenerator.Result.NEED_HEADER, (Object)result);
        Assertions.assertEquals((Object)HttpGenerator.State.START, (Object)gen.getState());
        result = gen.generateRequest((MetaData.Request)info, header, null, content0, false);
        Assertions.assertEquals((Object)HttpGenerator.Result.FLUSH, (Object)result);
        Assertions.assertEquals((Object)HttpGenerator.State.COMMITTED, (Object)gen.getState());
        Assertions.assertTrue((boolean)gen.isChunking());
        String out = BufferUtil.toString((ByteBuffer)header);
        BufferUtil.clear((ByteBuffer)header);
        out = out + BufferUtil.toString((ByteBuffer)content0);
        BufferUtil.clear((ByteBuffer)content0);
        result = gen.generateRequest(null, header, null, content1, false);
        Assertions.assertEquals((Object)HttpGenerator.Result.NEED_CHUNK, (Object)result);
        Assertions.assertEquals((Object)HttpGenerator.State.COMMITTED, (Object)gen.getState());
        result = gen.generateRequest(null, null, chunk, content1, false);
        Assertions.assertEquals((Object)HttpGenerator.Result.FLUSH, (Object)result);
        Assertions.assertEquals((Object)HttpGenerator.State.COMMITTED, (Object)gen.getState());
        Assertions.assertTrue((boolean)gen.isChunking());
        out = out + BufferUtil.toString((ByteBuffer)chunk);
        BufferUtil.clear((ByteBuffer)chunk);
        out = out + BufferUtil.toString((ByteBuffer)content1);
        BufferUtil.clear((ByteBuffer)content1);
        result = gen.generateResponse(null, false, null, chunk, null, true);
        Assertions.assertEquals((Object)HttpGenerator.Result.CONTINUE, (Object)result);
        Assertions.assertEquals((Object)HttpGenerator.State.COMPLETING, (Object)gen.getState());
        Assertions.assertTrue((boolean)gen.isChunking());
        result = gen.generateResponse(null, false, null, chunk, null, true);
        Assertions.assertEquals((Object)HttpGenerator.Result.FLUSH, (Object)result);
        Assertions.assertEquals((Object)HttpGenerator.State.COMPLETING, (Object)gen.getState());
        out = out + BufferUtil.toString((ByteBuffer)chunk);
        BufferUtil.clear((ByteBuffer)chunk);
        Assertions.assertTrue((!gen.isChunking() ? 1 : 0) != 0);
        result = gen.generateResponse(null, false, null, chunk, null, true);
        Assertions.assertEquals((Object)HttpGenerator.Result.DONE, (Object)result);
        Assertions.assertEquals((Object)HttpGenerator.State.END, (Object)gen.getState());
        MatcherAssert.assertThat((Object)out, (Matcher)Matchers.containsString((String)"POST /index.html HTTP/1.1"));
        MatcherAssert.assertThat((Object)out, (Matcher)Matchers.containsString((String)"Host: something"));
        MatcherAssert.assertThat((Object)out, (Matcher)Matchers.containsString((String)"Transfer-Encoding: chunked"));
        MatcherAssert.assertThat((Object)out, (Matcher)Matchers.containsString((String)"\r\nD\r\nHello World. \r\n"));
        MatcherAssert.assertThat((Object)out, (Matcher)Matchers.containsString((String)"\r\n2D\r\nThe quick brown fox jumped over the lazy dog.\r\n"));
        MatcherAssert.assertThat((Object)out, (Matcher)Matchers.containsString((String)"\r\n0\r\n\r\n"));
        Assertions.assertEquals((long)58L, (long)gen.getContentPrepared());
    }

    @Test
    public void testRequestWithKnownContent() throws Exception {
        ByteBuffer header = BufferUtil.allocate((int)4096);
        ByteBuffer chunk = BufferUtil.allocate((int)12);
        ByteBuffer content0 = BufferUtil.toBuffer((String)"Hello World. ");
        ByteBuffer content1 = BufferUtil.toBuffer((String)"The quick brown fox jumped over the lazy dog.");
        HttpGenerator gen = new HttpGenerator();
        HttpGenerator.Result result = gen.generateRequest(null, null, null, content0, false);
        Assertions.assertEquals((Object)HttpGenerator.Result.NEED_INFO, (Object)result);
        Assertions.assertEquals((Object)HttpGenerator.State.START, (Object)gen.getState());
        Info info = new Info("POST", "/index.html", 58);
        info.getFields().add("Host", "something");
        info.getFields().add("User-Agent", "test");
        result = gen.generateRequest((MetaData.Request)info, null, null, content0, false);
        Assertions.assertEquals((Object)HttpGenerator.Result.NEED_HEADER, (Object)result);
        Assertions.assertEquals((Object)HttpGenerator.State.START, (Object)gen.getState());
        result = gen.generateRequest((MetaData.Request)info, header, null, content0, false);
        Assertions.assertEquals((Object)HttpGenerator.Result.FLUSH, (Object)result);
        Assertions.assertEquals((Object)HttpGenerator.State.COMMITTED, (Object)gen.getState());
        Assertions.assertTrue((!gen.isChunking() ? 1 : 0) != 0);
        String out = BufferUtil.toString((ByteBuffer)header);
        BufferUtil.clear((ByteBuffer)header);
        out = out + BufferUtil.toString((ByteBuffer)content0);
        BufferUtil.clear((ByteBuffer)content0);
        result = gen.generateRequest(null, null, null, content1, false);
        Assertions.assertEquals((Object)HttpGenerator.Result.FLUSH, (Object)result);
        Assertions.assertEquals((Object)HttpGenerator.State.COMMITTED, (Object)gen.getState());
        Assertions.assertTrue((!gen.isChunking() ? 1 : 0) != 0);
        out = out + BufferUtil.toString((ByteBuffer)content1);
        BufferUtil.clear((ByteBuffer)content1);
        result = gen.generateResponse(null, false, null, null, null, true);
        Assertions.assertEquals((Object)HttpGenerator.Result.CONTINUE, (Object)result);
        Assertions.assertEquals((Object)HttpGenerator.State.COMPLETING, (Object)gen.getState());
        Assertions.assertTrue((!gen.isChunking() ? 1 : 0) != 0);
        result = gen.generateResponse(null, false, null, null, null, true);
        Assertions.assertEquals((Object)HttpGenerator.Result.DONE, (Object)result);
        Assertions.assertEquals((Object)HttpGenerator.State.END, (Object)gen.getState());
        out = out + BufferUtil.toString((ByteBuffer)chunk);
        BufferUtil.clear((ByteBuffer)chunk);
        MatcherAssert.assertThat((Object)out, (Matcher)Matchers.containsString((String)"POST /index.html HTTP/1.1"));
        MatcherAssert.assertThat((Object)out, (Matcher)Matchers.containsString((String)"Host: something"));
        MatcherAssert.assertThat((Object)out, (Matcher)Matchers.containsString((String)"Content-Length: 58"));
        MatcherAssert.assertThat((Object)out, (Matcher)Matchers.containsString((String)"\r\n\r\nHello World. The quick brown fox jumped over the lazy dog."));
        Assertions.assertEquals((long)58L, (long)gen.getContentPrepared());
    }

    class Info
    extends MetaData.Request {
        Info(String method, String uri) {
            super(method, new HttpURI(uri), HttpVersion.HTTP_1_1, new HttpFields(), -1L);
        }

        public Info(String method, String uri, int contentLength) {
            super(method, new HttpURI(uri), HttpVersion.HTTP_1_1, new HttpFields(), (long)contentLength);
        }
    }
}

