/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.eclipse.jetty.http.BadMessageException;
import org.eclipse.jetty.http.MultiPartParser;
import org.eclipse.jetty.util.BufferUtil;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class MultiPartParserTest {
    @Test
    public void testEmptyPreamble() {
        MultiPartParser parser = new MultiPartParser(new MultiPartParser.Handler(){}, "BOUNDARY");
        ByteBuffer data = BufferUtil.toBuffer((String)"");
        parser.parse(data, false);
        Assert.assertThat((Object)parser.getState(), (Matcher)Matchers.is((Object)MultiPartParser.State.PREAMBLE));
    }

    @Test
    public void testNoPreamble() {
        MultiPartParser parser = new MultiPartParser(new MultiPartParser.Handler(){}, "BOUNDARY");
        ByteBuffer data = BufferUtil.toBuffer((String)"");
        data = BufferUtil.toBuffer((String)"--BOUNDARY   \r\n");
        parser.parse(data, false);
        Assert.assertTrue((boolean)parser.isState(MultiPartParser.State.BODY_PART));
        Assert.assertThat((Object)data.remaining(), (Matcher)Matchers.is((Object)0));
    }

    @Test
    public void testPreamble() {
        MultiPartParser parser = new MultiPartParser(new MultiPartParser.Handler(){}, "BOUNDARY");
        ByteBuffer data = BufferUtil.toBuffer((String)"This is not part of a part\r\n");
        parser.parse(data, false);
        Assert.assertThat((Object)parser.getState(), (Matcher)Matchers.is((Object)MultiPartParser.State.PREAMBLE));
        Assert.assertThat((Object)data.remaining(), (Matcher)Matchers.is((Object)0));
        data = BufferUtil.toBuffer((String)"More data that almost includes \n--BOUNDARY but no CR before.");
        parser.parse(data, false);
        Assert.assertThat((Object)parser.getState(), (Matcher)Matchers.is((Object)MultiPartParser.State.PREAMBLE));
        Assert.assertThat((Object)data.remaining(), (Matcher)Matchers.is((Object)0));
        data = BufferUtil.toBuffer((String)"Could be a boundary \r\n--BOUNDAR");
        parser.parse(data, false);
        Assert.assertThat((Object)parser.getState(), (Matcher)Matchers.is((Object)MultiPartParser.State.PREAMBLE));
        Assert.assertThat((Object)data.remaining(), (Matcher)Matchers.is((Object)0));
        data = BufferUtil.toBuffer((String)"but not it isn't \r\n--BOUN");
        parser.parse(data, false);
        Assert.assertThat((Object)parser.getState(), (Matcher)Matchers.is((Object)MultiPartParser.State.PREAMBLE));
        Assert.assertThat((Object)data.remaining(), (Matcher)Matchers.is((Object)0));
        data = BufferUtil.toBuffer((String)"DARX nor is this");
        parser.parse(data, false);
        Assert.assertThat((Object)parser.getState(), (Matcher)Matchers.is((Object)MultiPartParser.State.PREAMBLE));
        Assert.assertThat((Object)data.remaining(), (Matcher)Matchers.is((Object)0));
    }

    @Test
    public void testPreambleCompleteBoundary() {
        MultiPartParser parser = new MultiPartParser(new MultiPartParser.Handler(){}, "BOUNDARY");
        ByteBuffer data = BufferUtil.toBuffer((String)"This is not part of a part\r\n--BOUNDARY  \r\n");
        parser.parse(data, false);
        Assert.assertThat((Object)parser.getState(), (Matcher)Matchers.is((Object)MultiPartParser.State.BODY_PART));
        Assert.assertThat((Object)data.remaining(), (Matcher)Matchers.is((Object)0));
    }

    @Test
    public void testPreambleSplitBoundary() {
        MultiPartParser parser = new MultiPartParser(new MultiPartParser.Handler(){}, "BOUNDARY");
        ByteBuffer data = BufferUtil.toBuffer((String)"This is not part of a part\r\n");
        parser.parse(data, false);
        Assert.assertThat((Object)parser.getState(), (Matcher)Matchers.is((Object)MultiPartParser.State.PREAMBLE));
        Assert.assertThat((Object)data.remaining(), (Matcher)Matchers.is((Object)0));
        data = BufferUtil.toBuffer((String)"-");
        parser.parse(data, false);
        Assert.assertThat((Object)parser.getState(), (Matcher)Matchers.is((Object)MultiPartParser.State.PREAMBLE));
        Assert.assertThat((Object)data.remaining(), (Matcher)Matchers.is((Object)0));
        data = BufferUtil.toBuffer((String)"-");
        parser.parse(data, false);
        Assert.assertThat((Object)parser.getState(), (Matcher)Matchers.is((Object)MultiPartParser.State.PREAMBLE));
        Assert.assertThat((Object)data.remaining(), (Matcher)Matchers.is((Object)0));
        data = BufferUtil.toBuffer((String)"B");
        parser.parse(data, false);
        Assert.assertThat((Object)parser.getState(), (Matcher)Matchers.is((Object)MultiPartParser.State.PREAMBLE));
        Assert.assertThat((Object)data.remaining(), (Matcher)Matchers.is((Object)0));
        data = BufferUtil.toBuffer((String)"OUNDARY-");
        parser.parse(data, false);
        Assert.assertThat((Object)parser.getState(), (Matcher)Matchers.is((Object)MultiPartParser.State.DELIMITER_CLOSE));
        Assert.assertThat((Object)data.remaining(), (Matcher)Matchers.is((Object)0));
        data = BufferUtil.toBuffer((String)"ignore\r");
        parser.parse(data, false);
        Assert.assertThat((Object)parser.getState(), (Matcher)Matchers.is((Object)MultiPartParser.State.DELIMITER_PADDING));
        Assert.assertThat((Object)data.remaining(), (Matcher)Matchers.is((Object)0));
        data = BufferUtil.toBuffer((String)"\n");
        parser.parse(data, false);
        Assert.assertThat((Object)parser.getState(), (Matcher)Matchers.is((Object)MultiPartParser.State.BODY_PART));
        Assert.assertThat((Object)data.remaining(), (Matcher)Matchers.is((Object)0));
    }

    @Test
    public void testFirstPartNoFields() {
        MultiPartParser parser = new MultiPartParser(new MultiPartParser.Handler(){}, "BOUNDARY");
        ByteBuffer data = BufferUtil.toBuffer((String)"");
        data = BufferUtil.toBuffer((String)"--BOUNDARY\r\n\r\n");
        parser.parse(data, false);
        Assert.assertThat((Object)parser.getState(), (Matcher)Matchers.is((Object)MultiPartParser.State.FIRST_OCTETS));
        Assert.assertThat((Object)data.remaining(), (Matcher)Matchers.is((Object)0));
    }

    @Test
    public void testFirstPartFields() {
        TestHandler handler = new TestHandler(){

            @Override
            public boolean headerComplete() {
                super.headerComplete();
                return true;
            }
        };
        MultiPartParser parser = new MultiPartParser((MultiPartParser.Handler)handler, "BOUNDARY");
        ByteBuffer data = BufferUtil.toBuffer((String)"");
        data = BufferUtil.toBuffer((String)"--BOUNDARY\r\nname0: value0\r\nname1 :value1 \r\nname2:value\r\n 2\r\n\r\nContent");
        parser.parse(data, false);
        Assert.assertThat((Object)parser.getState(), (Matcher)Matchers.is((Object)MultiPartParser.State.FIRST_OCTETS));
        Assert.assertThat((Object)data.remaining(), (Matcher)Matchers.is((Object)7));
        Assert.assertThat(handler.fields, (Matcher)Matchers.contains((Object[])new String[]{"name0: value0", "name1: value1", "name2: value 2", "<<COMPLETE>>"}));
    }

    @Test
    public void testFirstPartNoContent() {
        TestHandler handler = new TestHandler();
        MultiPartParser parser = new MultiPartParser((MultiPartParser.Handler)handler, "BOUNDARY");
        ByteBuffer data = BufferUtil.toBuffer((String)"");
        data = BufferUtil.toBuffer((String)"--BOUNDARY\r\nname: value\r\n\r\n\r\n--BOUNDARY");
        parser.parse(data, false);
        Assert.assertThat((Object)parser.getState(), (Matcher)Matchers.is((Object)MultiPartParser.State.DELIMITER));
        Assert.assertThat((Object)data.remaining(), (Matcher)Matchers.is((Object)0));
        Assert.assertThat(handler.fields, (Matcher)Matchers.contains((Object[])new String[]{"name: value", "<<COMPLETE>>"}));
        Assert.assertThat(handler.content, (Matcher)Matchers.contains((Object[])new String[]{"<<LAST>>"}));
    }

    @Test
    public void testFirstPartNoContentNoCRLF() {
        TestHandler handler = new TestHandler();
        MultiPartParser parser = new MultiPartParser((MultiPartParser.Handler)handler, "BOUNDARY");
        ByteBuffer data = BufferUtil.toBuffer((String)"");
        data = BufferUtil.toBuffer((String)"--BOUNDARY\r\nname: value\r\n\r\n--BOUNDARY");
        parser.parse(data, false);
        Assert.assertThat((Object)parser.getState(), (Matcher)Matchers.is((Object)MultiPartParser.State.DELIMITER));
        Assert.assertThat((Object)data.remaining(), (Matcher)Matchers.is((Object)0));
        Assert.assertThat(handler.fields, (Matcher)Matchers.contains((Object[])new String[]{"name: value", "<<COMPLETE>>"}));
        Assert.assertThat(handler.content, (Matcher)Matchers.contains((Object[])new String[]{"<<LAST>>"}));
    }

    @Test
    public void testFirstPartContentLookingLikeNoCRLF() {
        TestHandler handler = new TestHandler();
        MultiPartParser parser = new MultiPartParser((MultiPartParser.Handler)handler, "BOUNDARY");
        ByteBuffer data = BufferUtil.toBuffer((String)"");
        data = BufferUtil.toBuffer((String)"--BOUNDARY\r\nname: value\r\n\r\n-");
        parser.parse(data, false);
        data = BufferUtil.toBuffer((String)"Content!");
        parser.parse(data, false);
        Assert.assertThat((Object)parser.getState(), (Matcher)Matchers.is((Object)MultiPartParser.State.OCTETS));
        Assert.assertThat((Object)data.remaining(), (Matcher)Matchers.is((Object)0));
        Assert.assertThat(handler.fields, (Matcher)Matchers.contains((Object[])new String[]{"name: value", "<<COMPLETE>>"}));
        Assert.assertThat(handler.content, (Matcher)Matchers.contains((Object[])new String[]{"-", "Content!"}));
    }

    @Test
    public void testFirstPartPartialContent() {
        TestHandler handler = new TestHandler();
        MultiPartParser parser = new MultiPartParser((MultiPartParser.Handler)handler, "BOUNDARY");
        ByteBuffer data = BufferUtil.toBuffer((String)"");
        data = BufferUtil.toBuffer((String)"--BOUNDARY\r\nname: value\n\r\nHello\r\n");
        parser.parse(data, false);
        Assert.assertThat((Object)parser.getState(), (Matcher)Matchers.is((Object)MultiPartParser.State.OCTETS));
        Assert.assertThat((Object)data.remaining(), (Matcher)Matchers.is((Object)0));
        Assert.assertThat(handler.fields, (Matcher)Matchers.contains((Object[])new String[]{"name: value", "<<COMPLETE>>"}));
        Assert.assertThat(handler.content, (Matcher)Matchers.contains((Object[])new String[]{"Hello"}));
        data = BufferUtil.toBuffer((String)"Now is the time for all good ment to come to the aid of the party.\r\nHow now brown cow.\r\nThe quick brown fox jumped over the lazy dog.\r\nthis is not a --BOUNDARY\r\n");
        parser.parse(data, false);
        Assert.assertThat((Object)parser.getState(), (Matcher)Matchers.is((Object)MultiPartParser.State.OCTETS));
        Assert.assertThat((Object)data.remaining(), (Matcher)Matchers.is((Object)0));
        Assert.assertThat(handler.fields, (Matcher)Matchers.contains((Object[])new String[]{"name: value", "<<COMPLETE>>"}));
        Assert.assertThat(handler.content, (Matcher)Matchers.contains((Object[])new String[]{"Hello", "\r\n", "Now is the time for all good ment to come to the aid of the party.\r\nHow now brown cow.\r\nThe quick brown fox jumped over the lazy dog.\r\nthis is not a --BOUNDARY"}));
    }

    @Test
    public void testFirstPartShortContent() {
        TestHandler handler = new TestHandler();
        MultiPartParser parser = new MultiPartParser((MultiPartParser.Handler)handler, "BOUNDARY");
        ByteBuffer data = BufferUtil.toBuffer((String)"");
        data = BufferUtil.toBuffer((String)"--BOUNDARY\r\nname: value\n\r\nHello\r\n--BOUNDARY");
        parser.parse(data, false);
        Assert.assertThat((Object)parser.getState(), (Matcher)Matchers.is((Object)MultiPartParser.State.DELIMITER));
        Assert.assertThat((Object)data.remaining(), (Matcher)Matchers.is((Object)0));
        Assert.assertThat(handler.fields, (Matcher)Matchers.contains((Object[])new String[]{"name: value", "<<COMPLETE>>"}));
        Assert.assertThat(handler.content, (Matcher)Matchers.contains((Object[])new String[]{"Hello", "<<LAST>>"}));
    }

    @Test
    public void testFirstPartLongContent() {
        TestHandler handler = new TestHandler();
        MultiPartParser parser = new MultiPartParser((MultiPartParser.Handler)handler, "BOUNDARY");
        ByteBuffer data = BufferUtil.toBuffer((String)"");
        data = BufferUtil.toBuffer((String)"--BOUNDARY\r\nname: value\n\r\nNow is the time for all good ment to come to the aid of the party.\r\nHow now brown cow.\r\nThe quick brown fox jumped over the lazy dog.\r\n\r\n--BOUNDARY");
        parser.parse(data, false);
        Assert.assertThat((Object)parser.getState(), (Matcher)Matchers.is((Object)MultiPartParser.State.DELIMITER));
        Assert.assertThat((Object)data.remaining(), (Matcher)Matchers.is((Object)0));
        Assert.assertThat(handler.fields, (Matcher)Matchers.contains((Object[])new String[]{"name: value", "<<COMPLETE>>"}));
        Assert.assertThat(handler.content, (Matcher)Matchers.contains((Object[])new String[]{"Now is the time for all good ment to come to the aid of the party.\r\nHow now brown cow.\r\nThe quick brown fox jumped over the lazy dog.\r\n", "<<LAST>>"}));
    }

    @Test
    public void testFirstPartLongContentNoCarriageReturn() {
        TestHandler handler = new TestHandler();
        MultiPartParser parser = new MultiPartParser((MultiPartParser.Handler)handler, "BOUNDARY");
        ByteBuffer data = BufferUtil.toBuffer((String)"");
        data = BufferUtil.toBuffer((String)"--BOUNDARY\nname: value\n\nNow is the time for all good men to come to the aid of the party.\nHow now brown cow.\nThe quick brown fox jumped over the lazy dog.\n\r\n--BOUNDARY");
        parser.parse(data, false);
        Assert.assertThat((Object)parser.getState(), (Matcher)Matchers.is((Object)MultiPartParser.State.DELIMITER));
        Assert.assertThat((Object)data.remaining(), (Matcher)Matchers.is((Object)0));
        Assert.assertThat(handler.fields, (Matcher)Matchers.contains((Object[])new String[]{"name: value", "<<COMPLETE>>"}));
        Assert.assertThat(handler.content, (Matcher)Matchers.contains((Object[])new String[]{"Now is the time for all good men to come to the aid of the party.\nHow now brown cow.\nThe quick brown fox jumped over the lazy dog.\n", "<<LAST>>"}));
    }

    @Test
    public void testBinaryPart() {
        byte[] random = new byte[8192];
        final ByteBuffer bytes = BufferUtil.allocate((int)random.length);
        ThreadLocalRandom.current().nextBytes(random);
        TestHandler handler = new TestHandler(){

            @Override
            public boolean content(ByteBuffer buffer, boolean last) {
                BufferUtil.append((ByteBuffer)bytes, (ByteBuffer)buffer);
                return last;
            }
        };
        MultiPartParser parser = new MultiPartParser((MultiPartParser.Handler)handler, "BOUNDARY");
        String preamble = "Blah blah blah\r\n--BOUNDARY\r\n\r\n";
        String epilogue = "\r\n--BOUNDARY\r\nBlah blah blah!\r\n";
        ByteBuffer data = BufferUtil.allocate((int)(preamble.length() + random.length + epilogue.length()));
        BufferUtil.append((ByteBuffer)data, (ByteBuffer)BufferUtil.toBuffer((String)preamble));
        BufferUtil.append((ByteBuffer)data, (ByteBuffer)ByteBuffer.wrap(random));
        BufferUtil.append((ByteBuffer)data, (ByteBuffer)BufferUtil.toBuffer((String)epilogue));
        parser.parse(data, true);
        Assert.assertThat((Object)parser.getState(), (Matcher)Matchers.is((Object)MultiPartParser.State.DELIMITER));
        Assert.assertThat((Object)data.remaining(), (Matcher)Matchers.is((Object)19));
        Assert.assertThat((Object)bytes.array(), (Matcher)Matchers.is((Object)random));
    }

    @Test
    public void testEpilogue() {
        TestHandler handler = new TestHandler();
        MultiPartParser parser = new MultiPartParser((MultiPartParser.Handler)handler, "BOUNDARY");
        ByteBuffer data = BufferUtil.toBuffer((String)"--BOUNDARY\r\nname: value\n\r\nHello\r\n--BOUNDARY--epilogue here:\r\n--BOUNDARY--\r\n--BOUNDARY");
        parser.parse(data, false);
        Assert.assertThat((Object)parser.getState(), (Matcher)Matchers.is((Object)MultiPartParser.State.DELIMITER));
        Assert.assertThat(handler.fields, (Matcher)Matchers.contains((Object[])new String[]{"name: value", "<<COMPLETE>>"}));
        Assert.assertThat(handler.content, (Matcher)Matchers.contains((Object[])new String[]{"Hello", "<<LAST>>"}));
        parser.parse(data, true);
        Assert.assertThat((Object)parser.getState(), (Matcher)Matchers.is((Object)MultiPartParser.State.END));
    }

    @Test
    public void testMultipleContent() {
        TestHandler handler = new TestHandler();
        MultiPartParser parser = new MultiPartParser((MultiPartParser.Handler)handler, "BOUNDARY");
        ByteBuffer data = BufferUtil.toBuffer((String)"--BOUNDARY\r\nname: value\n\r\nHello\r\n--BOUNDARY\r\npowerLevel: 9001\n\r\nsecondary\r\ncontent\r\n--BOUNDARY--epilogue here");
        parser.parse(data, false);
        Assert.assertThat((Object)parser.getState(), (Matcher)Matchers.is((Object)MultiPartParser.State.DELIMITER));
        Assert.assertThat(handler.fields, (Matcher)Matchers.contains((Object[])new String[]{"name: value", "<<COMPLETE>>"}));
        Assert.assertThat(handler.content, (Matcher)Matchers.contains((Object[])new String[]{"Hello", "<<LAST>>"}));
        parser.parse(data, false);
        Assert.assertThat((Object)parser.getState(), (Matcher)Matchers.is((Object)MultiPartParser.State.DELIMITER));
        Assert.assertThat(handler.fields, (Matcher)Matchers.contains((Object[])new String[]{"name: value", "<<COMPLETE>>", "powerLevel: 9001", "<<COMPLETE>>"}));
        Assert.assertThat(handler.content, (Matcher)Matchers.contains((Object[])new String[]{"Hello", "<<LAST>>", "secondary\r\ncontent", "<<LAST>>"}));
        parser.parse(data, true);
        Assert.assertThat((Object)parser.getState(), (Matcher)Matchers.is((Object)MultiPartParser.State.END));
        Assert.assertThat((Object)data.remaining(), (Matcher)Matchers.is((Object)0));
    }

    @Test
    public void testCrAsLineTermination() {
        TestHandler handler = new TestHandler(){

            public boolean messageComplete() {
                return true;
            }

            @Override
            public boolean content(ByteBuffer buffer, boolean last) {
                super.content(buffer, last);
                return false;
            }
        };
        MultiPartParser parser = new MultiPartParser((MultiPartParser.Handler)handler, "AaB03x");
        ByteBuffer data = BufferUtil.toBuffer((String)"--AaB03x\r\ncontent-disposition: form-data; name=\"field1\"\r\n\rJoe Blow\r\n--AaB03x--\r\n");
        try {
            parser.parse(data, true);
            Assert.fail((String)"Invalid End of Line");
        }
        catch (BadMessageException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Bad EOL"));
        }
    }

    @Test
    public void splitTest() {
        TestHandler handler = new TestHandler(){

            public boolean messageComplete() {
                return true;
            }

            @Override
            public boolean content(ByteBuffer buffer, boolean last) {
                super.content(buffer, last);
                return false;
            }
        };
        MultiPartParser parser = new MultiPartParser((MultiPartParser.Handler)handler, "---------------------------9051914041544843365972754266");
        ByteBuffer data = BufferUtil.toBuffer((String)"POST / HTTP/1.1\nHost: localhost:8000\nUser-Agent: Mozilla/5.0 (X11; Ubuntu; Linux i686; rv:29.0) Gecko/20100101 Firefox/29.0\nAccept: text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8\nAccept-Language: en-US,en;q=0.5\nAccept-Encoding: gzip, deflate\nCookie: __atuvc=34%7C7; permanent=0; _gitlab_session=226ad8a0be43681acf38c2fab9497240; __profilin=p%3Dt; request_method=GET\nConnection: keep-alive\nContent-Type: multipart/form-data; boundary=---------------------------9051914041544843365972754266\nContent-Length: 554\n\r\n-----------------------------9051914041544843365972754266\nContent-Disposition: form-data; name=\"text\"\n\ntext default\r\n-----------------------------9051914041544843365972754266\nContent-Disposition: form-data; name=\"file1\"; filename=\"a.txt\"\nContent-Type: text/plain\n\nContent of a.txt.\n\r\n-----------------------------9051914041544843365972754266\nContent-Disposition: form-data; name=\"file2\"; filename=\"a.html\"\nContent-Type: text/html\n\n<!DOCTYPE html><title>Content of a.html.</title>\n\r\n-----------------------------9051914041544843365972754266\nField1: value1\nField2: value2\nField3: value3\nField4: value4\nField5: value5\nField6: value6\nField7: value7\nField8: value8\nField9: value\n 9\n\r\n-----------------------------9051914041544843365972754266\nField1: value1\n\r\nBut the amount of denudation which the strata have\nin many places suffered, independently of the rate\nof accumulation of the degraded matter, probably\noffers the best evidence of the lapse of time. I remember\nhaving been much struck with the evidence of\ndenudation, when viewing volcanic islands, which\nhave been worn by the waves and pared all round\ninto perpendicular cliffs of one or two thousand feet\nin height; for the gentle slope of the lava-streams,\ndue to their formerly liquid state, showed at a glance\nhow far the hard, rocky beds had once extended into\nthe open ocean.\n\r\n-----------------------------9051914041544843365972754266--===== ajlkfja;lkdj;lakjd;lkjf ==== epilogue here  ==== kajflajdfl;kjafl;kjl;dkfja ====\n\r\n\r\r\r\n\n\n");
        int length = data.remaining();
        for (int i = 0; i < length - 1; ++i) {
            ByteBuffer dataSeg = data.slice();
            dataSeg.position(0);
            dataSeg.limit(i);
            Assert.assertThat((String)("First " + i), (Object)parser.parse(dataSeg, false), (Matcher)Matchers.is((Object)false));
            dataSeg = data.slice();
            dataSeg.position(i);
            dataSeg.limit(i + 1);
            Assert.assertThat((String)("Second " + i), (Object)parser.parse(dataSeg, false), (Matcher)Matchers.is((Object)false));
            dataSeg = data.slice();
            dataSeg.position(i + 1);
            dataSeg.limit(length);
            Assert.assertThat((String)("Third " + i), (Object)parser.parse(dataSeg, true), (Matcher)Matchers.is((Object)true));
            Assert.assertThat(handler.fields, (Matcher)Matchers.contains((Object[])new String[]{"Content-Disposition: form-data; name=\"text\"", "<<COMPLETE>>", "Content-Disposition: form-data; name=\"file1\"; filename=\"a.txt\"", "Content-Type: text/plain", "<<COMPLETE>>", "Content-Disposition: form-data; name=\"file2\"; filename=\"a.html\"", "Content-Type: text/html", "<<COMPLETE>>", "Field1: value1", "Field2: value2", "Field3: value3", "Field4: value4", "Field5: value5", "Field6: value6", "Field7: value7", "Field8: value8", "Field9: value 9", "<<COMPLETE>>", "Field1: value1", "<<COMPLETE>>"}));
            Assert.assertThat((Object)handler.contentString(), (Matcher)Matchers.is((Object)new String("text default<<LAST>>Content of a.txt.\n<<LAST>><!DOCTYPE html><title>Content of a.html.</title>\n<<LAST>><<LAST>>But the amount of denudation which the strata have\nin many places suffered, independently of the rate\nof accumulation of the degraded matter, probably\noffers the best evidence of the lapse of time. I remember\nhaving been much struck with the evidence of\ndenudation, when viewing volcanic islands, which\nhave been worn by the waves and pared all round\ninto perpendicular cliffs of one or two thousand feet\nin height; for the gentle slope of the lava-streams,\ndue to their formerly liquid state, showed at a glance\nhow far the hard, rocky beds had once extended into\nthe open ocean.\n<<LAST>>")));
            handler.clear();
            parser.reset();
        }
    }

    @Test
    public void testGeneratedForm() {
        TestHandler handler = new TestHandler(){

            public boolean messageComplete() {
                return true;
            }

            @Override
            public boolean content(ByteBuffer buffer, boolean last) {
                super.content(buffer, last);
                return false;
            }

            @Override
            public boolean headerComplete() {
                return false;
            }
        };
        MultiPartParser parser = new MultiPartParser((MultiPartParser.Handler)handler, "WebKitFormBoundary7MA4YWf7OaKlSxkTrZu0gW");
        ByteBuffer data = BufferUtil.toBuffer((String)"Content-Type: multipart/form-data; boundary=WebKitFormBoundary7MA4YWf7OaKlSxkTrZu0gW\r\n\r\n--WebKitFormBoundary7MA4YWf7OaKlSxkTrZu0gW\r\nContent-Disposition: form-data; name=\"part1\"\r\n\nwNf\uff90xVam\uffbft\r\n--WebKitFormBoundary7MA4YWf7OaKlSxkTrZu0gW\nContent-Disposition: form-data; name=\"part2\"\r\n\r\n&\uffb3\u001b\u0014\uffba\uffd9\ufff9\uffd6\uffc3O\r\n--WebKitFormBoundary7MA4YWf7OaKlSxkTrZu0gW--");
        parser.parse(data, true);
        Assert.assertThat((Object)parser.getState(), (Matcher)Matchers.is((Object)MultiPartParser.State.END));
        Assert.assertThat((Object)handler.fields.size(), (Matcher)Matchers.is((Object)2));
    }

    static class TestHandler
    implements MultiPartParser.Handler {
        List<String> fields = new ArrayList<String>();
        List<String> content = new ArrayList<String>();

        TestHandler() {
        }

        public void parsedField(String name, String value) {
            this.fields.add(name + ": " + value);
        }

        public String contentString() {
            StringBuilder sb = new StringBuilder();
            for (String s : this.content) {
                sb.append(s);
            }
            return sb.toString();
        }

        public boolean headerComplete() {
            this.fields.add("<<COMPLETE>>");
            return false;
        }

        public boolean content(ByteBuffer buffer, boolean last) {
            if (BufferUtil.hasContent((ByteBuffer)buffer)) {
                this.content.add(BufferUtil.toString((ByteBuffer)buffer));
            }
            if (last) {
                this.content.add("<<LAST>>");
            }
            return last;
        }

        public void clear() {
            this.fields.clear();
            this.content.clear();
        }
    }
}

