/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Function;
import javax.servlet.MultipartConfigElement;
import javax.servlet.http.Part;
import org.eclipse.jetty.http.MultiPartFormInputStream;
import org.eclipse.jetty.toolchain.test.Hex;
import org.eclipse.jetty.toolchain.test.MavenTestingUtils;
import org.eclipse.jetty.toolchain.test.TestingDir;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.MultiPartInputStreamParser;
import org.eclipse.jetty.util.QuotedStringTokenizer;
import org.eclipse.jetty.util.StringUtil;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class MultiPartCaptureTest {
    public static final int MAX_FILE_SIZE = 0x200000;
    public static final int MAX_REQUEST_SIZE = 0x20F000;
    public static final int FILE_SIZE_THRESHOLD = 50;
    @Rule
    public TestingDir testingDir = new TestingDir();
    private final Path multipartRawFile;
    private final MultipartExpectations multipartExpectations;

    @Parameterized.Parameters(name="{0}")
    public static List<Object[]> data() {
        ArrayList<Object[]> ret = new ArrayList<Object[]>();
        ret.add(new String[]{"multipart-uppercase"});
        ret.add(new String[]{"browser-capture-company-urlencoded-apache-httpcomp"});
        ret.add(new String[]{"browser-capture-complex-apache-httpcomp"});
        ret.add(new String[]{"browser-capture-duplicate-names-apache-httpcomp"});
        ret.add(new String[]{"browser-capture-encoding-mess-apache-httpcomp"});
        ret.add(new String[]{"browser-capture-nested-apache-httpcomp"});
        ret.add(new String[]{"browser-capture-nested-binary-apache-httpcomp"});
        ret.add(new String[]{"browser-capture-number-only2-apache-httpcomp"});
        ret.add(new String[]{"browser-capture-number-only-apache-httpcomp"});
        ret.add(new String[]{"browser-capture-sjis-apache-httpcomp"});
        ret.add(new String[]{"browser-capture-strange-quoting-apache-httpcomp"});
        ret.add(new String[]{"browser-capture-text-files-apache-httpcomp"});
        ret.add(new String[]{"browser-capture-unicode-names-apache-httpcomp"});
        ret.add(new String[]{"browser-capture-zalgo-text-plain-apache-httpcomp"});
        ret.add(new String[]{"browser-capture-complex-jetty-client"});
        ret.add(new String[]{"browser-capture-duplicate-names-jetty-client"});
        ret.add(new String[]{"browser-capture-encoding-mess-jetty-client"});
        ret.add(new String[]{"browser-capture-nested-jetty-client"});
        ret.add(new String[]{"browser-capture-number-only-jetty-client"});
        ret.add(new String[]{"browser-capture-sjis-jetty-client"});
        ret.add(new String[]{"browser-capture-text-files-jetty-client"});
        ret.add(new String[]{"browser-capture-unicode-names-jetty-client"});
        ret.add(new String[]{"browser-capture-whitespace-only-jetty-client"});
        ret.add(new String[]{"browser-capture-form1-android-chrome"});
        ret.add(new String[]{"browser-capture-form1-android-firefox"});
        ret.add(new String[]{"browser-capture-form1-chrome"});
        ret.add(new String[]{"browser-capture-form1-edge"});
        ret.add(new String[]{"browser-capture-form1-firefox"});
        ret.add(new String[]{"browser-capture-form1-ios-safari"});
        ret.add(new String[]{"browser-capture-form1-msie"});
        ret.add(new String[]{"browser-capture-form1-osx-safari"});
        ret.add(new String[]{"browser-capture-sjis-form-edge"});
        ret.add(new String[]{"browser-capture-sjis-form-msie"});
        ret.add(new String[]{"browser-capture-sjis-charset-form-android-chrome"});
        ret.add(new String[]{"browser-capture-sjis-charset-form-android-firefox"});
        ret.add(new String[]{"browser-capture-sjis-charset-form-chrome"});
        ret.add(new String[]{"browser-capture-sjis-charset-form-edge"});
        ret.add(new String[]{"browser-capture-sjis-charset-form-firefox"});
        ret.add(new String[]{"browser-capture-sjis-charset-form-ios-safari"});
        ret.add(new String[]{"browser-capture-sjis-charset-form-msie"});
        ret.add(new String[]{"browser-capture-sjis-charset-form-safari"});
        ret.add(new String[]{"browser-capture-form-fileupload-android-chrome"});
        ret.add(new String[]{"browser-capture-form-fileupload-android-firefox"});
        ret.add(new String[]{"browser-capture-form-fileupload-chrome"});
        ret.add(new String[]{"browser-capture-form-fileupload-edge"});
        ret.add(new String[]{"browser-capture-form-fileupload-firefox"});
        ret.add(new String[]{"browser-capture-form-fileupload-ios-safari"});
        ret.add(new String[]{"browser-capture-form-fileupload-msie"});
        ret.add(new String[]{"browser-capture-form-fileupload-safari"});
        ret.add(new String[]{"browser-capture-form-fileupload-alt-chrome"});
        ret.add(new String[]{"browser-capture-form-fileupload-alt-edge"});
        ret.add(new String[]{"browser-capture-form-fileupload-alt-firefox"});
        ret.add(new String[]{"browser-capture-form-fileupload-alt-msie"});
        ret.add(new String[]{"browser-capture-form-fileupload-alt-safari"});
        return ret;
    }

    public MultiPartCaptureTest(String rawPrefix) throws IOException {
        this.multipartRawFile = MavenTestingUtils.getTestResourcePathFile((String)("multipart/" + rawPrefix + ".raw"));
        Path expectationPath = MavenTestingUtils.getTestResourcePathFile((String)("multipart/" + rawPrefix + ".expected.txt"));
        this.multipartExpectations = new MultipartExpectations(expectationPath);
    }

    @Test
    public void testUtilParse() throws Exception {
        Path outputDir = this.testingDir.getEmptyPathDir();
        MultipartConfigElement config = this.newMultipartConfigElement(outputDir);
        try (InputStream in = Files.newInputStream(this.multipartRawFile, new OpenOption[0]);){
            MultiPartInputStreamParser parser = new MultiPartInputStreamParser(in, this.multipartExpectations.contentType, config, outputDir.toFile());
            this.checkParts(parser.getParts(), s -> {
                try {
                    return parser.getPart(s);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
        }
    }

    @Test
    public void testHttpParse() throws Exception {
        Path outputDir = this.testingDir.getEmptyPathDir();
        MultipartConfigElement config = this.newMultipartConfigElement(outputDir);
        try (InputStream in = Files.newInputStream(this.multipartRawFile, new OpenOption[0]);){
            MultiPartFormInputStream parser = new MultiPartFormInputStream(in, this.multipartExpectations.contentType, config, outputDir.toFile());
            this.checkParts(parser.getParts(), s -> {
                try {
                    return parser.getPart(s);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
        }
    }

    private void checkParts(Collection<Part> parts, Function<String, Part> getPart) throws Exception {
        Part part;
        if (this.multipartExpectations.partCount >= 0) {
            Assert.assertThat((String)"Mulitpart.parts.size", (Object)parts.size(), (Matcher)Matchers.is((Object)this.multipartExpectations.partCount));
        }
        String defaultCharset = StandardCharsets.UTF_8.toString();
        Part charSetPart = getPart.apply("_charset_");
        if (charSetPart != null) {
            defaultCharset = IO.toString((InputStream)charSetPart.getInputStream());
        }
        for (NameValue expected : this.multipartExpectations.partContainsContents) {
            part = getPart.apply(expected.name);
            Assert.assertThat((String)("Part[" + expected.name + "]"), (Object)part, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            InputStream partInputStream = part.getInputStream();
            Throwable throwable = null;
            try {
                String charset = this.getCharsetFromContentType(part.getContentType(), defaultCharset);
                String contents = IO.toString((InputStream)partInputStream, (String)charset);
                Assert.assertThat((String)("Part[" + expected.name + "].contents"), (Object)contents, (Matcher)Matchers.containsString((String)expected.value));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (partInputStream == null) continue;
                MultiPartCaptureTest.$closeResource(throwable, partInputStream);
            }
        }
        for (NameValue expected : this.multipartExpectations.partFilenames) {
            part = getPart.apply(expected.name);
            Assert.assertThat((String)("Part[" + expected.name + "]"), (Object)part, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            Assert.assertThat((String)("Part[" + expected.name + "]"), (Object)part.getSubmittedFileName(), (Matcher)Matchers.is((Object)expected.value));
        }
        for (NameValue expected : this.multipartExpectations.partSha1sums) {
            part = getPart.apply(expected.name);
            Assert.assertThat((String)("Part[" + expected.name + "]"), (Object)part, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            MessageDigest digest = MessageDigest.getInstance("SHA1");
            InputStream partInputStream = part.getInputStream();
            Throwable throwable = null;
            try (NoOpOutputStream noop = new NoOpOutputStream();
                 DigestOutputStream digester = new DigestOutputStream(noop, digest);){
                IO.copy((InputStream)partInputStream, (OutputStream)digester);
                String actualSha1sum = Hex.asHex((byte[])digest.digest()).toLowerCase(Locale.US);
                Assert.assertThat((String)("Part[" + expected.name + "].sha1sum"), (Object)actualSha1sum, (Matcher)Matchers.equalToIgnoringCase((String)expected.value));
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
            finally {
                if (partInputStream == null) continue;
                MultiPartCaptureTest.$closeResource(throwable, partInputStream);
            }
        }
    }

    private MultipartConfigElement newMultipartConfigElement(Path path) {
        return new MultipartConfigElement(path.toString(), 0x200000L, 0x20F000L, 50);
    }

    private String getCharsetFromContentType(String contentType, String defaultCharset) {
        if (StringUtil.isBlank((String)contentType)) {
            return defaultCharset;
        }
        QuotedStringTokenizer tok = new QuotedStringTokenizer(contentType, ";", false, false);
        while (tok.hasMoreTokens()) {
            String str = tok.nextToken().trim();
            if (!str.startsWith("charset=")) continue;
            return str.substring("charset=".length());
        }
        return defaultCharset;
    }

    class NoOpOutputStream
    extends OutputStream {
        NoOpOutputStream() {
        }

        @Override
        public void write(byte[] b) throws IOException {
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public void write(int b) throws IOException {
        }
    }

    public static class MultipartExpectations {
        public final String contentType;
        public final int partCount;
        public final List<NameValue> partFilenames = new ArrayList<NameValue>();
        public final List<NameValue> partSha1sums = new ArrayList<NameValue>();
        public final List<NameValue> partContainsContents = new ArrayList<NameValue>();

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public MultipartExpectations(Path expectationsPath) throws IOException {
            String parsedContentType = null;
            String parsedPartCount = "-1";
            try (BufferedReader reader = Files.newBufferedReader(expectationsPath);){
                String line;
                block25: while ((line = reader.readLine()) != null) {
                    if (StringUtil.isBlank((String)(line = line.trim())) || line.startsWith("#")) continue;
                    String[] split = line.split("\\|");
                    switch (split[0]) {
                        case "Request-Header": {
                            if (!split[1].equalsIgnoreCase("Content-Type")) continue block25;
                            parsedContentType = split[2];
                            continue block25;
                        }
                        case "Content-Type": {
                            parsedContentType = split[1];
                            continue block25;
                        }
                        case "Parts-Count": {
                            parsedPartCount = split[1];
                            continue block25;
                        }
                        case "Part-ContainsContents": {
                            NameValue pair = new NameValue();
                            pair.name = split[1];
                            pair.value = split[2];
                            this.partContainsContents.add(pair);
                            continue block25;
                        }
                        case "Part-Filename": {
                            NameValue pair = new NameValue();
                            pair.name = split[1];
                            pair.value = split[2];
                            this.partFilenames.add(pair);
                            continue block25;
                        }
                        case "Part-Sha1sum": {
                            NameValue pair = new NameValue();
                            pair.name = split[1];
                            pair.value = split[2];
                            this.partSha1sums.add(pair);
                            continue block25;
                        }
                    }
                    throw new IOException("Bad Line in " + expectationsPath + ": " + line);
                }
            }
            Objects.requireNonNull(parsedContentType, "Missing required 'Content-Type' declaration: " + expectationsPath);
            this.contentType = parsedContentType;
            this.partCount = Integer.parseInt(parsedPartCount);
        }
    }

    public static class NameValue {
        public String name;
        public String value;
    }
}

