/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http.spi;

import com.sun.net.httpserver.HttpsConfigurator;
import com.sun.net.httpserver.HttpsParameters;
import java.net.InetSocketAddress;
import javax.net.ssl.SSLParameters;
import org.eclipse.jetty.util.ssl.SslContextFactory;

class JettyHttpsParameters
extends HttpsParameters {
    final InetSocketAddress addr;
    final HttpsConfigurator cfg;
    SslContextFactory.Server factoryServer = new SslContextFactory.Server();
    SSLParameters params;

    JettyHttpsParameters(HttpsConfigurator cfg, InetSocketAddress addr) {
        this.addr = addr;
        this.cfg = cfg;
        this.factoryServer.setSslContext(cfg.getSSLContext());
    }

    @Override
    public InetSocketAddress getClientAddress() {
        return this.addr;
    }

    @Override
    public HttpsConfigurator getHttpsConfigurator() {
        return this.cfg;
    }

    @Override
    public void setSSLParameters(SSLParameters p) {
        this.params = p;
        this.factoryServer.setWantClientAuth(p.getWantClientAuth());
        this.factoryServer.setNeedClientAuth(p.getNeedClientAuth());
    }

    SslContextFactory.Server getSSLFactoryServer() {
        return this.factoryServer;
    }
}

