# DO NOT EDIT THIS FILE - See: https://jetty.org/docs/

[description]
Enables the Jetty Proxy Servlet.

[environment]
ee11

[depend]
client
ee11-servlet

[lib]
lib/jetty-ee11-proxy-${jetty.version}.jar

[xml]
etc/jetty-ee11-proxy.xml

[ini-template]
# tag::documentation[]
## The proxy contextPath.
# jetty.proxy.contextPath=/

## The proxy Servlet class.
# jetty.proxy.servletClass=org.eclipse.jetty.ee11.proxy.ProxyServlet$Transparent

## The proxy Servlet mapping.
# jetty.proxy.servletMapping=/*

## The target URI to proxy to, for example http://backend:9090/path.
## This parameter is mandatory.
# jetty.proxy.proxyTo=

## The prefix of the URI path in context to strip from the incoming URI.
## For example, incoming URI http://proxy:8080/ctx/foo/bar, with
## jetty.proxy.prefix=/foo becomes http://backend:9090/path/bar.
# jetty.proxy.prefix=

## The proxy HttpClient max number of threads.
# jetty.proxy.maxThreads=128

## The proxy HttpClient max number of connections.
# jetty.proxy.maxConnections=256

## The proxy HttpClient idle timeout.
# jetty.proxy.idleTimeout=30000

## The proxy HttpClient total request timeout.
# jetty.proxy.timeout=60000

## The proxy HttpClient request buffer size.
# jetty.proxy.requestBufferSize=4096

## The proxy HttpClient response buffer size.
# jetty.proxy.responseBufferSize=16384

## The proxy HttpClient max request headers size.
# jetty.proxy.maxRequestHeadersSize=8192

## The proxy HttpClient max response headers size.
# jetty.proxy.maxResponseHeadersSize=8192

## The proxy HttpClient number of selectors.
# jetty.proxy.selectors=1
# end::documentation[]
