# DO NOT EDIT THIS FILE - See: https://jetty.org/docs/

[description]
Enables the GZIP compression algorithm in CompressionHandler.

[tags]
server
handler
compression
gzip

[depend]
gzip-compression
compression

[xml]
etc/jetty-compression-gzip.xml

[ini-template]
# tag::documentation[]
## Minimum content length after which gzip is enabled
# jetty.compression.gzip.minCompressSize=32

## Inflater pool max size (-1 for unlimited, 0 for no pooling)
# jetty.compression.gzip.inflaterPool.capacity=1024

## Inflater pool use GZIP compatible compression
#jetty.compression.gzip.inflaterPool.noWrap=true

## Deflater pool max size (-1 for unlimited, 0 for no pooling)
# jetty.compression.gzip.deflaterPool.capacity=1024

## Deflater pool default compression level (-1 for default)
# jetty.compression.gzip.deflaterPool.compressionLevel=-1

## Deflater pool use GZIP compatible compression
# jetty.compression.gzip.deflaterPool.noWrap=true

## Buffer Size for Decoder
# jetty.compression.gzip.decoder.bufferSize=512

## Buffer Size for Encoder
# jetty.compression.gzip.encoder.bufferSize=512

## Compression Level for Encoder
## valid values from 1 to 9
## Leave at -1 for default compression level from java.util.zip.Deflater.
# jetty.compression.gzip.encoder.compressionLevel=-1

## Strategy for Encoder
## 0 for Default Strategy
## 1 for Filtered
## 2 for Huffman Only
## See https://docs.oracle.com/en/java/javase/17/docs/api/java.base/java/util/zip/Deflater.html
# jetty.compression.gzip.encoder.strategy=0

## syncFlush for Encoder
## true for SYNC_FLUSH, false for NO_FLUSH (default)
# jetty.compression.gzip.encoder.syncFlush=false
# end::documentation[]
