/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.quic.common.internal.frames;

import java.nio.ByteBuffer;
import org.eclipse.jetty.quic.api.frames.ResetFrame;
import org.eclipse.jetty.quic.util.VarLenInt;

public class ResetStreamParser {
    private final VarLenInt varLenInt;
    private State state = State.FRAME_TYPE;
    private long streamId;
    private long errorCode;
    private long finalSize;

    public ResetStreamParser(VarLenInt varLenInt) {
        this.varLenInt = varLenInt;
    }

    public ResetFrame parse(ByteBuffer byteBuffer) {
        while (byteBuffer.hasRemaining()) {
            switch (this.state.ordinal()) {
                case 0: {
                    byteBuffer.get();
                    this.state = State.STREAM_ID;
                    break;
                }
                case 1: {
                    if (!this.varLenInt.tryDecode(byteBuffer, v -> {
                        this.streamId = v;
                    })) break;
                    this.state = State.ERROR_CODE;
                    break;
                }
                case 2: {
                    if (!this.varLenInt.tryDecode(byteBuffer, v -> {
                        this.errorCode = v;
                    })) break;
                    this.state = State.FINAL_SIZE;
                    break;
                }
                case 3: {
                    if (!this.varLenInt.tryDecode(byteBuffer, v -> {
                        this.finalSize = v;
                    })) break;
                    return this.result();
                }
            }
        }
        return null;
    }

    private ResetFrame result() {
        ResetFrame frame = new ResetFrame(this.streamId, this.errorCode, this.finalSize);
        this.state = State.FRAME_TYPE;
        this.streamId = 0L;
        this.errorCode = 0L;
        this.finalSize = 0L;
        return frame;
    }

    private static enum State {
        FRAME_TYPE,
        STREAM_ID,
        ERROR_CODE,
        FINAL_SIZE;

    }
}

