/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.quic.common.internal.frames;

import java.nio.ByteBuffer;
import org.eclipse.jetty.quic.api.frames.MaxStreamsFrame;
import org.eclipse.jetty.quic.util.ErrorCode;
import org.eclipse.jetty.quic.util.QuicException;
import org.eclipse.jetty.quic.util.VarLenInt;

public class MaxStreamsParser {
    private final VarLenInt varLenInt;
    private State state = State.FRAME_TYPE;
    private long frameType;
    private long maxStreams;

    public MaxStreamsParser(VarLenInt varLenInt) {
        this.varLenInt = varLenInt;
    }

    public MaxStreamsFrame parse(ByteBuffer byteBuffer) {
        while (byteBuffer.hasRemaining()) {
            switch (this.state.ordinal()) {
                case 0: {
                    this.frameType = byteBuffer.get() & 0xFF;
                    this.state = State.MAX_STREAMS;
                    break;
                }
                case 1: {
                    if (!this.varLenInt.tryDecode(byteBuffer, v -> {
                        this.maxStreams = v;
                    })) break;
                    if (this.maxStreams > 0xFFFFFFFFFFFFFFFL) {
                        throw new QuicException(ErrorCode.FRAME_ENCODING_ERROR, "invalid_max_streams_value", this.frameType);
                    }
                    return this.result();
                }
            }
        }
        return null;
    }

    private MaxStreamsFrame result() {
        MaxStreamsFrame frame = new MaxStreamsFrame(this.maxStreams, this.frameType == 18L);
        this.state = State.FRAME_TYPE;
        this.frameType = 0L;
        this.maxStreams = 0L;
        return frame;
    }

    private static enum State {
        FRAME_TYPE,
        MAX_STREAMS;

    }
}

