/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.quic.common.frames;

import java.nio.ByteBuffer;
import org.eclipse.jetty.quic.api.frames.Frame;
import org.eclipse.jetty.quic.api.frames.StreamFrame;
import org.eclipse.jetty.quic.common.frames.FrameType;
import org.eclipse.jetty.quic.common.internal.frames.ConnectionCloseParser;
import org.eclipse.jetty.quic.common.internal.frames.DataBlockedParser;
import org.eclipse.jetty.quic.common.internal.frames.MaxDataParser;
import org.eclipse.jetty.quic.common.internal.frames.MaxStreamsParser;
import org.eclipse.jetty.quic.common.internal.frames.ResetStreamParser;
import org.eclipse.jetty.quic.common.internal.frames.StopSendingParser;
import org.eclipse.jetty.quic.common.internal.frames.StreamDataBlockedParser;
import org.eclipse.jetty.quic.common.internal.frames.StreamMaxDataParser;
import org.eclipse.jetty.quic.common.internal.frames.StreamParser;
import org.eclipse.jetty.quic.common.internal.frames.StreamsBlockedParser;
import org.eclipse.jetty.quic.util.ErrorCode;
import org.eclipse.jetty.quic.util.QuicException;
import org.eclipse.jetty.quic.util.VarLenInt;

public class FrameParser {
    private final VarLenInt varLenInt = new VarLenInt();
    private final ResetStreamParser resetStreamParser = new ResetStreamParser(this.varLenInt);
    private final StopSendingParser stopSendingParser = new StopSendingParser(this.varLenInt);
    private final StreamParser streamParser = new StreamParser(this.varLenInt);
    private final MaxDataParser maxDataParser = new MaxDataParser(this.varLenInt);
    private final StreamMaxDataParser streamMaxDataParser = new StreamMaxDataParser(this.varLenInt);
    private final MaxStreamsParser maxStreamsParser = new MaxStreamsParser(this.varLenInt);
    private final DataBlockedParser dataBlockedParser = new DataBlockedParser(this.varLenInt);
    private final StreamDataBlockedParser streamDataBlockedParser = new StreamDataBlockedParser(this.varLenInt);
    private final StreamsBlockedParser streamsBlockedParser = new StreamsBlockedParser(this.varLenInt);
    private final ConnectionCloseParser connectionCloseParser = new ConnectionCloseParser(this.varLenInt);
    private State state = State.FRAME_TYPE;
    private int frameType;

    public VarLenInt getVarLenInt() {
        return this.varLenInt;
    }

    public int getFrameMaxSize() {
        return this.streamParser.getFrameMaxSize();
    }

    public void setFrameMaxSize(int maxSize) {
        this.streamParser.setFrameMaxSize(maxSize);
    }

    public void setConnectionCloseReasonMaxLength(int maxLength) {
        this.connectionCloseParser.setReasonMaxLength(maxLength);
    }

    public Frame parse(ByteBuffer byteBuffer) {
        while (byteBuffer.hasRemaining()) {
            switch (this.state.ordinal()) {
                case 0: {
                    this.frameType = byteBuffer.get(byteBuffer.position()) & 0xFF;
                    this.state = State.FRAME_BODY;
                    break;
                }
                case 1: {
                    StreamFrame streamFrame;
                    FrameType type = FrameType.from(this.frameType);
                    Frame frame = type != null ? this.parseFrame(byteBuffer, type, this.frameType) : this.parseUnknownFrame(byteBuffer, this.frameType);
                    if (frame == null) {
                        return null;
                    }
                    if (!(frame instanceof StreamFrame) || (streamFrame = (StreamFrame)frame).isEndData()) {
                        this.state = State.FRAME_TYPE;
                    }
                    return frame;
                }
            }
        }
        return null;
    }

    protected Frame parseFrame(ByteBuffer byteBuffer, FrameType frameType, int type) {
        return switch (frameType) {
            case FrameType.PADDING -> new Frame((long)byteBuffer.get());
            case FrameType.RESET_STREAM -> this.parseResetStream(byteBuffer);
            case FrameType.STOP_SENDING -> this.parseStopSending(byteBuffer);
            case FrameType.STREAM -> this.parseStream(byteBuffer);
            case FrameType.MAX_DATA -> this.parseMaxData(byteBuffer);
            case FrameType.STREAM_MAX_DATA -> this.parseStreamMaxData(byteBuffer);
            case FrameType.MAX_STREAMS -> this.parseMaxStreams(byteBuffer);
            case FrameType.DATA_BLOCKED -> this.parseDataBlocked(byteBuffer);
            case FrameType.STREAM_DATA_BLOCKED -> this.parseStreamDataBlocked(byteBuffer);
            case FrameType.STREAMS_BLOCKED -> this.parseStreamsBlocked(byteBuffer);
            case FrameType.CONNECTION_CLOSE -> this.parseConnectionClose(byteBuffer);
            default -> throw new QuicException(ErrorCode.FRAME_ENCODING_ERROR, "unsupported_quic_frame_type", (long)type);
        };
    }

    protected Frame parseUnknownFrame(ByteBuffer byteBuffer, int frameType) {
        throw new QuicException(ErrorCode.FRAME_ENCODING_ERROR, "invalid_quic_frame_type", (long)frameType);
    }

    protected Frame parseResetStream(ByteBuffer byteBuffer) {
        return this.resetStreamParser.parse(byteBuffer);
    }

    protected Frame parseStopSending(ByteBuffer byteBuffer) {
        return this.stopSendingParser.parse(byteBuffer);
    }

    protected Frame parseStream(ByteBuffer byteBuffer) {
        return this.streamParser.parse(byteBuffer);
    }

    protected Frame parseMaxData(ByteBuffer byteBuffer) {
        return this.maxDataParser.parse(byteBuffer);
    }

    protected Frame parseStreamMaxData(ByteBuffer byteBuffer) {
        return this.streamMaxDataParser.parse(byteBuffer);
    }

    protected Frame parseMaxStreams(ByteBuffer byteBuffer) {
        return this.maxStreamsParser.parse(byteBuffer);
    }

    protected Frame parseDataBlocked(ByteBuffer byteBuffer) {
        return this.dataBlockedParser.parse(byteBuffer);
    }

    protected Frame parseStreamDataBlocked(ByteBuffer byteBuffer) {
        return this.streamDataBlockedParser.parse(byteBuffer);
    }

    protected Frame parseStreamsBlocked(ByteBuffer byteBuffer) {
        return this.streamsBlockedParser.parse(byteBuffer);
    }

    protected Frame parseConnectionClose(ByteBuffer byteBuffer) {
        return this.connectionCloseParser.parse(byteBuffer);
    }

    private static enum State {
        FRAME_TYPE,
        FRAME_BODY;

    }
}

