/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http3.qpack.internal.table;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http3.qpack.internal.table.Entry;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.component.Dumpable;

public class DynamicTable
implements Iterable<Entry>,
Dumpable {
    private final Map<HttpField, Entry> _fieldMap = new HashMap<HttpField, Entry>();
    private final Map<String, Entry> _nameMap = new HashMap<String, Entry>();
    private final List<Entry> _entries = new ArrayList<Entry>();
    private int _capacity;
    private int _size;
    private int _absoluteIndex;
    private int _drainingIndex;

    public void add(Entry entry) {
        Iterator<Entry> iterator = this._entries.iterator();
        int entrySize = entry.getSize();
        while (this.getSpace() < entrySize) {
            String name;
            if (!iterator.hasNext()) {
                throw new IllegalStateException("not enough space in dynamic table to add entry");
            }
            Entry e = iterator.next();
            if (e.getReferenceCount() != 0) {
                throw new IllegalStateException("cannot evict entry that is still referenced");
            }
            this._size -= e.getSize();
            iterator.remove();
            HttpField httpField = e.getHttpField();
            if (e == this._fieldMap.get(httpField)) {
                this._fieldMap.remove(httpField);
            }
            if (e != this._nameMap.get(name = httpField.getLowerCaseName())) continue;
            this._nameMap.remove(name);
        }
        if (entrySize + this._size > this._capacity) {
            throw new IllegalStateException("No available space");
        }
        this._size += entrySize;
        entry.setIndex(this._absoluteIndex++);
        this._entries.add(entry);
        this._fieldMap.put(entry.getHttpField(), entry);
        this._nameMap.put(entry.getHttpField().getLowerCaseName(), entry);
        this._drainingIndex = this.getDrainingIndex();
    }

    public boolean canInsert(HttpField field) {
        int requiredSpace;
        int availableSpace = this.getSpace();
        if (availableSpace >= (requiredSpace = Entry.getSize(field))) {
            return true;
        }
        if (requiredSpace > this._capacity) {
            return false;
        }
        for (Entry entry : this._entries) {
            if (entry.getReferenceCount() != 0) {
                return false;
            }
            if ((availableSpace += entry.getSize()) < requiredSpace) continue;
            return true;
        }
        return false;
    }

    public int relativeIndexOf(Entry entry) {
        return this._absoluteIndex - 1 - entry.getIndex();
    }

    public Entry getAbsolute(int absoluteIndex) {
        if (absoluteIndex < 0) {
            throw new IllegalArgumentException("Invalid Index");
        }
        if (this._entries.isEmpty()) {
            throw new IllegalArgumentException("Invalid Index");
        }
        Entry firstEntry = this._entries.get(0);
        int index = absoluteIndex - firstEntry.getIndex();
        if (index < 0 || index >= this._entries.size()) {
            throw new IllegalArgumentException("Invalid Index " + index);
        }
        return this.get(index);
    }

    public Entry get(int index) {
        return this._entries.get(index);
    }

    public Entry get(String name) {
        return this._nameMap.get(name);
    }

    public Entry get(HttpField field) {
        return this._fieldMap.get(field);
    }

    public Entry getRelative(int index) {
        return this.getRelative(this.getInsertCount(), index);
    }

    public Entry getRelative(int base, int index) {
        return this.getAbsolute(base - 1 - index);
    }

    public Entry getPostBase(int base, int index) {
        return this.getAbsolute(base + index);
    }

    public int getBase() {
        if (this._entries.isEmpty()) {
            return this._absoluteIndex;
        }
        return this._entries.get(0).getIndex();
    }

    public int getSize() {
        return this._size;
    }

    public int getCapacity() {
        return this._capacity;
    }

    public int getSpace() {
        return this._capacity - this._size;
    }

    public int getNumEntries() {
        return this._entries.size();
    }

    public int getInsertCount() {
        return this._absoluteIndex;
    }

    public void setCapacity(int capacity) {
        this._capacity = capacity;
        Iterator<Entry> iterator = this._entries.iterator();
        while (this._size > this._capacity) {
            String name;
            if (!iterator.hasNext()) {
                throw new IllegalStateException();
            }
            Entry entry = iterator.next();
            if (entry.getReferenceCount() != 0) {
                return;
            }
            this._size -= entry.getSize();
            iterator.remove();
            HttpField httpField = entry.getHttpField();
            if (entry == this._fieldMap.get(httpField)) {
                this._fieldMap.remove(httpField);
            }
            if (entry != this._nameMap.get(name = httpField.getLowerCaseName())) continue;
            this._nameMap.remove(name);
        }
    }

    public boolean canReference(Entry entry) {
        return entry.getIndex() >= this._drainingIndex;
    }

    protected int getDrainingIndex() {
        int evictionThreshold = this._capacity * 3 / 4;
        if (this._size <= evictionThreshold) {
            return 0;
        }
        int remainingCapacity = this._size;
        for (Entry entry : this._entries) {
            if ((remainingCapacity -= entry.getSize()) > evictionThreshold) continue;
            return entry.getIndex() + 1;
        }
        throw new IllegalStateException();
    }

    @Override
    public Iterator<Entry> iterator() {
        return this._entries.iterator();
    }

    public void dump(Appendable out, String indent) throws IOException {
        Dumpable.dumpObjects((Appendable)out, (String)indent, this._entries, (Object[])new Object[0]);
    }

    public String toString() {
        return String.format("%s@%x{entries=%d,size=%d,max=%d}", TypeUtil.toShortName(this.getClass()), this.hashCode(), this.getNumEntries(), this._size, this._capacity);
    }
}

