/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.fcgi.generator;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import org.eclipse.jetty.fcgi.FCGI;
import org.eclipse.jetty.fcgi.generator.Generator;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.RetainableByteBuffer;
import org.eclipse.jetty.util.BufferUtil;

public class ClientGenerator
extends Generator {
    public static final int MAX_PARAM_LENGTH = 32763;

    public ClientGenerator(ByteBufferPool bufferPool) {
        this(bufferPool, true);
    }

    public ClientGenerator(ByteBufferPool bufferPool, boolean useDirectByteBuffers) {
        super(bufferPool, useDirectByteBuffers);
    }

    public void generateRequestHeaders(ByteBufferPool.Accumulator accumulator, int request, HttpFields fields) {
        request &= 0xFFFF;
        Charset utf8 = StandardCharsets.UTF_8;
        ArrayList<byte[]> bytes = new ArrayList<byte[]>(fields.size() * 2);
        int fieldsLength = 0;
        for (HttpField field : fields) {
            String name = field.getName();
            byte[] nameBytes = name.getBytes(utf8);
            if (nameBytes.length > 32763) {
                throw new IllegalArgumentException("Field name " + name + " exceeds max length 32763");
            }
            bytes.add(nameBytes);
            String value = field.getValue();
            byte[] valueBytes = value.getBytes(utf8);
            if (valueBytes.length > 32763) {
                throw new IllegalArgumentException("Field value " + value + " exceeds max length 32763");
            }
            bytes.add(valueBytes);
            int nameLength = nameBytes.length;
            fieldsLength += this.bytesForLength(nameLength);
            int valueLength = valueBytes.length;
            fieldsLength += this.bytesForLength(valueLength);
            fieldsLength += nameLength;
            fieldsLength += valueLength;
        }
        int maxCapacity = 65534;
        RetainableByteBuffer.Mutable beginBuffer = this.getByteBufferPool().acquire(16, this.isUseDirectByteBuffers());
        accumulator.append((RetainableByteBuffer)beginBuffer);
        ByteBuffer beginByteBuffer = beginBuffer.getByteBuffer();
        BufferUtil.clearToFill((ByteBuffer)beginByteBuffer);
        beginByteBuffer.putInt(0x1010000 + request);
        beginByteBuffer.putInt(524288);
        beginByteBuffer.putLong(0x1010000000000L);
        BufferUtil.flipToFlush((ByteBuffer)beginByteBuffer, (int)0);
        int index = 0;
        while (fieldsLength > 0) {
            int capacity = 8 + Math.min(maxCapacity, fieldsLength);
            RetainableByteBuffer.Mutable buffer = this.getByteBufferPool().acquire(capacity, this.isUseDirectByteBuffers());
            accumulator.append((RetainableByteBuffer)buffer);
            ByteBuffer byteBuffer = buffer.getByteBuffer();
            BufferUtil.clearToFill((ByteBuffer)byteBuffer);
            byteBuffer.putInt(0x1040000 + request);
            byteBuffer.putShort((short)0);
            byteBuffer.putShort((short)0);
            capacity -= 8;
            int length = 0;
            while (index < bytes.size()) {
                byte[] nameBytes = (byte[])bytes.get(index);
                int nameLength = nameBytes.length;
                byte[] valueBytes = (byte[])bytes.get(index + 1);
                int valueLength = valueBytes.length;
                int required = this.bytesForLength(nameLength) + this.bytesForLength(valueLength) + nameLength + valueLength;
                if (required > capacity) break;
                this.putParamLength(byteBuffer, nameLength);
                this.putParamLength(byteBuffer, valueLength);
                byteBuffer.put(nameBytes);
                byteBuffer.put(valueBytes);
                length += required;
                fieldsLength -= required;
                capacity -= required;
                index += 2;
            }
            byteBuffer.putShort(4, (short)length);
            BufferUtil.flipToFlush((ByteBuffer)byteBuffer, (int)0);
        }
        RetainableByteBuffer.Mutable lastBuffer = this.getByteBufferPool().acquire(8, this.isUseDirectByteBuffers());
        accumulator.append((RetainableByteBuffer)lastBuffer);
        ByteBuffer lastByteBuffer = lastBuffer.getByteBuffer();
        BufferUtil.clearToFill((ByteBuffer)lastByteBuffer);
        lastByteBuffer.putInt(0x1040000 + request);
        lastByteBuffer.putInt(0);
        BufferUtil.flipToFlush((ByteBuffer)lastByteBuffer, (int)0);
    }

    private int putParamLength(ByteBuffer buffer, int length) {
        int result = this.bytesForLength(length);
        if (result == 4) {
            buffer.putInt(length | Integer.MIN_VALUE);
        } else {
            buffer.put((byte)length);
        }
        return result;
    }

    private int bytesForLength(int length) {
        return length > 127 ? 4 : 1;
    }

    public void generateRequestContent(ByteBufferPool.Accumulator accumulator, int request, ByteBuffer content, boolean lastContent) {
        this.generateContent(accumulator, request, content, lastContent, FCGI.FrameType.STDIN);
    }
}

