/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.fcgi.client.transport.internal;

import org.eclipse.jetty.client.transport.HttpChannel;
import org.eclipse.jetty.client.transport.HttpExchange;
import org.eclipse.jetty.client.transport.HttpReceiver;
import org.eclipse.jetty.fcgi.client.transport.internal.HttpChannelOverFCGI;
import org.eclipse.jetty.fcgi.client.transport.internal.HttpConnectionOverFCGI;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.Promise;
import org.eclipse.jetty.util.thread.Invocable;

public class HttpReceiverOverFCGI
extends HttpReceiver {
    private final Callback demandContentCallback = new DemandContentCallback();
    private Content.Chunk chunk;

    public HttpReceiverOverFCGI(HttpChannel channel) {
        super(channel);
    }

    void receive() {
        if (this.hasContent()) {
            HttpExchange exchange = this.getHttpExchange();
            if (exchange != null) {
                this.responseContentAvailable(exchange);
            }
        } else {
            HttpConnectionOverFCGI httpConnection = this.getHttpConnection();
            boolean setFillInterest = httpConnection.parseAndFill(true);
            if (!this.hasContent() && setFillInterest) {
                httpConnection.fillInterested();
            }
        }
    }

    public void onInterim() {
        this.receive();
    }

    protected void reset() {
        super.reset();
        if (this.chunk != null) {
            this.chunk.release();
            this.chunk = null;
        }
    }

    protected void dispose() {
        super.dispose();
        if (this.chunk != null) {
            this.chunk.release();
            this.chunk = null;
        }
    }

    public Content.Chunk read(boolean fillInterestIfNeeded) {
        Content.Chunk chunk = this.consumeChunk();
        if (chunk != null) {
            return chunk;
        }
        HttpConnectionOverFCGI httpConnection = this.getHttpConnection();
        boolean needFillInterest = httpConnection.parseAndFill(false);
        chunk = this.consumeChunk();
        if (httpConnection.isComplete()) {
            httpConnection.complete();
        }
        if (chunk != null) {
            return chunk;
        }
        if (needFillInterest && fillInterestIfNeeded) {
            this.fillInterested();
        }
        return null;
    }

    private void fillInterested() {
        this.getHttpConnection().fillInterested(this.demandContentCallback);
    }

    private Content.Chunk consumeChunk() {
        Content.Chunk chunk = this.chunk;
        this.chunk = null;
        return chunk;
    }

    public void failAndClose(Throwable failure) {
        HttpConnectionOverFCGI httpConnection = this.getHttpConnection();
        this.responseFailure(failure, (Promise<Boolean>)Promise.from(failed -> {
            if (failed.booleanValue()) {
                httpConnection.close(failure);
            }
        }, x -> httpConnection.close(failure)));
    }

    void content(Content.Chunk chunk) {
        if (this.chunk != null) {
            throw new IllegalStateException();
        }
        chunk.retain();
        this.chunk = chunk;
    }

    void end() {
        if (this.chunk != null) {
            throw new IllegalStateException();
        }
        this.chunk = Content.Chunk.EOF;
    }

    void responseSuccess() {
        this.responseSuccess(this::receiveNext);
    }

    private void receiveNext() {
        if (this.hasContent()) {
            throw new IllegalStateException();
        }
        if (this.chunk != null) {
            throw new IllegalStateException();
        }
        HttpConnectionOverFCGI httpConnection = this.getHttpConnection();
        boolean setFillInterest = httpConnection.parseAndFill(true);
        if (!this.hasContent() && setFillInterest) {
            httpConnection.fillInterested();
        }
    }

    protected HttpChannelOverFCGI getHttpChannel() {
        return (HttpChannelOverFCGI)super.getHttpChannel();
    }

    private HttpConnectionOverFCGI getHttpConnection() {
        return this.getHttpChannel().getHttpConnection();
    }

    protected void responseBegin(HttpExchange exchange) {
        super.responseBegin(exchange);
    }

    protected void responseHeader(HttpExchange exchange, HttpField field) {
        super.responseHeader(exchange, field);
    }

    protected void responseHeaders(HttpExchange exchange) {
        super.responseHeaders(exchange);
    }

    protected void responseContentAvailable(HttpExchange exchange) {
        super.responseContentAvailable(exchange);
    }

    protected void responseFailure(Throwable failure, Promise<Boolean> promise) {
        super.responseFailure(failure, promise);
    }

    private class DemandContentCallback
    implements Callback {
        private DemandContentCallback() {
        }

        public void succeeded() {
            HttpReceiverOverFCGI.this.getHttpConnection().onFillable();
        }

        public void failed(Throwable failure) {
            HttpReceiverOverFCGI.this.getHttpConnection().onFillInterestedFailed(failure);
        }

        public Invocable.InvocationType getInvocationType() {
            return HttpReceiverOverFCGI.this.getInvocationType();
        }
    }
}

