/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.quic.quiche.server.internal;

import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.eclipse.jetty.quic.quiche.Quiche;

public class SimpleTokenMinter
implements Quiche.TokenMinter {
    private final InetSocketAddress inetSocketAddress;
    private final byte[] implName = "jetty".getBytes(StandardCharsets.US_ASCII);

    public SimpleTokenMinter(InetSocketAddress inetSocketAddress) {
        this.inetSocketAddress = inetSocketAddress;
    }

    public byte[] mint(byte[] dcid, int len) {
        byte[] address = this.inetSocketAddress.getAddress().getAddress();
        int port = this.inetSocketAddress.getPort();
        ByteBuffer token = ByteBuffer.allocate(this.implName.length + address.length + 2 + len);
        token.put(this.implName);
        token.put(address);
        token.putShort((short)port);
        token.put(dcid, 0, len);
        return token.array();
    }
}

