/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.demo;

import java.lang.management.ManagementFactory;
import java.net.MalformedURLException;
import javax.management.remote.JMXServiceURL;
import org.eclipse.jetty.demo.ExampleUtil;
import org.eclipse.jetty.jmx.ConnectorServer;
import org.eclipse.jetty.jmx.MBeanContainer;
import org.eclipse.jetty.server.Server;

public class ServerWithJMX {
    public static Server createServer(int port) throws MalformedURLException {
        Server server = new Server(port);
        MBeanContainer mbContainer = new MBeanContainer(ManagementFactory.getPlatformMBeanServer());
        server.addBean((Object)mbContainer);
        int jmxPort = 1099;
        ConnectorServer jmx = new ConnectorServer(new JMXServiceURL("rmi", null, jmxPort, "/jndi/rmi://localhost:" + jmxPort + "/jmxrmi"), "org.eclipse.jetty.jmx:name=rmiconnectorserver");
        server.addBean((Object)jmx);
        return server;
    }

    public static void main(String[] args) throws Exception {
        int port = ExampleUtil.getPort(args, "jetty.http.port", 8080);
        Server server = ServerWithJMX.createServer(port);
        server.start();
        server.dumpStdErr();
        server.join();
    }
}

