/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.quic.util;

import java.nio.ByteBuffer;
import java.util.function.LongConsumer;
import org.eclipse.jetty.quic.util.ErrorCode;
import org.eclipse.jetty.quic.util.QuicException;

public class VarLenInt {
    public static final long MAX_VALUE = 0x3FFFFFFFFFFFFFFFL;
    public static final int MAX_LENGTH = 8;
    private static final int ENCODING_MASK = 192;
    private static final int VALUE_MASK = 63;
    private int encoding = -1;
    private int length;
    private long value;

    public boolean tryDecode(ByteBuffer byteBuffer, LongConsumer consumer) {
        return this.tryDecode(byteBuffer, (int l, long v) -> consumer.accept(v));
    }

    public boolean tryDecode(ByteBuffer byteBuffer, IntLongConsumer consumer) {
        while (byteBuffer.hasRemaining()) {
            if (this.encoding < 0) {
                this.encoding = VarLenInt.lengthEncoding(byteBuffer);
                this.length = 1 << this.encoding;
                this.value = byteBuffer.get() & 0x3F;
                if (--this.length != 0) continue;
                return this.result(consumer);
            }
            if (this.length > 0) {
                this.value = VarLenInt.accumulateValue(this.value, byteBuffer.get());
                if (--this.length != 0) continue;
                return this.result(consumer);
            }
            throw new IllegalStateException();
        }
        return false;
    }

    private boolean result(IntLongConsumer consumer) {
        long result = this.value;
        int resultLength = 1 << this.encoding;
        this.encoding = -1;
        this.length = 0;
        this.value = 0L;
        consumer.accept(resultLength, result);
        return true;
    }

    public static int decodeInt(ByteBuffer byteBuffer) {
        return (int)VarLenInt.decode(byteBuffer, true);
    }

    public static long decodeLong(ByteBuffer byteBuffer) {
        return VarLenInt.decode(byteBuffer, false);
    }

    private static long decode(ByteBuffer buffer, boolean asInt) {
        int encoding = VarLenInt.lengthEncoding(buffer);
        if (asInt && encoding == 3) {
            throw new QuicException(ErrorCode.PROTOCOL_VIOLATION_ERROR, "invalid_variable_length_integer");
        }
        int length = 1 << encoding;
        long value = buffer.get() & 0x3F;
        for (int i = 1; i < length; ++i) {
            value = VarLenInt.accumulateValue(value, buffer.get());
        }
        return value;
    }

    private static int lengthEncoding(ByteBuffer byteBuffer) {
        byte hiByte = byteBuffer.get(byteBuffer.position());
        return (hiByte & 0xC0) >>> 6;
    }

    private static long accumulateValue(long value, byte bite) {
        return (value << 8) + (long)(bite & 0xFF);
    }

    public static void encode(ByteBuffer byteBuffer, long value) {
        int length = VarLenInt.length(value);
        int encoding = 31 - Integer.numberOfLeadingZeros(length);
        int position = byteBuffer.position();
        for (int i = length - 1; i > 0; --i) {
            byteBuffer.put(position + i, (byte)(value & 0xFFL));
            value >>>= 8;
        }
        byteBuffer.put(position, (byte)(value & 0x3FL | (long)(encoding << 6)));
        byteBuffer.position(position + length);
    }

    public static int length(long value) {
        if (value < 0L) {
            throw new QuicException(ErrorCode.PROTOCOL_VIOLATION_ERROR, "invalid_variable_length_integer");
        }
        if (value < 64L) {
            return 1;
        }
        if (value < 16384L) {
            return 2;
        }
        if (value < 0x40000000L) {
            return 4;
        }
        if (value < 0x4000000000000000L) {
            return 8;
        }
        throw new QuicException(ErrorCode.PROTOCOL_VIOLATION_ERROR, "invalid_variable_length_integer");
    }

    public static interface IntLongConsumer {
        public void accept(int var1, long var2);
    }
}

