# DO NOT EDIT THIS FILE - See: https://eclipse.dev/jetty/documentation/

[description]
Enables the DosHandler for the server.

[tags]
connector

[before]
compression
gzip

[depends]
server

[xml]
etc/jetty-dos.xml

[ini-template]
#tag::documentation[]
## The algorithm to use for obtaining an remote client identifier from a Request: ID_FROM_REMOTE_ADDRESS, ID_FROM_REMOTE_PORT, ID_FROM_REMOTE_ADDRESS_PORT, ID_FROM_CONNECTION
#jetty.dos.id.type=ID_FROM_REMOTE_ADDRESS
#jetty.dos.id.class=org.eclipse.jetty.server.handler.DosHandler

## The class to use to create Tracker instances to track the rate of requests
#jetty.dos.trackerFactory=org.eclipse.jetty.server.handler.DoSHandler$LeakingBucketTrackerFactory

## The Handler class to use to reject DOS requests
#jetty.dos.rejectHandler=org.eclipse.jetty.server.handler.DoSHandler$DelayedRejectHandler

## The maximum requests per second per client
#jetty.dos.leakingBucketTracker.maxRequestsPerSecond=100

## The size of the leaky bucket. Larger buckets allow longer bursts before enforcing the rate
#jetty.dos.leakingBucketTracker.bucketSize=100

## The time in seconds to retain an empty bucket.
#jetty.dos.leakingBucketTracker.idleTimeout=1

## The period to delay dos requests before rejecting them.
#jetty.dos.rejectHandler.delayed.delayMs=1000

## The maximum number of requests to be held in the delay queue
#jetty.dos.rejectHandler.delayed.maxDelayQueue=1000

## The maximum number of clients to track; or -1 for a default value; or 0 for unlimited
#jetty.dos.maxTrackers=100000

## Should untracked requests (due to maxTrackers) be rejected or allowed
#jetty.dos.rejectUntracked=false

## The status code used to reject requests; or 0 to abort the request; or -1 for a default
#jetty.dos.rejectStatus=429

## A comma-separated list of HTTP methods to include when matching a request.
# jetty.dos.include.method=

## A comma-separated list of HTTP methods to exclude when matching a request.
# jetty.dos.exclude.method=

## A comma-separated list of URI path patterns to include when matching a request.
# jetty.dos.include.path=

## A comma-separated list of URI path patterns to exclude when matching a request.
# jetty.dos.exclude.path=

## A comma-separated list of remote addresses patterns to include when matching a request.
# jetty.dos.include.inet=

## A comma-separated list of remote addresses patterns to exclude when matching a request.
# jetty.dos.exclude.inet=
#end::documentation[]
