# DO NOT EDIT THIS FILE - See: https://jetty.org/docs/

[description]
Enables the Zstandard compression algorithm in CompressionHandler.

[tags]
server
handler
compression
zstandard

[depend]
zstandard-compression
compression

[xml]
etc/jetty-compression-zstandard.xml

[ini-template]
# tag::documentation[]
## Minimum content length after which zstandard is enabled
# jetty.compression.zstandard.minCompressSize=48

## Buffer Size for Decoder
# If unspecified, this default comes from zstd-jni's integration with the zstd libs.
# jetty.compression.zstandard.decoder.bufferSize=128000

## Enable/Disable Magicless frames for Decoder
# Note: No browser zstandard implementations should be generating Magicless frames.
# Leave at false for maximum compatibility with known browsers.
# jetty.compression.zstandard.decoder.magicless=false

## Buffer Size for Encoder
# If unspecified, this default comes from zstd-jni's integration with the zstd libs.
# jetty.compression.zstandard.encoder.bufferSize=128000

## Compression Level for Encoder
# If unspecified, this default comes from the zstd-jni's integration with the zstd libs.
# valid values from 1 to 19
# jetty.compression.zstandard.encoder.compressionLevel=3

## Strategy for Encoder
# If unspecified, this default comes from the zstd-jni's integration with the zstd libs.
# See https://facebook.github.io/zstd/zstd_manual.html#Chapter5
# valid values from 1 to 9
# Leave at -1 for maximum compatibility with known browsers.
# jetty.compression.zstandard.encoder.strategy=-1

## Enable/Disable Magicless frames for Encoder
# Note: browser zstandard implementations require this to be false.
# jetty.compression.zstandard.encoder.magicless=false

# Enable/Disable compression checksums
# Note: browser zstandard implementations requires this to be false.
# jetty.compression.zstandard.encoder.checksum=false
# end::documentation[]
