/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee11.websocket.jakarta.client.internal;

import jakarta.websocket.ClientEndpointConfig;
import jakarta.websocket.HandshakeResponse;
import java.util.Map;
import org.eclipse.jetty.client.Request;
import org.eclipse.jetty.client.Response;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.websocket.core.client.UpgradeListener;

public class JsrUpgradeListener
implements UpgradeListener {
    private final ClientEndpointConfig.Configurator configurator;

    public JsrUpgradeListener(ClientEndpointConfig.Configurator configurator) {
        this.configurator = configurator;
    }

    public void onHandshakeRequest(Request request) {
        if (this.configurator == null) {
            return;
        }
        request.headers(headers -> {
            Map headersMap = HttpFields.asMap((HttpFields)headers);
            this.configurator.beforeRequest(headersMap);
        });
    }

    public void onHandshakeResponse(Request request, Response response) {
        if (this.configurator == null) {
            return;
        }
        HandshakeResponse handshakeResponse = () -> HttpFields.asMap((HttpFields)response.getHeaders());
        this.configurator.afterResponse(handshakeResponse);
    }
}

