/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.quic.common.internal.frames;

import java.nio.ByteBuffer;
import org.eclipse.jetty.quic.api.frames.StreamDataBlockedFrame;
import org.eclipse.jetty.quic.util.VarLenInt;

public class StreamDataBlockedParser {
    private final VarLenInt varLenInt;
    private State state = State.FRAME_TYPE;
    private long streamId;
    private long maxData;

    public StreamDataBlockedParser(VarLenInt varLenInt) {
        this.varLenInt = varLenInt;
    }

    public StreamDataBlockedFrame parse(ByteBuffer byteBuffer) {
        while (byteBuffer.hasRemaining()) {
            switch (this.state.ordinal()) {
                case 0: {
                    byteBuffer.get();
                    this.state = State.STREAM_ID;
                    break;
                }
                case 1: {
                    if (!this.varLenInt.tryDecode(byteBuffer, v -> {
                        this.streamId = v;
                    })) break;
                    this.state = State.MAX_DATA;
                    break;
                }
                case 2: {
                    if (!this.varLenInt.tryDecode(byteBuffer, v -> {
                        this.maxData = v;
                    })) break;
                    return this.result();
                }
            }
        }
        return null;
    }

    private StreamDataBlockedFrame result() {
        StreamDataBlockedFrame frame = new StreamDataBlockedFrame(this.streamId, this.maxData);
        this.state = State.FRAME_TYPE;
        this.streamId = 0L;
        this.maxData = 0L;
        return frame;
    }

    private static enum State {
        FRAME_TYPE,
        STREAM_ID,
        MAX_DATA;

    }
}

