/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.quic.common.frames;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.RetainableByteBuffer;
import org.eclipse.jetty.quic.api.frames.AckFrame;
import org.eclipse.jetty.quic.api.frames.ConnectionCloseFrame;
import org.eclipse.jetty.quic.api.frames.CryptoFrame;
import org.eclipse.jetty.quic.api.frames.DataBlockedFrame;
import org.eclipse.jetty.quic.api.frames.Frame;
import org.eclipse.jetty.quic.api.frames.MaxDataFrame;
import org.eclipse.jetty.quic.api.frames.MaxStreamsFrame;
import org.eclipse.jetty.quic.api.frames.NewConnectionIdFrame;
import org.eclipse.jetty.quic.api.frames.NewTokenFrame;
import org.eclipse.jetty.quic.api.frames.PathChallengeFrame;
import org.eclipse.jetty.quic.api.frames.PathResponseFrame;
import org.eclipse.jetty.quic.api.frames.ResetFrame;
import org.eclipse.jetty.quic.api.frames.RetireConnectionIdFrame;
import org.eclipse.jetty.quic.api.frames.StopSendingFrame;
import org.eclipse.jetty.quic.api.frames.StreamDataBlockedFrame;
import org.eclipse.jetty.quic.api.frames.StreamFrame;
import org.eclipse.jetty.quic.api.frames.StreamMaxDataFrame;
import org.eclipse.jetty.quic.api.frames.StreamsBlockedFrame;
import org.eclipse.jetty.quic.common.frames.FrameType;
import org.eclipse.jetty.quic.util.ErrorCode;
import org.eclipse.jetty.quic.util.QuicException;
import org.eclipse.jetty.quic.util.VarLenInt;
import org.eclipse.jetty.util.BufferUtil;

public class FrameGenerator {
    private final ByteBufferPool byteBufferPool;
    private boolean useDirectBuffers;

    public FrameGenerator(ByteBufferPool byteBufferPool) {
        this.byteBufferPool = byteBufferPool;
        this.setUseDirectBuffers(true);
    }

    public ByteBufferPool getByteBufferPool() {
        return this.byteBufferPool;
    }

    public boolean isUseDirectBuffers() {
        return this.useDirectBuffers;
    }

    public void setUseDirectBuffers(boolean useDirectBuffers) {
        this.useDirectBuffers = useDirectBuffers;
    }

    public long generate(ByteBufferPool.Accumulator accumulator, Frame frame) {
        long type = frame.getFrameType();
        FrameType frameType = FrameType.from(type);
        if (frameType == null) {
            throw new QuicException(ErrorCode.FRAME_ENCODING_ERROR, "invalid_frame_type", type);
        }
        return switch (frameType) {
            case FrameType.PADDING, FrameType.PING, FrameType.HANDSHAKE_DONE -> this.generateNoContentFrame(accumulator, frame);
            case FrameType.ACK -> this.generateAckFrame(accumulator, (AckFrame)frame);
            case FrameType.RESET_STREAM -> this.generateResetStreamFrame(accumulator, (ResetFrame)frame);
            case FrameType.STOP_SENDING -> this.generateStopSendingFrame(accumulator, (StopSendingFrame)frame);
            case FrameType.CRYPTO -> this.generateCryptoFrame(accumulator, (CryptoFrame)frame);
            case FrameType.NEW_TOKEN -> this.generateNewTokenFrame(accumulator, (NewTokenFrame)frame);
            case FrameType.MAX_DATA -> this.generateMaxDataFrame(accumulator, (MaxDataFrame)frame);
            case FrameType.STREAM_MAX_DATA -> this.generateStreamMaxDataFrame(accumulator, (StreamMaxDataFrame)frame);
            case FrameType.MAX_STREAMS -> this.generateMaxStreamsFrame(accumulator, (MaxStreamsFrame)frame);
            case FrameType.DATA_BLOCKED -> this.generateDataBlockedFrame(accumulator, (DataBlockedFrame)frame);
            case FrameType.STREAM_DATA_BLOCKED -> this.generateStreamDataBlockedFrame(accumulator, (StreamDataBlockedFrame)frame);
            case FrameType.STREAMS_BLOCKED -> this.generateStreamsBlockedFrame(accumulator, (StreamsBlockedFrame)frame);
            case FrameType.NEW_CONNECTION_ID -> this.generateNewConnectionIdFrame(accumulator, (NewConnectionIdFrame)frame);
            case FrameType.RETIRE_CONNECTION_ID -> this.generateRetireConnectionIdFrame(accumulator, (RetireConnectionIdFrame)frame);
            case FrameType.PATH_CHALLENGE -> this.generatePathChallengeFrame(accumulator, (PathChallengeFrame)frame);
            case FrameType.PATH_RESPONSE -> this.generatePathResponseFrame(accumulator, (PathResponseFrame)frame);
            case FrameType.CONNECTION_CLOSE -> this.generateConnectionCloseFrame(accumulator, (ConnectionCloseFrame)frame);
            default -> throw new QuicException(ErrorCode.FRAME_ENCODING_ERROR, "invalid_frame_type", type);
        };
    }

    public BytesGenerated generate(ByteBufferPool.Accumulator accumulator, StreamFrame frame, int maxDataBytes, int maxFrameBytes) {
        return this.generateStreamFrame(accumulator, frame, maxDataBytes, maxFrameBytes);
    }

    private long generateNoContentFrame(ByteBufferPool.Accumulator accumulator, Frame frame) {
        long frameType = frame.getFrameType();
        int capacity = VarLenInt.length((long)frameType);
        RetainableByteBuffer.Mutable buffer = this.byteBufferPool.acquire(capacity, this.isUseDirectBuffers());
        accumulator.append((RetainableByteBuffer)buffer);
        ByteBuffer byteBuffer = buffer.getByteBuffer();
        int position = BufferUtil.flipToFill((ByteBuffer)byteBuffer);
        VarLenInt.encode((ByteBuffer)byteBuffer, (long)frameType);
        BufferUtil.flipToFlush((ByteBuffer)byteBuffer, (int)position);
        return capacity;
    }

    private long generateAckFrame(ByteBufferPool.Accumulator accumulator, AckFrame frame) {
        long frameType = frame.getFrameType();
        int capacity = VarLenInt.length((long)frameType);
        long ackNumber = frame.getAckNumber();
        capacity += VarLenInt.length((long)ackNumber);
        long ackDelay = frame.getAckDelay();
        capacity += VarLenInt.length((long)ackDelay);
        List ranges = frame.getRanges();
        int rangeSize = ranges.size();
        capacity += VarLenInt.length((long)(rangeSize - 1));
        for (Integer range : ranges) {
            capacity += VarLenInt.length((long)range.intValue());
        }
        if (frameType == 3L) {
            capacity += VarLenInt.length((long)frame.getECT0Count()) + VarLenInt.length((long)frame.getECT1Count()) + VarLenInt.length((long)frame.getCECount());
        }
        RetainableByteBuffer.Mutable buffer = this.byteBufferPool.acquire(capacity, this.isUseDirectBuffers());
        accumulator.append((RetainableByteBuffer)buffer);
        ByteBuffer byteBuffer = buffer.getByteBuffer();
        int position = BufferUtil.flipToFill((ByteBuffer)byteBuffer);
        VarLenInt.encode((ByteBuffer)byteBuffer, (long)frameType);
        VarLenInt.encode((ByteBuffer)byteBuffer, (long)ackNumber);
        VarLenInt.encode((ByteBuffer)byteBuffer, (long)ackDelay);
        VarLenInt.encode((ByteBuffer)byteBuffer, (long)(rangeSize - 1));
        for (Integer range : ranges) {
            VarLenInt.encode((ByteBuffer)byteBuffer, (long)range.intValue());
        }
        if (frameType == 3L) {
            VarLenInt.encode((ByteBuffer)byteBuffer, (long)frame.getECT0Count());
            VarLenInt.encode((ByteBuffer)byteBuffer, (long)frame.getECT1Count());
            VarLenInt.encode((ByteBuffer)byteBuffer, (long)frame.getCECount());
        }
        BufferUtil.flipToFlush((ByteBuffer)byteBuffer, (int)position);
        return capacity;
    }

    private long generateResetStreamFrame(ByteBufferPool.Accumulator accumulator, ResetFrame frame) {
        long frameType = frame.getFrameType();
        int capacity = VarLenInt.length((long)frameType);
        long streamId = frame.getStreamId();
        capacity += VarLenInt.length((long)streamId);
        long errorCode = frame.getApplicationErrorCode();
        capacity += VarLenInt.length((long)errorCode);
        long finalSize = frame.getFinalSize();
        RetainableByteBuffer.Mutable buffer = this.byteBufferPool.acquire(capacity += VarLenInt.length((long)finalSize), this.isUseDirectBuffers());
        accumulator.append((RetainableByteBuffer)buffer);
        ByteBuffer byteBuffer = buffer.getByteBuffer();
        int position = BufferUtil.flipToFill((ByteBuffer)byteBuffer);
        VarLenInt.encode((ByteBuffer)byteBuffer, (long)frameType);
        VarLenInt.encode((ByteBuffer)byteBuffer, (long)streamId);
        VarLenInt.encode((ByteBuffer)byteBuffer, (long)errorCode);
        VarLenInt.encode((ByteBuffer)byteBuffer, (long)finalSize);
        BufferUtil.flipToFlush((ByteBuffer)byteBuffer, (int)position);
        return capacity;
    }

    private long generateStopSendingFrame(ByteBufferPool.Accumulator accumulator, StopSendingFrame frame) {
        long frameType = frame.getFrameType();
        int capacity = VarLenInt.length((long)frameType);
        long streamId = frame.getStreamId();
        capacity += VarLenInt.length((long)streamId);
        long errorCode = frame.getApplicationErrorCode();
        RetainableByteBuffer.Mutable buffer = this.byteBufferPool.acquire(capacity += VarLenInt.length((long)errorCode), this.isUseDirectBuffers());
        accumulator.append((RetainableByteBuffer)buffer);
        ByteBuffer byteBuffer = buffer.getByteBuffer();
        int position = BufferUtil.flipToFill((ByteBuffer)byteBuffer);
        VarLenInt.encode((ByteBuffer)byteBuffer, (long)frameType);
        VarLenInt.encode((ByteBuffer)byteBuffer, (long)streamId);
        VarLenInt.encode((ByteBuffer)byteBuffer, (long)errorCode);
        BufferUtil.flipToFlush((ByteBuffer)byteBuffer, (int)position);
        return capacity;
    }

    private long generateCryptoFrame(ByteBufferPool.Accumulator accumulator, CryptoFrame frame) {
        long frameType = frame.getFrameType();
        int capacity = VarLenInt.length((long)frameType);
        long offset = frame.getOffset();
        capacity += VarLenInt.length((long)offset);
        ByteBuffer data = frame.getData();
        int length = data.remaining();
        RetainableByteBuffer.Mutable buffer = this.byteBufferPool.acquire(capacity += VarLenInt.length((long)length), this.isUseDirectBuffers());
        accumulator.append((RetainableByteBuffer)buffer);
        ByteBuffer byteBuffer = buffer.getByteBuffer();
        int position = BufferUtil.flipToFill((ByteBuffer)byteBuffer);
        VarLenInt.encode((ByteBuffer)byteBuffer, (long)frameType);
        VarLenInt.encode((ByteBuffer)byteBuffer, (long)offset);
        VarLenInt.encode((ByteBuffer)byteBuffer, (long)length);
        BufferUtil.flipToFlush((ByteBuffer)byteBuffer, (int)position);
        accumulator.append((RetainableByteBuffer)RetainableByteBuffer.wrap((ByteBuffer)data));
        return capacity + length;
    }

    private long generateNewTokenFrame(ByteBufferPool.Accumulator accumulator, NewTokenFrame frame) {
        long frameType = frame.getFrameType();
        int capacity = VarLenInt.length((long)frameType);
        ByteBuffer token = frame.getToken();
        int length = token.remaining();
        RetainableByteBuffer.Mutable buffer = this.byteBufferPool.acquire(capacity += VarLenInt.length((long)length), this.isUseDirectBuffers());
        accumulator.append((RetainableByteBuffer)buffer);
        ByteBuffer byteBuffer = buffer.getByteBuffer();
        int position = BufferUtil.flipToFill((ByteBuffer)byteBuffer);
        VarLenInt.encode((ByteBuffer)byteBuffer, (long)frameType);
        VarLenInt.encode((ByteBuffer)byteBuffer, (long)length);
        BufferUtil.flipToFlush((ByteBuffer)byteBuffer, (int)position);
        accumulator.append((RetainableByteBuffer)RetainableByteBuffer.wrap((ByteBuffer)token));
        return capacity + length;
    }

    private BytesGenerated generateStreamFrame(ByteBufferPool.Accumulator accumulator, StreamFrame frame, int maxDataBytes, int maxFrameBytes) {
        boolean dataExceedsFrame;
        int dataBytesInFrame;
        boolean hasOffset;
        long frameType = frame.getFrameType();
        int capacity = VarLenInt.length((long)frameType);
        long streamId = frame.getStreamId();
        capacity += VarLenInt.length((long)streamId);
        long offset = frame.getOffset();
        boolean bl = hasOffset = offset > 0L || (frameType & 4L) == 4L;
        if (hasOffset) {
            capacity += VarLenInt.length((long)offset);
        }
        boolean hasLength = (frameType & 2L) == 2L;
        int dataLength = maxDataBytes;
        int dataLengthLength = 0;
        if (hasLength) {
            dataLengthLength = VarLenInt.length((long)dataLength);
        }
        if ((dataBytesInFrame = maxFrameBytes - capacity - dataLengthLength) < maxDataBytes) {
            hasLength = true;
            dataLength = dataBytesInFrame;
            dataLengthLength = VarLenInt.length((long)dataLength);
        }
        capacity += dataLengthLength;
        boolean endStream = (frameType & 1L) == 1L;
        ByteBuffer data = frame.getData();
        boolean bl2 = dataExceedsFrame = data.remaining() > dataLength;
        if (endStream && dataExceedsFrame) {
            frameType &= 0xFFFFFFFFFFFFFFFEL;
        }
        RetainableByteBuffer.Mutable buffer = this.byteBufferPool.acquire(capacity, this.isUseDirectBuffers());
        accumulator.append((RetainableByteBuffer)buffer);
        ByteBuffer byteBuffer = buffer.getByteBuffer();
        int position = BufferUtil.flipToFill((ByteBuffer)byteBuffer);
        VarLenInt.encode((ByteBuffer)byteBuffer, (long)frameType);
        VarLenInt.encode((ByteBuffer)byteBuffer, (long)streamId);
        if (hasOffset) {
            VarLenInt.encode((ByteBuffer)byteBuffer, (long)offset);
        }
        if (hasLength) {
            VarLenInt.encode((ByteBuffer)byteBuffer, (long)dataLength);
        }
        BufferUtil.flipToFlush((ByteBuffer)byteBuffer, (int)position);
        if (dataExceedsFrame) {
            position = data.position();
            ByteBuffer slice = data.slice(position, dataLength);
            data.position(position + dataLength);
            data = slice;
        }
        accumulator.append((RetainableByteBuffer)RetainableByteBuffer.wrap((ByteBuffer)data));
        return new BytesGenerated(dataLength, capacity + dataLength);
    }

    private long generateMaxDataFrame(ByteBufferPool.Accumulator accumulator, MaxDataFrame frame) {
        long frameType = frame.getFrameType();
        int capacity = VarLenInt.length((long)frameType);
        long maxData = frame.getMaxData();
        RetainableByteBuffer.Mutable buffer = this.byteBufferPool.acquire(capacity += VarLenInt.length((long)maxData), this.isUseDirectBuffers());
        accumulator.append((RetainableByteBuffer)buffer);
        ByteBuffer byteBuffer = buffer.getByteBuffer();
        int position = BufferUtil.flipToFill((ByteBuffer)byteBuffer);
        VarLenInt.encode((ByteBuffer)byteBuffer, (long)frameType);
        VarLenInt.encode((ByteBuffer)byteBuffer, (long)maxData);
        BufferUtil.flipToFlush((ByteBuffer)byteBuffer, (int)position);
        return capacity;
    }

    private long generateStreamMaxDataFrame(ByteBufferPool.Accumulator accumulator, StreamMaxDataFrame frame) {
        long frameType = frame.getFrameType();
        int capacity = VarLenInt.length((long)frameType);
        long streamId = frame.getStreamId();
        capacity += VarLenInt.length((long)streamId);
        long maxData = frame.getMaxData();
        RetainableByteBuffer.Mutable buffer = this.byteBufferPool.acquire(capacity += VarLenInt.length((long)maxData), this.isUseDirectBuffers());
        accumulator.append((RetainableByteBuffer)buffer);
        ByteBuffer byteBuffer = buffer.getByteBuffer();
        int position = BufferUtil.flipToFill((ByteBuffer)byteBuffer);
        VarLenInt.encode((ByteBuffer)byteBuffer, (long)frameType);
        VarLenInt.encode((ByteBuffer)byteBuffer, (long)streamId);
        VarLenInt.encode((ByteBuffer)byteBuffer, (long)maxData);
        BufferUtil.flipToFlush((ByteBuffer)byteBuffer, (int)position);
        return capacity;
    }

    private long generateMaxStreamsFrame(ByteBufferPool.Accumulator accumulator, MaxStreamsFrame frame) {
        long frameType = frame.getFrameType();
        int capacity = VarLenInt.length((long)frameType);
        long maxStreams = frame.getMaxStreams();
        RetainableByteBuffer.Mutable buffer = this.byteBufferPool.acquire(capacity += VarLenInt.length((long)maxStreams), this.isUseDirectBuffers());
        accumulator.append((RetainableByteBuffer)buffer);
        ByteBuffer byteBuffer = buffer.getByteBuffer();
        int position = BufferUtil.flipToFill((ByteBuffer)byteBuffer);
        VarLenInt.encode((ByteBuffer)byteBuffer, (long)frameType);
        VarLenInt.encode((ByteBuffer)byteBuffer, (long)maxStreams);
        BufferUtil.flipToFlush((ByteBuffer)byteBuffer, (int)position);
        return capacity;
    }

    private long generateDataBlockedFrame(ByteBufferPool.Accumulator accumulator, DataBlockedFrame frame) {
        long frameType = frame.getFrameType();
        int capacity = VarLenInt.length((long)frameType);
        long maxData = frame.getOffset();
        RetainableByteBuffer.Mutable buffer = this.byteBufferPool.acquire(capacity += VarLenInt.length((long)maxData), this.isUseDirectBuffers());
        accumulator.append((RetainableByteBuffer)buffer);
        ByteBuffer byteBuffer = buffer.getByteBuffer();
        int position = BufferUtil.flipToFill((ByteBuffer)byteBuffer);
        VarLenInt.encode((ByteBuffer)byteBuffer, (long)frameType);
        VarLenInt.encode((ByteBuffer)byteBuffer, (long)maxData);
        BufferUtil.flipToFlush((ByteBuffer)byteBuffer, (int)position);
        return capacity;
    }

    private long generateStreamDataBlockedFrame(ByteBufferPool.Accumulator accumulator, StreamDataBlockedFrame frame) {
        long frameType = frame.getFrameType();
        int capacity = VarLenInt.length((long)frameType);
        long streamId = frame.getStreamId();
        capacity += VarLenInt.length((long)streamId);
        long maxData = frame.getOffset();
        RetainableByteBuffer.Mutable buffer = this.byteBufferPool.acquire(capacity += VarLenInt.length((long)maxData), this.isUseDirectBuffers());
        accumulator.append((RetainableByteBuffer)buffer);
        ByteBuffer byteBuffer = buffer.getByteBuffer();
        int position = BufferUtil.flipToFill((ByteBuffer)byteBuffer);
        VarLenInt.encode((ByteBuffer)byteBuffer, (long)frameType);
        VarLenInt.encode((ByteBuffer)byteBuffer, (long)streamId);
        VarLenInt.encode((ByteBuffer)byteBuffer, (long)maxData);
        BufferUtil.flipToFlush((ByteBuffer)byteBuffer, (int)position);
        return capacity;
    }

    private long generateStreamsBlockedFrame(ByteBufferPool.Accumulator accumulator, StreamsBlockedFrame frame) {
        long frameType = frame.getFrameType();
        int capacity = VarLenInt.length((long)frameType);
        long maxStreams = frame.getMaxStreams();
        RetainableByteBuffer.Mutable buffer = this.byteBufferPool.acquire(capacity += VarLenInt.length((long)maxStreams), this.isUseDirectBuffers());
        accumulator.append((RetainableByteBuffer)buffer);
        ByteBuffer byteBuffer = buffer.getByteBuffer();
        int position = BufferUtil.flipToFill((ByteBuffer)byteBuffer);
        VarLenInt.encode((ByteBuffer)byteBuffer, (long)frameType);
        VarLenInt.encode((ByteBuffer)byteBuffer, (long)maxStreams);
        BufferUtil.flipToFlush((ByteBuffer)byteBuffer, (int)position);
        return capacity;
    }

    private long generateNewConnectionIdFrame(ByteBufferPool.Accumulator accumulator, NewConnectionIdFrame frame) {
        long frameType = frame.getFrameType();
        int capacity = VarLenInt.length((long)frameType);
        long sequenceNumber = frame.getSequenceNumber();
        capacity += VarLenInt.length((long)sequenceNumber);
        long retirePriorTo = frame.getRetirePriorTo();
        capacity += VarLenInt.length((long)retirePriorTo);
        byte[] connectionId = frame.getConnectionId();
        RetainableByteBuffer.Mutable buffer = this.byteBufferPool.acquire(capacity += VarLenInt.length((long)connectionId.length), this.isUseDirectBuffers());
        accumulator.append((RetainableByteBuffer)buffer);
        ByteBuffer byteBuffer = buffer.getByteBuffer();
        int position = BufferUtil.flipToFill((ByteBuffer)byteBuffer);
        VarLenInt.encode((ByteBuffer)byteBuffer, (long)frameType);
        VarLenInt.encode((ByteBuffer)byteBuffer, (long)sequenceNumber);
        VarLenInt.encode((ByteBuffer)byteBuffer, (long)retirePriorTo);
        VarLenInt.encode((ByteBuffer)byteBuffer, (long)connectionId.length);
        BufferUtil.flipToFlush((ByteBuffer)byteBuffer, (int)position);
        accumulator.append((RetainableByteBuffer)RetainableByteBuffer.wrap((ByteBuffer)ByteBuffer.wrap(connectionId)));
        byte[] resetToken = frame.getResetToken();
        accumulator.append((RetainableByteBuffer)RetainableByteBuffer.wrap((ByteBuffer)ByteBuffer.wrap(resetToken)));
        return capacity + connectionId.length + resetToken.length;
    }

    private long generateRetireConnectionIdFrame(ByteBufferPool.Accumulator accumulator, RetireConnectionIdFrame frame) {
        long frameType = frame.getFrameType();
        int capacity = VarLenInt.length((long)frameType);
        long sequenceNumber = frame.getSequenceNumber();
        RetainableByteBuffer.Mutable buffer = this.byteBufferPool.acquire(capacity += VarLenInt.length((long)sequenceNumber), this.isUseDirectBuffers());
        accumulator.append((RetainableByteBuffer)buffer);
        ByteBuffer byteBuffer = buffer.getByteBuffer();
        int position = BufferUtil.flipToFill((ByteBuffer)byteBuffer);
        VarLenInt.encode((ByteBuffer)byteBuffer, (long)frameType);
        VarLenInt.encode((ByteBuffer)byteBuffer, (long)sequenceNumber);
        BufferUtil.flipToFlush((ByteBuffer)byteBuffer, (int)position);
        return capacity;
    }

    private long generatePathChallengeFrame(ByteBufferPool.Accumulator accumulator, PathChallengeFrame frame) {
        long frameType = frame.getFrameType();
        int capacity = VarLenInt.length((long)frameType);
        long data = frame.getData();
        RetainableByteBuffer.Mutable buffer = this.byteBufferPool.acquire(capacity += 8, this.isUseDirectBuffers());
        accumulator.append((RetainableByteBuffer)buffer);
        ByteBuffer byteBuffer = buffer.getByteBuffer();
        int position = BufferUtil.flipToFill((ByteBuffer)byteBuffer);
        VarLenInt.encode((ByteBuffer)byteBuffer, (long)frameType);
        byteBuffer.putLong(data);
        BufferUtil.flipToFlush((ByteBuffer)byteBuffer, (int)position);
        return capacity;
    }

    private long generatePathResponseFrame(ByteBufferPool.Accumulator accumulator, PathResponseFrame frame) {
        long frameType = frame.getFrameType();
        int capacity = VarLenInt.length((long)frameType);
        long data = frame.getData();
        RetainableByteBuffer.Mutable buffer = this.byteBufferPool.acquire(capacity += 8, this.isUseDirectBuffers());
        accumulator.append((RetainableByteBuffer)buffer);
        ByteBuffer byteBuffer = buffer.getByteBuffer();
        int position = BufferUtil.flipToFill((ByteBuffer)byteBuffer);
        VarLenInt.encode((ByteBuffer)byteBuffer, (long)frameType);
        byteBuffer.putLong(data);
        BufferUtil.flipToFlush((ByteBuffer)byteBuffer, (int)position);
        return capacity;
    }

    private long generateConnectionCloseFrame(ByteBufferPool.Accumulator accumulator, ConnectionCloseFrame frame) {
        long frameType = frame.getFrameType();
        int capacity = VarLenInt.length((long)frameType);
        long errorCode = frame.getErrorCode();
        capacity += VarLenInt.length((long)errorCode);
        long causeFrameType = frame.getCauseFrameType();
        if (frameType == 28L) {
            capacity += VarLenInt.length((long)causeFrameType);
        }
        String reason = frame.getReason();
        ByteBuffer reasonBytes = StandardCharsets.UTF_8.encode(reason);
        int reasonLength = reasonBytes.remaining();
        RetainableByteBuffer.Mutable buffer = this.byteBufferPool.acquire(capacity += VarLenInt.length((long)reasonLength), this.isUseDirectBuffers());
        accumulator.append((RetainableByteBuffer)buffer);
        ByteBuffer byteBuffer = buffer.getByteBuffer();
        int position = BufferUtil.flipToFill((ByteBuffer)byteBuffer);
        VarLenInt.encode((ByteBuffer)byteBuffer, (long)frameType);
        VarLenInt.encode((ByteBuffer)byteBuffer, (long)errorCode);
        if (frameType == 28L) {
            VarLenInt.encode((ByteBuffer)byteBuffer, (long)causeFrameType);
        }
        VarLenInt.encode((ByteBuffer)byteBuffer, (long)reasonLength);
        BufferUtil.flipToFlush((ByteBuffer)byteBuffer, (int)position);
        accumulator.append((RetainableByteBuffer)RetainableByteBuffer.wrap((ByteBuffer)reasonBytes));
        return capacity + reasonLength;
    }

    public record BytesGenerated(int dataBytes, int frameBytes) {
    }
}

