/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.quic.common;

import java.io.IOException;
import java.util.EventListener;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.jetty.quic.api.Session;
import org.eclipse.jetty.quic.common.AbstractSession;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.component.DumpableCollection;
import org.eclipse.jetty.util.component.Graceful;

@ManagedObject(value="The container of QUIC sessions")
public class SessionContainer
extends AbstractLifeCycle
implements EventListener,
Session.Listener,
Graceful,
Dumpable {
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Set<Session> sessions = ConcurrentHashMap.newKeySet();
    private CompletableFuture<Void> shutdown;

    public void onOpen(Session session) {
        boolean isShutDown = false;
        this.lock.readLock().lock();
        try {
            if (this.shutdown == null) {
                this.sessions.add(session);
            } else {
                isShutDown = true;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        if (isShutDown) {
            this.shutdown(session);
        }
    }

    public void onDisconnect(Session session) {
        this.lock.readLock().lock();
        try {
            this.sessions.remove(session);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public CompletableFuture<Void> shutdown() {
        this.lock.writeLock().lock();
        try {
            if (this.shutdown != null) {
                CompletableFuture<Void> completableFuture = this.shutdown;
                return completableFuture;
            }
            CompletableFuture[] shutdowns = (CompletableFuture[])this.sessions.stream().map(this::shutdown).toArray(CompletableFuture[]::new);
            this.shutdown = CompletableFuture.allOf(shutdowns);
            CompletableFuture<Void> completableFuture = this.shutdown;
            return completableFuture;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private CompletableFuture<Session> shutdown(Session session) {
        return ((AbstractSession)session).shutdown();
    }

    public boolean isShutdown() {
        this.lock.readLock().lock();
        try {
            boolean bl = this.shutdown != null;
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public boolean isEmpty() {
        return this.sessions.isEmpty();
    }

    @ManagedAttribute(value="The number of QUIC sessions in this container")
    public int getSize() {
        return this.sessions.size();
    }

    public String dump() {
        return Dumpable.dump((Dumpable)this);
    }

    public void dump(Appendable out, String indent) throws IOException {
        Dumpable.dumpObjects((Appendable)out, (String)indent, (Object)this, (Object[])new Object[]{new DumpableCollection("sessions", this.sessions)});
    }

    public String toString() {
        return String.format("%s@%x[size=%d]", TypeUtil.toShortName(this.getClass()), this.hashCode(), this.sessions.size());
    }
}

