/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.fcgi.generator;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import org.eclipse.jetty.fcgi.FCGI;
import org.eclipse.jetty.fcgi.generator.Generator;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpStatus;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.RetainableByteBuffer;
import org.eclipse.jetty.util.BufferUtil;

public class ServerGenerator
extends Generator {
    private static final byte[] STATUS = new byte[]{83, 116, 97, 116, 117, 115};
    private static final byte[] COLON = new byte[]{58, 32};
    private static final byte[] EOL = new byte[]{13, 10};
    private final boolean sendStatus200;

    public ServerGenerator(ByteBufferPool bufferPool) {
        this(bufferPool, true, true);
    }

    public ServerGenerator(ByteBufferPool bufferPool, boolean useDirectByteBuffers, boolean sendStatus200) {
        super(bufferPool, useDirectByteBuffers);
        this.sendStatus200 = sendStatus200;
    }

    public void generateResponseHeaders(ByteBufferPool.Accumulator accumulator, int request, int code, String reason, HttpFields fields) {
        request &= 0xFFFF;
        Charset utf8 = StandardCharsets.UTF_8;
        ArrayList<Object> bytes = new ArrayList<Object>(fields.size() * 2);
        int length = 0;
        if (code != 200 || this.sendStatus200) {
            bytes.add(STATUS);
            length += STATUS.length + COLON.length;
            if (reason == null) {
                reason = HttpStatus.getMessage((int)code);
            }
            Object responseBytes = (code + " " + reason).getBytes(utf8);
            bytes.add(responseBytes);
            length += ((Object)responseBytes).length + EOL.length;
        }
        for (HttpField field : fields) {
            String name = field.getName();
            byte[] nameBytes = name.getBytes(utf8);
            bytes.add(nameBytes);
            String value = field.getValue();
            byte[] valueBytes = value.getBytes(utf8);
            bytes.add(valueBytes);
            length += nameBytes.length + COLON.length;
            length += valueBytes.length + EOL.length;
        }
        ByteBuffer byteBuffer = BufferUtil.allocate((int)(length += EOL.length), (boolean)this.isUseDirectByteBuffers());
        BufferUtil.clearToFill((ByteBuffer)byteBuffer);
        for (int i = 0; i < bytes.size(); i += 2) {
            byteBuffer.put((byte[])bytes.get(i)).put(COLON).put((byte[])bytes.get(i + 1)).put(EOL);
        }
        byteBuffer.put(EOL);
        BufferUtil.flipToFlush((ByteBuffer)byteBuffer, (int)0);
        this.generateContent(accumulator, request, byteBuffer, false, FCGI.FrameType.STDOUT);
    }

    public void generateResponseContent(ByteBufferPool.Accumulator accumulator, int request, ByteBuffer content, boolean lastContent, boolean aborted) {
        if (aborted) {
            if (lastContent) {
                accumulator.append(this.generateEndRequest(request, true));
            } else {
                accumulator.append((RetainableByteBuffer)RetainableByteBuffer.wrap((ByteBuffer)BufferUtil.EMPTY_BUFFER));
            }
        } else {
            this.generateContent(accumulator, request, content, lastContent, FCGI.FrameType.STDOUT);
            if (lastContent) {
                accumulator.append(this.generateEndRequest(request, false));
            }
        }
    }

    private RetainableByteBuffer generateEndRequest(int request, boolean aborted) {
        RetainableByteBuffer.Mutable endRequestBuffer = this.getByteBufferPool().acquire(16, this.isUseDirectByteBuffers());
        ByteBuffer byteBuffer = endRequestBuffer.getByteBuffer();
        BufferUtil.clearToFill((ByteBuffer)byteBuffer);
        byteBuffer.putInt(0x1030000 + (request &= 0xFFFF));
        byteBuffer.putInt(524288);
        byteBuffer.putInt(aborted ? 1 : 0);
        byteBuffer.putInt(0);
        BufferUtil.flipToFlush((ByteBuffer)byteBuffer, (int)0);
        return endRequestBuffer;
    }
}

