/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee9.websocket.jakarta.client;

import jakarta.websocket.ClientEndpoint;
import jakarta.websocket.Endpoint;
import jakarta.websocket.EndpointConfig;
import org.eclipse.jetty.ee9.websocket.jakarta.client.internal.BasicClientEndpointConfig;
import org.eclipse.jetty.ee9.websocket.jakarta.common.JakartaWebSocketContainer;
import org.eclipse.jetty.ee9.websocket.jakarta.common.JakartaWebSocketFrameHandlerFactory;
import org.eclipse.jetty.ee9.websocket.jakarta.common.JakartaWebSocketFrameHandlerMetadata;
import org.eclipse.jetty.websocket.core.util.InvokerUtils;

public class JakartaWebSocketClientFrameHandlerFactory
extends JakartaWebSocketFrameHandlerFactory {
    public JakartaWebSocketClientFrameHandlerFactory(JakartaWebSocketContainer container, InvokerUtils.ParamIdentifier paramIdentifier) {
        super(container, paramIdentifier);
    }

    public JakartaWebSocketClientFrameHandlerFactory(JakartaWebSocketContainer container) {
        super(container, InvokerUtils.PARAM_IDENTITY);
    }

    public EndpointConfig newDefaultEndpointConfig(Class<?> endpointClass) {
        return new BasicClientEndpointConfig();
    }

    public JakartaWebSocketFrameHandlerMetadata getMetadata(Class<?> endpointClass, EndpointConfig endpointConfig) {
        if (Endpoint.class.isAssignableFrom(endpointClass)) {
            return this.createEndpointMetadata(endpointConfig);
        }
        if (endpointClass.getAnnotation(ClientEndpoint.class) == null) {
            return null;
        }
        JakartaWebSocketFrameHandlerMetadata metadata = new JakartaWebSocketFrameHandlerMetadata(endpointConfig, this.components);
        return this.discoverJakartaFrameHandlerMetadata(endpointClass, metadata);
    }
}

