/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http3.generator;

import java.util.function.Consumer;
import org.eclipse.jetty.http3.frames.Frame;
import org.eclipse.jetty.http3.frames.FrameType;
import org.eclipse.jetty.http3.generator.CancelPushGenerator;
import org.eclipse.jetty.http3.generator.FrameGenerator;
import org.eclipse.jetty.http3.generator.GoAwayGenerator;
import org.eclipse.jetty.http3.generator.MaxPushIdGenerator;
import org.eclipse.jetty.http3.generator.SettingsGenerator;
import org.eclipse.jetty.io.ByteBufferPool;

public class ControlGenerator {
    private final FrameGenerator[] generators = new FrameGenerator[FrameType.maxType() + 1];

    public ControlGenerator(ByteBufferPool bufferPool, boolean useDirectByteBuffers) {
        this.generators[FrameType.CANCEL_PUSH.type()] = new CancelPushGenerator(bufferPool);
        this.generators[FrameType.SETTINGS.type()] = new SettingsGenerator(bufferPool, useDirectByteBuffers);
        this.generators[FrameType.GOAWAY.type()] = new GoAwayGenerator(bufferPool, useDirectByteBuffers);
        this.generators[FrameType.MAX_PUSH_ID.type()] = new MaxPushIdGenerator(bufferPool);
    }

    public long generate(ByteBufferPool.Accumulator accumulator, long streamId, Frame frame, Consumer<Throwable> fail) {
        return this.generators[frame.getFrameType().type()].generate(accumulator, streamId, frame, fail);
    }
}

