/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.quic.util;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ErrorCode {
    public static final ErrorCode NO_ERROR = new ErrorCode(0L);
    public static final ErrorCode INTERNAL_ERROR = new ErrorCode(1L);
    public static final ErrorCode CONNECTION_REFUSED_ERROR = new ErrorCode(2L);
    public static final ErrorCode FLOW_CONTROL_ERROR = new ErrorCode(3L);
    public static final ErrorCode STREAM_LIMIT_ERROR = new ErrorCode(4L);
    public static final ErrorCode STREAM_STATE_ERROR = new ErrorCode(5L);
    public static final ErrorCode FINAL_SIZE_ERROR = new ErrorCode(6L);
    public static final ErrorCode FRAME_ENCODING_ERROR = new ErrorCode(7L);
    public static final ErrorCode TRANSPORT_PARAMETER_ERROR = new ErrorCode(8L);
    public static final ErrorCode CONNECTION_ID_LIMIT_ERROR = new ErrorCode(9L);
    public static final ErrorCode PROTOCOL_VIOLATION_ERROR = new ErrorCode(10L);
    public static final ErrorCode INVALID_TOKEN_ERROR = new ErrorCode(11L);
    public static final ErrorCode APPLICATION_ERROR = new ErrorCode(12L);
    public static final ErrorCode CRYPTO_BUFFER_EXCEEDED_ERROR = new ErrorCode(13L);
    public static final ErrorCode KEY_UPDATE_ERROR = new ErrorCode(14L);
    public static final ErrorCode AEAD_LIMIT_REACHED = new ErrorCode(15L);
    private final long code;

    private ErrorCode(long code) {
        this.code = code;
        Codes.codes.putIfAbsent(code, this);
    }

    public long code() {
        return this.code;
    }

    public boolean isCrypto() {
        return ErrorCode.isCrypto(this.code);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ErrorCode) {
            ErrorCode errorCode = (ErrorCode)obj;
            return this.code == errorCode.code;
        }
        return false;
    }

    public int hashCode() {
        return Long.hashCode(this.code);
    }

    public String toString() {
        return "%s[0x%x]".formatted(this.getClass().getSimpleName(), this.code);
    }

    private static boolean isCrypto(long code) {
        return 256L <= code && code <= 511L;
    }

    public static ErrorCode from(long code) {
        ErrorCode result = Codes.codes.get(code);
        if (result == null && ErrorCode.isCrypto(code)) {
            result = new ErrorCode(code);
        }
        return result;
    }

    private static class Codes {
        private static final Map<Long, ErrorCode> codes = new ConcurrentHashMap<Long, ErrorCode>();

        private Codes() {
        }
    }
}

