/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.security.siwe.internal;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jetty.security.ServerAuthException;
import org.eclipse.jetty.security.siwe.EthereumAuthenticator;
import org.eclipse.jetty.util.IncludeExcludeSet;
import org.eclipse.jetty.util.StringUtil;

public record SignInWithEthereumToken(String scheme, String domain, String address, String statement, String uri, String version, String chainId, String nonce, String issuedAt, String expirationTime, String notBefore, String requestId, String resources) {
    private static final String SCHEME_PATTERN = "[a-zA-Z][a-zA-Z0-9+\\-.]*";
    private static final String DOMAIN_PATTERN = "(?:[a-zA-Z0-9\\-._~%]+@)?[a-zA-Z0-9\\-._~%]+(?:\\:[0-9]+)?";
    private static final String ADDRESS_PATTERN = "0x[0-9a-fA-F]{40}";
    private static final String STATEMENT_PATTERN = "[^\\n]*";
    private static final String URI_PATTERN = "[^\\n]+";
    private static final String VERSION_PATTERN = "[0-9]+";
    private static final String CHAIN_ID_PATTERN = "[0-9]+";
    private static final String NONCE_PATTERN = "[a-zA-Z0-9]{8}";
    private static final String DATE_TIME_PATTERN = "\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}(?:\\.\\d+)?(?:Z|[+-]\\d{2}:\\d{2})?";
    private static final String REQUEST_ID_PATTERN = "[^\\n]*";
    private static final String RESOURCE_PATTERN = "- [^\\n]+";
    private static final String RESOURCES_PATTERN = "(?:\n- [^\\n]+)*";
    private static final Pattern SIGN_IN_WITH_ETHEREUM_PATTERN = Pattern.compile("^(?:(?<scheme>[a-zA-Z][a-zA-Z0-9+\\-.]*)://)?(?<domain>(?:[a-zA-Z0-9\\-._~%]+@)?[a-zA-Z0-9\\-._~%]+(?:\\:[0-9]+)?) wants you to sign in with your Ethereum account:\n(?<address>0x[0-9a-fA-F]{40})\n\n(?<statement>[^\\n]*)?\n\nURI: (?<uri>[^\\n]+)\nVersion: (?<version>[0-9]+)\nChain ID: (?<chainId>[0-9]+)\nNonce: (?<nonce>[a-zA-Z0-9]{8})\nIssued At: (?<issuedAt>\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}(?:\\.\\d+)?(?:Z|[+-]\\d{2}:\\d{2})?)(?:\nExpiration Time: (?<expirationTime>\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}(?:\\.\\d+)?(?:Z|[+-]\\d{2}:\\d{2})?))?(?:\nNot Before: (?<notBefore>\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}(?:\\.\\d+)?(?:Z|[+-]\\d{2}:\\d{2})?))?(?:\nRequest ID: (?<requestId>[^\\n]*))?(?:\nResources:(?<resources>(?:\n- [^\\n]+)*))?$", 32);

    public static SignInWithEthereumToken from(String message) {
        Matcher matcher = SIGN_IN_WITH_ETHEREUM_PATTERN.matcher(message);
        if (!matcher.matches()) {
            return null;
        }
        return new SignInWithEthereumToken(matcher.group("scheme"), matcher.group("domain"), matcher.group("address"), matcher.group("statement"), matcher.group("uri"), matcher.group("version"), matcher.group("chainId"), matcher.group("nonce"), matcher.group("issuedAt"), matcher.group("expirationTime"), matcher.group("notBefore"), matcher.group("requestId"), matcher.group("resources"));
    }

    public void validate(EthereumAuthenticator.SignedMessage signedMessage, Predicate<String> validateNonce, IncludeExcludeSet<String, String> domains, IncludeExcludeSet<String, String> chainIds) throws ServerAuthException {
        LocalDateTime notBefore;
        LocalDateTime expirationTime;
        if (validateNonce != null && !validateNonce.test(this.nonce())) {
            throw new ServerAuthException("invalid nonce " + this.nonce);
        }
        if (!StringUtil.asciiEqualsIgnoreCase((String)signedMessage.recoverAddress(), (String)this.address())) {
            throw new ServerAuthException("signature verification failed");
        }
        if (!"1".equals(this.version())) {
            throw new ServerAuthException("unsupported version " + this.version);
        }
        LocalDateTime now = LocalDateTime.now();
        if (StringUtil.isNotBlank((String)this.expirationTime()) && now.isAfter(expirationTime = LocalDateTime.parse(this.expirationTime(), DateTimeFormatter.ISO_DATE_TIME))) {
            throw new ServerAuthException("expired SIWE message");
        }
        if (StringUtil.isNotBlank((String)this.notBefore()) && now.isBefore(notBefore = LocalDateTime.parse(this.notBefore(), DateTimeFormatter.ISO_DATE_TIME))) {
            throw new ServerAuthException("SIWE message not yet valid");
        }
        if (domains != null && !domains.test((Object)this.domain())) {
            throw new ServerAuthException("unregistered domain: " + this.domain());
        }
        if (chainIds != null && !chainIds.test((Object)this.chainId())) {
            throw new ServerAuthException("unregistered chainId: " + this.chainId());
        }
    }
}

